/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.ir;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.nd4j.common.config.ND4JClassLoading;
import org.nd4j.common.io.ClassPathResource;
import org.nd4j.ir.OpNamespace;
import org.nd4j.shade.protobuf.Message;
import org.nd4j.shade.protobuf.TextFormat;

public class OpDescriptorHolder {
    public static String nd4jFileNameTextDefault = "/nd4j-op-def.pbtxt";
    public static String nd4jFileSpecifierProperty = "samediff.import.nd4jdescriptors";
    public static OpNamespace.OpDescriptorList INSTANCE;
    private static Map<String, OpNamespace.OpDescriptor> opDescriptorByName;

    public static OpNamespace.OpDescriptor descriptorForOpName(String name) {
        return opDescriptorByName.get(name);
    }

    public static OpNamespace.OpDescriptorList opList() {
        return INSTANCE;
    }

    public static OpNamespace.OpDescriptorList nd4jOpList() throws IOException {
        String fileName = System.getProperty(nd4jFileSpecifierProperty, nd4jFileNameTextDefault);
        InputStream nd4jOpDescriptorResourceStream = new ClassPathResource(fileName, ND4JClassLoading.getNd4jClassloader()).getInputStream();
        String resourceString = IOUtils.toString((InputStream)nd4jOpDescriptorResourceStream, (Charset)Charset.defaultCharset());
        OpNamespace.OpDescriptorList.Builder descriptorListBuilder = OpNamespace.OpDescriptorList.newBuilder();
        TextFormat.merge(resourceString, (Message.Builder)descriptorListBuilder);
        OpNamespace.OpDescriptorList ret = descriptorListBuilder.build();
        ArrayList<OpNamespace.OpDescriptor> mutableList = new ArrayList<OpNamespace.OpDescriptor>(ret.getOpListList());
        Collections.sort(mutableList, Comparator.comparing(OpNamespace.OpDescriptor::getName));
        OpNamespace.OpDescriptorList.Builder newResultBuilder = OpNamespace.OpDescriptorList.newBuilder();
        newResultBuilder.addAllOpList(mutableList);
        return newResultBuilder.build();
    }

    static {
        try {
            INSTANCE = OpDescriptorHolder.nd4jOpList();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        opDescriptorByName = new LinkedHashMap<String, OpNamespace.OpDescriptor>();
        for (int i = 0; i < INSTANCE.getOpListCount(); ++i) {
            opDescriptorByName.put(INSTANCE.getOpList(i).getName(), INSTANCE.getOpList(i));
        }
    }
}

