/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.api.ops.TransformSameOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;

public abstract class BaseTransformSameOp
extends BaseTransformOp
implements TransformSameOp {
    public BaseTransformSameOp(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2) {
        super(sameDiff, i_v1, i_v2);
    }

    public BaseTransformSameOp(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, boolean inPlace) {
        super(sameDiff, i_v1, i_v2, inPlace);
    }

    public BaseTransformSameOp(SameDiff sameDiff) {
        super(sameDiff);
    }

    public BaseTransformSameOp(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, Object[] extraArgs) {
        super(sameDiff, i_v1, i_v2, extraArgs);
    }

    public BaseTransformSameOp(SameDiff sameDiff, SDVariable i_v, boolean inPlace) {
        super(sameDiff, i_v, inPlace);
    }

    public BaseTransformSameOp(SameDiff sameDiff, SDVariable i_v, long[] shape, boolean inPlace, Object[] extraArgs) {
        super(sameDiff, i_v, shape, inPlace, extraArgs);
    }

    public BaseTransformSameOp(SameDiff sameDiff, SDVariable i_v, Object[] extraArgs) {
        super(sameDiff, i_v, extraArgs);
    }

    public BaseTransformSameOp(INDArray x, INDArray z) {
        super(x, z);
    }

    public BaseTransformSameOp(INDArray x, INDArray y, INDArray z) {
        super(x, y, z);
    }

    public BaseTransformSameOp() {
    }

    public BaseTransformSameOp(INDArray x) {
        super(x);
    }

    @Override
    public Op.Type getOpType() {
        return Op.Type.TRANSFORM_SAME;
    }

    @Override
    public Op.Type opType() {
        return Op.Type.TRANSFORM_SAME;
    }

    @Override
    public DataType resultType() {
        return this.x().dataType();
    }

    @Override
    public DataType resultType(OpContext oc) {
        return oc.getInputArray(0).dataType();
    }

    @Override
    public boolean validateDataTypes(OpContext oc, boolean experimentalMode) {
        INDArray z;
        INDArray x = oc != null ? oc.getInputArray(0) : this.x();
        INDArray y = oc != null ? oc.getInputArray(1) : this.y();
        INDArray iNDArray = z = oc != null ? oc.getOutputArray(0) : this.z();
        if (y != null) {
            Preconditions.checkArgument(x.dataType() == y.dataType(), "Op.X type must be the same as Op.Y type: x.datatype=%s, y.datatype=%s for op %s", (Object)x.dataType(), (Object)y.dataType(), this.getClass());
        }
        if (z != null) {
            Preconditions.checkArgument(z.dataType() == x.dataType(), "Op.Z must be the same as Op.X type: x.datatype=%s, z.datatype=%s for op %s", (Object)x.dataType(), (Object)z.dataType(), this.getClass());
        }
        return true;
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        return this.calculateOutputShape(null);
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape(OpContext oc) {
        INDArray x;
        INDArray iNDArray = x = oc != null ? oc.getInputArray(0) : this.x();
        if (x == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(LongShapeDescriptor.fromShape(x.shape(), x.dataType()));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState(dataTypes != null, "Expected exactly 1 or more input datatype for %s, got input %s", this.getClass(), dataTypes);
        DataType check = null;
        for (DataType dataType : dataTypes) {
            if (check != null) {
                Preconditions.checkState(dataType == check, "Data types must all be the same!");
                continue;
            }
            check = dataType;
        }
        return Arrays.asList(dataTypes.get(0));
    }
}

