/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.custom;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.custom.TriuBp;

public class Triu
extends DynamicCustomOp {
    private int diag = 0;

    public Triu(SameDiff sameDiff, SDVariable in, int diag2) {
        super(sameDiff, new SDVariable[]{in});
        this.addIArgument(diag2);
        this.diag = diag2;
    }

    public Triu(SameDiff sameDiff, SDVariable in) {
        super(sameDiff, new SDVariable[]{in});
    }

    public Triu(INDArray input, int diag2) {
        super(new INDArray[]{input}, null);
        this.addIArgument(diag2);
        this.diag = diag2;
    }

    @Override
    public String opName() {
        return "triu";
    }

    @Override
    public void configureFromArguments() {
        if (!this.iArguments.isEmpty()) {
            this.diag = ((Long)this.iArguments.get(0)).intValue();
        }
    }

    @Override
    public void setPropertiesForFunction(Map<String, Object> properties) {
        if (properties.containsKey("diag")) {
            Long diag2 = (Long)properties.get("diag");
            this.diag = diag2.intValue();
        }
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        return Collections.singletonList(this.arg(0).dataType());
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return new TriuBp(this.sameDiff, this.arg(0), f1.get(0), this.diag).outputs();
    }

    public Triu() {
    }
}

