/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.controlflow.compat;

import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.BaseCompatOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Enter
extends BaseCompatOp {
    protected boolean isConstant;
    public static final String OP_NAME = "enter";
    public static final int OP_NUM = 100;

    public Enter() {
    }

    public Enter(SameDiff sameDiff, SDVariable[] inputs) {
        super(sameDiff, inputs);
    }

    public Enter(SameDiff sameDiff, String frameName, SDVariable input) {
        super(sameDiff, new SDVariable[]{input});
        this.frameName = frameName;
        this.isConstant = input.isConstant();
    }

    public Enter(SameDiff sameDiff, String frameName, SDVariable input, boolean isConstant) {
        super(sameDiff, new SDVariable[]{input});
        this.frameName = frameName;
        this.isConstant = isConstant;
    }

    @Override
    public String opName() {
        return OP_NAME;
    }

    @Override
    public String tensorflowName() {
        return "Enter";
    }

    @Override
    public Op.Type opType() {
        return Op.Type.LOGIC;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        super.initFromTensorFlow(nodeDef, initWith, attributesForNode, graph);
        this.isConstant = attributesForNode.get("is_constant").getB();
    }

    @Override
    public void configureFromArguments() {
        if (!this.bArguments.isEmpty()) {
            this.isConstant = (Boolean)this.bArguments.get(0);
        }
    }

    @Override
    public void setPropertiesForFunction(Map<String, Object> properties) {
        if (properties.containsKey("frameName")) {
            String frameName;
            this.frameName = frameName = this.getStringFromProperty("frameName", properties);
        }
        if (properties.containsKey("isConstant")) {
            Boolean isConstant = this.getBooleanFromProperty("isConstant", properties);
            this.isConstant = isConstant;
        }
    }

    @Override
    public int getNumOutputs() {
        return 1;
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() == 1, "Expected 1 input datatype for %s, got %s", this.getClass(), inputDataTypes);
        return inputDataTypes;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public void setConstant(boolean isConstant) {
        this.isConstant = isConstant;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Enter)) {
            return false;
        }
        Enter other = (Enter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.isConstant() == other.isConstant();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Enter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isConstant() ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "Enter(isConstant=" + this.isConstant() + ")";
    }
}

