/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.image;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.enums.CoordinateTransformationMode;
import org.nd4j.enums.ImageResizeMethod;
import org.nd4j.enums.NearestMode;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class ImageResize
extends DynamicCustomOp {
    @Override
    public String opName() {
        return "image_resize";
    }

    public ImageResize(@NonNull SameDiff sameDiff, @NonNull SDVariable in, @NonNull SDVariable size2, boolean preserveAspectRatio, boolean antialias, ImageResizeMethod method) {
        super("image_resize", sameDiff, new SDVariable[]{in, size2});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (size2 == null) {
            throw new NullPointerException("size is marked non-null but is null");
        }
        this.addBArgument(preserveAspectRatio, antialias);
        this.addIArgument(method.methodIndex());
    }

    public ImageResize(@NonNull INDArray in, @NonNull INDArray size2, boolean preserveAspectRatio, boolean antialias, ImageResizeMethod method) {
        super("image_resize", new INDArray[]{in, size2}, null);
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (size2 == null) {
            throw new NullPointerException("size is marked non-null but is null");
        }
        Preconditions.checkArgument(in.rank() == 4, "expected input message in NHWC format i.e [batchSize, height, width, channels]");
        this.addBArgument(preserveAspectRatio, antialias);
        this.addIArgument(method.methodIndex());
    }

    public ImageResize(@NonNull SameDiff sameDiff, @NonNull SDVariable in, @NonNull SDVariable size2, double bicubicCoefficient, boolean preserveAspectRatio, boolean antialias) {
        super("image_resize", sameDiff, new SDVariable[]{in, size2});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (size2 == null) {
            throw new NullPointerException("size is marked non-null but is null");
        }
        ImageResizeMethod method = ImageResizeMethod.ResizeBicubic;
        this.addBArgument(preserveAspectRatio, antialias);
        this.addIArgument(method.methodIndex());
        this.addTArgument(bicubicCoefficient);
    }

    public ImageResize(@NonNull INDArray in, @NonNull INDArray size2, double bicubicCoefficient, boolean exclude_outside, boolean preserveAspectRatio) {
        super("image_resize", new INDArray[]{in, size2}, null);
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (size2 == null) {
            throw new NullPointerException("size is marked non-null but is null");
        }
        Preconditions.checkArgument(in.rank() == 4, "expected input message in NHWC format i.e [batchSize, height, width, channels]");
        ImageResizeMethod method = ImageResizeMethod.ResizeBicubic;
        this.addBArgument(preserveAspectRatio, false, exclude_outside);
        this.addIArgument(method.methodIndex());
        this.addTArgument(bicubicCoefficient);
    }

    public ImageResize(@NonNull INDArray in, @NonNull INDArray size2, double bicubicCoefficient, CoordinateTransformationMode coorMode, boolean exclude_outside, boolean preserveAspectRatio) {
        super("image_resize", new INDArray[]{in, size2}, null);
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (size2 == null) {
            throw new NullPointerException("size is marked non-null but is null");
        }
        Preconditions.checkArgument(in.rank() == 4, "expected input message in NHWC format i.e [batchSize, height, width, channels]");
        ImageResizeMethod method = ImageResizeMethod.ResizeBicubic;
        this.addBArgument(preserveAspectRatio, false, exclude_outside);
        this.addIArgument(method.methodIndex());
        this.addIArgument(coorMode.getIndex());
        this.addTArgument(bicubicCoefficient);
    }

    public ImageResize(@NonNull INDArray in, @NonNull INDArray size2, NearestMode nearestMode, boolean preserveAspectRatio, boolean antialias) {
        super("image_resize", new INDArray[]{in, size2}, null);
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (size2 == null) {
            throw new NullPointerException("size is marked non-null but is null");
        }
        Preconditions.checkArgument(in.rank() == 4, "expected input message in NHWC format i.e [batchSize, height, width, channels]");
        ImageResizeMethod method = ImageResizeMethod.ResizeNearest;
        CoordinateTransformationMode coorMode = CoordinateTransformationMode.HALF_PIXEL_NN;
        this.addBArgument(preserveAspectRatio, antialias);
        this.addIArgument(method.methodIndex());
        this.addIArgument(coorMode.getIndex());
        this.addIArgument(nearestMode.getIndex());
    }

    public ImageResize(@NonNull INDArray in, @NonNull INDArray size2, CoordinateTransformationMode coorMode, NearestMode nearestMode, boolean preserveAspectRatio, boolean antialias) {
        super("image_resize", new INDArray[]{in, size2}, null);
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (size2 == null) {
            throw new NullPointerException("size is marked non-null but is null");
        }
        Preconditions.checkArgument(in.rank() == 4, "expected input message in NHWC format i.e [batchSize, height, width, channels]");
        ImageResizeMethod method = ImageResizeMethod.ResizeNearest;
        this.addBArgument(preserveAspectRatio, antialias);
        this.addIArgument(method.methodIndex());
        this.addIArgument(coorMode.getIndex());
        this.addIArgument(nearestMode.getIndex());
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkArgument(dataTypes != null && dataTypes.size() == 2, "Expected exactly 2 input datatypes, got %s", dataTypes);
        Preconditions.checkArgument(dataTypes.get(0).isFPType(), "Input datatype must be floating point, got %s", dataTypes);
        return Collections.singletonList(dataTypes.get(0));
    }

    public ImageResize() {
    }
}

