/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import onnx.Onnx;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.DeConv2DDerivative;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.DeConv2DConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class DeConv2D
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(DeConv2D.class);
    protected DeConv2DConfig config;

    public DeConv2D(@NonNull SameDiff sameDiff, @NonNull SDVariable input, @NonNull SDVariable weights, SDVariable bias, DeConv2DConfig config) {
        this(sameDiff, DeConv2D.wrapFilterNull(input, weights, bias), config);
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked non-null but is null");
        }
    }

    public DeConv2D(SameDiff sameDiff, SDVariable[] inputs, DeConv2DConfig config) {
        super(sameDiff, inputs);
        this.config = config;
        this.addArgs();
    }

    public DeConv2D(INDArray[] inputs, INDArray[] outputs, DeConv2DConfig config) {
        super(inputs, outputs);
        this.config = config;
        this.addArgs();
    }

    public DeConv2D(@NonNull INDArray input, @NonNull INDArray weights, INDArray bias, INDArray output, @NonNull DeConv2DConfig config) {
        this(DeConv2D.wrapFilterNull(input, weights, bias), DeConv2D.wrapOrNull(output), config);
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
    }

    public DeConv2D(INDArray layerInput, INDArray weights, INDArray bias, DeConv2DConfig config) {
        this(layerInput, weights, bias, null, config);
    }

    @Override
    public long[] iArgs() {
        if (this.iArguments.size() == 0) {
            this.addArgs();
        }
        return super.iArgs();
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        if (this.config == null && !this.iArguments.isEmpty()) {
            this.config = DeConv2DConfig.builder().kH((Long)this.iArguments.get(0)).kW((Long)this.iArguments.get(1)).sH((Long)this.iArguments.get(2)).sW((Long)this.iArguments.get(3)).pH((Long)this.iArguments.get(4)).pW((Long)this.iArguments.get(5)).dH((Long)this.iArguments.get(6)).dW((Long)this.iArguments.get(7)).isSameMode((Long)this.iArguments.get(8) == 1L).dataFormat((Long)this.iArguments.get(9) == 1L ? "NHWC" : "NCHW").build();
        }
        return this.config.toProperties();
    }

    private void addArgs() {
        this.addIArgument(this.config.getKH());
        this.addIArgument(this.config.getKW());
        this.addIArgument(this.config.getSH());
        this.addIArgument(this.config.getSW());
        this.addIArgument(this.config.getPH());
        this.addIArgument(this.config.getPW());
        this.addIArgument(this.config.getDH());
        this.addIArgument(this.config.getDW());
        this.addIArgument(ArrayUtil.fromBoolean(this.config.isSameMode()));
        this.addIArgument(this.config.getDataFormat().equalsIgnoreCase("NCHW") ? 0 : 1);
    }

    @Override
    public boolean isConfigProperties() {
        return true;
    }

    @Override
    public String configFieldName() {
        return "config";
    }

    @Override
    public Object getValue(Field property) {
        if (this.config == null) {
            this.config = DeConv2DConfig.builder().build();
        }
        return this.config.getValue(property);
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping strideMapping = PropertyMapping.builder().tfAttrName("strides").onnxAttrName("strides").build();
        PropertyMapping kernelMapping = PropertyMapping.builder().propertyNames(new String[]{"kH", "kW"}).tfInputPosition(1).onnxAttrName("kernel_shape").build();
        PropertyMapping dilationMapping = PropertyMapping.builder().onnxAttrName("dilations").propertyNames(new String[]{"dW", "dH"}).tfAttrName("rates").build();
        PropertyMapping sameMode = PropertyMapping.builder().onnxAttrName("auto_pad").propertyNames(new String[]{"isSameMode"}).tfAttrName("padding").build();
        PropertyMapping paddingWidthHeight = PropertyMapping.builder().onnxAttrName("padding").propertyNames(new String[]{"pH", "pW"}).build();
        map.put("sW", strideMapping);
        map.put("sH", strideMapping);
        map.put("kH", kernelMapping);
        map.put("kW", kernelMapping);
        map.put("dW", dilationMapping);
        map.put("dH", dilationMapping);
        map.put("isSameMode", sameMode);
        map.put("pH", paddingWidthHeight);
        map.put("pW", paddingWidthHeight);
        ret.put(this.onnxName(), map);
        ret.put(this.tensorflowName(), map);
        return ret;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        DeConv2DConfig conv2DConfig;
        AttrValue aStrides = nodeDef.getAttrOrThrow("strides");
        List<Long> tfStrides = aStrides.getList().getIList();
        long sH = 1L;
        long sW = 1L;
        long kH = 1L;
        long kW = 1L;
        AttrValue aPadding = nodeDef.getAttrOrDefault("padding", null);
        String paddingMode = aPadding.getS().toStringUtf8();
        SDVariable[] args = this.args();
        INDArray arr = this.sameDiff.getVariable(args[1].name()).getArr();
        if (arr == null) {
            arr = TFGraphMapper.getNDArrayFromTensor(nodeDef);
            SDVariable varForOp = initWith.getVariable(args[1].name());
            if (arr != null) {
                initWith.associateArrayWithVariable(arr, varForOp);
            }
        }
        String dataFormat = "nhwc";
        if (nodeDef.containsAttr("data_format")) {
            AttrValue attr = nodeDef.getAttrOrThrow("data_format");
            dataFormat = attr.getS().toStringUtf8().toLowerCase();
        }
        if (dataFormat.equalsIgnoreCase("NCHW")) {
            sH = tfStrides.get(2);
            sW = tfStrides.get(3);
            kH = arr.size(2);
            kW = arr.size(3);
        } else {
            sH = tfStrides.get(1);
            sW = tfStrides.get(2);
            kH = arr.size(0);
            kW = arr.size(1);
        }
        boolean isSameMode = paddingMode.equalsIgnoreCase("SAME");
        this.config = conv2DConfig = DeConv2DConfig.builder().kH(kH).kW(kW).sH(sW).sW(sH).isSameMode(isSameMode).dataFormat(dataFormat.equalsIgnoreCase("NHWC") ? "NHWC" : "NCHW").build();
        this.addArgs();
    }

    @Override
    public void initFromOnnx(Onnx.NodeProto node, SameDiff initWith, Map<String, Onnx.AttributeProto> attributesForNode, Onnx.GraphProto graph) {
        DeConv2DConfig conv2DConfig;
        String autoPad = !attributesForNode.containsKey("auto_pad") ? "VALID" : attributesForNode.get("auto_pad").getS().toStringUtf8();
        Onnx.AttributeProto dilations = attributesForNode.get("dilations");
        int dilationY = dilations == null ? 1 : dilations.getIntsList().get(0).intValue();
        int dilationX = dilations == null ? 1 : dilations.getIntsList().get(1).intValue();
        Onnx.AttributeProto group = attributesForNode.get("group");
        Onnx.AttributeProto kernelShape = attributesForNode.get("kernel_shape");
        int kH = kernelShape.getIntsList().get(0).intValue();
        int kW = kernelShape.getIntsList().size() < 2 ? kH : kernelShape.getIntsList().get(1).intValue();
        SDVariable vertexId = this.args()[0];
        INDArray arr = vertexId.getArr();
        arr = arr.permute(3, 2, 0, 1).dup('c');
        initWith.associateArrayWithVariable(arr, vertexId);
        String dataFormat = "nhwc";
        Onnx.AttributeProto strides = attributesForNode.get("strides");
        Long sH = strides.getIntsList().get(0);
        Long sW = strides.getIntsList().size() < 2 ? sH : strides.getIntsList().get(1);
        boolean isSameMode = autoPad.equalsIgnoreCase("SAME");
        this.config = conv2DConfig = DeConv2DConfig.builder().kH(kH).kW(kW).sH(sH.intValue()).sW(sW.intValue()).isSameMode(isSameMode).dataFormat(dataFormat.equalsIgnoreCase("nhwc") ? "NHWC" : "NCHW").build();
        this.addArgs();
        this.addOutputArgument(arr);
    }

    @Override
    public String opName() {
        return "deconv2d";
    }

    @Override
    public String onnxName() {
        return "ConvTranspose";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        ArrayList<SDVariable> ret = new ArrayList<SDVariable>();
        ArrayList<SDVariable> inputs = new ArrayList<SDVariable>();
        inputs.addAll(Arrays.asList(this.args()));
        inputs.addAll(f1);
        DeConv2DDerivative deConv2DDerivative = DeConv2DDerivative.derivativeBuilder().sameDiff(this.sameDiff).config(this.config).inputs(inputs.toArray(new SDVariable[inputs.size()])).build();
        ret.addAll(Arrays.asList(deConv2DDerivative.outputVariables()));
        return ret;
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() == n, "Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }

    public static DeConv2DBuilder sameDiffBuilder() {
        return new DeConv2DBuilder();
    }

    public DeConv2DConfig getConfig() {
        return this.config;
    }

    public DeConv2D() {
    }

    public static class DeConv2DBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputs;
        private DeConv2DConfig config;

        DeConv2DBuilder() {
        }

        public DeConv2DBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public DeConv2DBuilder inputs(SDVariable[] inputs) {
            this.inputs = inputs;
            return this;
        }

        public DeConv2DBuilder config(DeConv2DConfig config) {
            this.config = config;
            return this;
        }

        public DeConv2D build() {
            return new DeConv2D(this.sameDiff, this.inputs, this.config);
        }

        public String toString() {
            return "DeConv2D.DeConv2DBuilder(sameDiff=" + this.sameDiff + ", inputs=" + Arrays.deepToString(this.inputs) + ", config=" + this.config + ")";
        }
    }
}

