/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Im2colBp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv2DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.PaddingMode;

public class Im2col
extends DynamicCustomOp {
    protected Conv2DConfig conv2DConfig;

    public Im2col(SameDiff sameDiff, SDVariable[] inputFunctions, INDArray[] inputArrays, INDArray[] outputs, Conv2DConfig conv2DConfig) {
        super(null, inputArrays, outputs);
        if (sameDiff != null) {
            this.sameDiff = sameDiff;
        }
        this.conv2DConfig = conv2DConfig;
        this.addArgs();
    }

    public Im2col(SameDiff sd, SDVariable input, Conv2DConfig config) {
        super(null, sd, new SDVariable[]{input});
        this.conv2DConfig = config;
        this.addArgs();
    }

    public Im2col() {
    }

    public Im2col(INDArray in, Conv2DConfig conv2DConfig) {
        super("im2Col", in, null, null, null);
        this.conv2DConfig = conv2DConfig;
        this.addArgs();
    }

    protected void addArgs() {
        this.addIArgument(this.conv2DConfig.getKH());
        this.addIArgument(this.conv2DConfig.getKW());
        this.addIArgument(this.conv2DConfig.getSH());
        this.addIArgument(this.conv2DConfig.getSW());
        this.addIArgument(this.conv2DConfig.getPH());
        this.addIArgument(this.conv2DConfig.getPW());
        this.addIArgument(this.conv2DConfig.getDH());
        this.addIArgument(this.conv2DConfig.getDW());
        this.addIArgument(this.conv2DConfig.getPaddingMode().index);
    }

    @Override
    public void setPropertiesForFunction(Map<String, Object> properties) {
        if (this.conv2DConfig == null) {
            String paddingMode;
            Long kH;
            Long kW;
            Long pH;
            Long sH;
            Long dW;
            Long pW;
            Long sW;
            Conv2DConfig.Conv2DConfigBuilder builder = Conv2DConfig.builder();
            Long dH = this.getLongValueFromProperty("dH", properties);
            if (dH != null) {
                builder.dH(dH);
            }
            if ((sW = this.getLongValueFromProperty("sW", properties)) != null) {
                builder.sW(sW);
            }
            if ((pW = this.getLongValueFromProperty("pW", properties)) != null) {
                builder.pW(pW);
            }
            if ((dW = this.getLongValueFromProperty("dW", properties)) != null) {
                builder.dW(dW);
            }
            if ((sH = this.getLongValueFromProperty("sH", properties)) != null) {
                builder.sH(sH);
            }
            if ((pH = this.getLongValueFromProperty("pH", properties)) != null) {
                builder.pH(pH);
            }
            if ((kW = this.getLongValueFromProperty("kW", properties)) != null) {
                builder.kW(kW);
            }
            if ((kH = this.getLongValueFromProperty("kH", properties)) != null) {
                builder.kH(kH);
            }
            if ((paddingMode = this.getStringFromProperty("paddingMode", properties)) != null) {
                builder.paddingMode(PaddingMode.valueOf(paddingMode));
            }
            this.conv2DConfig = builder.build();
        }
    }

    @Override
    public void configureFromArguments() {
        if (this.conv2DConfig == null && this.iArguments.size() >= 10) {
            this.conv2DConfig = Conv2DConfig.builder().kH((Long)this.iArguments.get(0)).kW((Long)this.iArguments.get(1)).sH((Long)this.iArguments.get(2)).sW((Long)this.iArguments.get(3)).pH((Long)this.iArguments.get(4)).pW((Long)this.iArguments.get(5)).dH((Long)this.iArguments.get(6)).dW((Long)this.iArguments.get(7)).paddingMode(PaddingMode.fromNumber(((Long)this.iArguments.get(8)).intValue())).build();
        }
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        return this.conv2DConfig.toProperties();
    }

    @Override
    public String opName() {
        return "im2col";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        return new Im2colBp(this.sameDiff, this.arg(), grad.get(0), this.conv2DConfig).outputs();
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() == 1, "Expected 1 input data type for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }

    public static Im2colBuilder builder() {
        return new Im2colBuilder();
    }

    public static class Im2colBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputFunctions;
        private INDArray[] inputArrays;
        private INDArray[] outputs;
        private Conv2DConfig conv2DConfig;

        Im2colBuilder() {
        }

        public Im2colBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public Im2colBuilder inputFunctions(SDVariable[] inputFunctions) {
            this.inputFunctions = inputFunctions;
            return this;
        }

        public Im2colBuilder inputArrays(INDArray[] inputArrays) {
            this.inputArrays = inputArrays;
            return this;
        }

        public Im2colBuilder outputs(INDArray[] outputs) {
            this.outputs = outputs;
            return this;
        }

        public Im2colBuilder conv2DConfig(Conv2DConfig conv2DConfig) {
            this.conv2DConfig = conv2DConfig;
            return this;
        }

        public Im2col build() {
            return new Im2col(this.sameDiff, this.inputFunctions, this.inputArrays, this.outputs, this.conv2DConfig);
        }

        public String toString() {
            return "Im2col.Im2colBuilder(sameDiff=" + this.sameDiff + ", inputFunctions=" + Arrays.deepToString(this.inputFunctions) + ", inputArrays=" + Arrays.deepToString(this.inputArrays) + ", outputs=" + Arrays.deepToString(this.outputs) + ", conv2DConfig=" + this.conv2DConfig + ")";
        }
    }
}

