/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.recurrent;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.config.LSTMConfiguration;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.config.RnnDataFormat;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.weights.LSTMWeights;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class LSTMBlock
extends DynamicCustomOp {
    private LSTMConfiguration configuration;
    private LSTMWeights weights;

    public LSTMBlock() {
    }

    public LSTMBlock(@NonNull SameDiff sameDiff, SDVariable maxTSLength, SDVariable x, SDVariable cLast, SDVariable yLast, LSTMWeights weights, LSTMConfiguration configuration) {
        super(null, sameDiff, weights.argsWithInputs(x, maxTSLength, cLast, yLast));
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        this.configuration = configuration;
        this.weights = weights;
        this.addIArgument(configuration.iArgs(true));
        this.addTArgument(configuration.tArgs());
    }

    public LSTMBlock(INDArray x, INDArray cLast, INDArray yLast, INDArray maxTSLength, LSTMWeights lstmWeights, LSTMConfiguration lstmConfiguration) {
        super(null, null, lstmWeights.argsWithInputs(maxTSLength, x, cLast, yLast));
        this.configuration = lstmConfiguration;
        this.weights = lstmWeights;
        this.addIArgument(this.configuration.iArgs(true));
        this.addTArgument(this.configuration.tArgs());
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() == 9, "Expected exactly 9 inputs to LSTMBlock, got %s", inputDataTypes);
        DataType dt = inputDataTypes.get(1);
        Preconditions.checkState(dt.isFPType(), "Input type 1 must be a floating point type, got %s", (Object)dt);
        return Arrays.asList(dt, dt, dt, dt, dt, dt, dt);
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grads) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        this.configuration = LSTMConfiguration.builder().forgetBias(attributesForNode.get("forget_bias").getF()).clippingCellValue(attributesForNode.get("cell_clip").getF()).peepHole(attributesForNode.get("use_peephole").getB()).dataFormat(RnnDataFormat.TNS).build();
        this.addIArgument(this.configuration.iArgs(true));
        this.addTArgument(this.configuration.tArgs());
    }

    @Override
    public String opName() {
        return "lstmBlock";
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        if (this.configuration != null) {
            return this.configuration.toProperties(true);
        }
        return Collections.emptyMap();
    }

    @Override
    public String tensorflowName() {
        return "BlockLSTM";
    }

    public LSTMWeights getWeights() {
        return this.weights;
    }
}

