/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.reduce3;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.util.SameDiffUtils;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.reduce3.BaseReduce3Op;
import org.nd4j.linalg.factory.Nd4j;

public class JaccardDistance
extends BaseReduce3Op {
    public JaccardDistance(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int ... dimensions) {
        super(sameDiff, i_v, i_v2, dimensions);
        this.extraArgs = new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f)};
    }

    public JaccardDistance(SameDiff sameDiff, SDVariable i_v, SDVariable dimensions) {
        super(sameDiff, i_v, dimensions);
    }

    public JaccardDistance(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, SDVariable dimensions) {
        super(sameDiff, i_v, i_v2, dimensions);
    }

    public JaccardDistance() {
    }

    public JaccardDistance(INDArray x, INDArray y, int ... dimensions) {
        this(x, y, null, false, dimensions);
    }

    public JaccardDistance(INDArray x, INDArray y, boolean allDistances, int ... dimensions) {
        super(x, y, allDistances, dimensions);
    }

    public JaccardDistance(INDArray x, INDArray y, INDArray z, boolean allDistances, int ... dimensions) {
        this(x, y, z, false, allDistances, dimensions);
        this.isComplex = allDistances;
    }

    public JaccardDistance(INDArray x, INDArray y, INDArray z) {
        this(x, y, z, false, null);
    }

    public JaccardDistance(INDArray x, INDArray y, boolean allDistances) {
        this(x, y, new int[0]);
        this.isComplex = allDistances;
    }

    public JaccardDistance(INDArray x, INDArray y, INDArray z, boolean keepDims, boolean allDistances, int ... dimensions) {
        super(x, y, z, keepDims, allDistances, dimensions);
        this.extraArgs = new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f)};
    }

    public JaccardDistance(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        super(x, y, z, dimensions);
    }

    public JaccardDistance(SameDiff sameDiff, SDVariable i_v, int[] dimensions) {
        super(sameDiff, i_v, dimensions);
    }

    public JaccardDistance(SameDiff sd, SDVariable x, SDVariable y, boolean keepDims, boolean isComplex, int[] dimensions) {
        super(sd, x, y, keepDims, isComplex, dimensions);
    }

    public JaccardDistance(INDArray x, INDArray y, boolean keepDims, boolean isComplex, int[] dimensions) {
        super(x, y, null, keepDims, isComplex, dimensions);
    }

    @Override
    public Op.Type opType() {
        return Op.Type.REDUCE3;
    }

    @Override
    public Op.Type getOpType() {
        return this.opType();
    }

    @Override
    public int opNum() {
        return 6;
    }

    @Override
    public String opName() {
        return "jaccarddistance";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        SDVariable min = this.sameDiff.math.min(this.larg(), this.rarg());
        SDVariable max = this.sameDiff.math.max(this.larg(), this.rarg());
        SDVariable sumMax = max.sum(true, this.dimensions);
        SDVariable sumMin = min.sum(true, this.dimensions);
        DataType d = this.arg().dataType();
        SDVariable xIsMin = this.sameDiff.eq(min, this.larg()).castTo(d);
        SDVariable xIsMax = this.sameDiff.eq(max, this.larg()).castTo(d);
        SDVariable yIsMin = this.sameDiff.eq(min, this.rarg()).castTo(d);
        SDVariable yIsMax = this.sameDiff.eq(max, this.rarg()).castTo(d);
        SDVariable sqSumMax = this.sameDiff.math.square(sumMax);
        SDVariable dldx = xIsMax.mul(sumMin).sub(xIsMin.mul(sumMax)).div(sqSumMax);
        SDVariable dldy = yIsMax.mul(sumMin).sub(yIsMin.mul(sumMax)).div(sqSumMax);
        SDVariable bcGradOut = this.keepDims || this.dimensions == null || this.dimensions.length == 0 || this.dimensions.length == 1 && this.dimensions[0] == Integer.MAX_VALUE ? f1.get(0) : SameDiffUtils.reductionBroadcastableWithOrigShape(this.arg(), this.sameDiff.constant(Nd4j.createFromArray(this.dimensions)), f1.get(0));
        return Arrays.asList(dldx.mul(bcGradOut), dldy.mul(bcGradOut));
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public DataType resultType() {
        return Nd4j.defaultFloatingPointType();
    }
}

