/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.scatter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class ScatterMul
extends DynamicCustomOp {
    public ScatterMul(SameDiff sameDiff, SDVariable ref, SDVariable indices, SDVariable updates) {
        super(null, sameDiff, new SDVariable[]{ref, indices, updates}, false);
    }

    public ScatterMul() {
    }

    public ScatterMul(@NonNull INDArray ref, @NonNull INDArray indices, @NonNull INDArray update) {
        super(new INDArray[]{ref, indices, update}, null);
        if (ref == null) {
            throw new NullPointerException("ref is marked non-null but is null");
        }
        if (indices == null) {
            throw new NullPointerException("indices is marked non-null but is null");
        }
        if (update == null) {
            throw new NullPointerException("update is marked non-null but is null");
        }
    }

    @Override
    public String opName() {
        return "scatter_mul";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        return "ScatterMul";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
        if (nodeDef.containsAttr("use_locking")) {
            if (nodeDef.getAttrOrThrow("use_locking").getB()) {
                this.bArguments.add(true);
            } else {
                this.bArguments.add(false);
            }
        } else {
            this.bArguments.add(false);
        }
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> gradOut) {
        SDVariable ref = this.arg(0);
        SDVariable indices = this.arg(1);
        SDVariable updates = this.arg(2);
        ArrayList<SDVariable> ret = new ArrayList<SDVariable>(3);
        SDVariable gradRef = this.sameDiff.scatterMul(gradOut.get(0), indices, updates);
        ret.add(gradRef);
        ret.add(this.sameDiff.zerosLike(this.arg(1)));
        SDVariable gatherOutGrad = this.sameDiff.gather(gradOut.get(0), indices, 0);
        SDVariable gatherRef = this.sameDiff.gather(ref, indices, 0);
        SDVariable updateGrad = gatherOutGrad.mul(gatherRef);
        ret.add(updateGrad);
        return ret;
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() == 3, "Expected exactly 3 input datatypes for %s, got %s", this.getClass(), inputDataTypes);
        Preconditions.checkState(inputDataTypes.get(0) == inputDataTypes.get(2), "Reference (input 0) and updates (input 2) must have exactly same data types, got %s and %s", (Object)inputDataTypes.get(0), (Object)inputDataTypes.get(2));
        return Collections.singletonList(inputDataTypes.get(0));
    }
}

