/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class BinCount
extends DynamicCustomOp {
    private Integer minLength;
    private Integer maxLength;
    private DataType outputType;

    public BinCount() {
    }

    public BinCount(SameDiff sd, SDVariable in, SDVariable weights, Integer minLength, Integer maxLength, DataType outputType) {
        SDVariable[] sDVariableArray;
        if (weights == null) {
            SDVariable[] sDVariableArray2 = new SDVariable[1];
            sDVariableArray = sDVariableArray2;
            sDVariableArray2[0] = in;
        } else {
            SDVariable[] sDVariableArray3 = new SDVariable[2];
            sDVariableArray3[0] = in;
            sDVariableArray = sDVariableArray3;
            sDVariableArray3[1] = weights;
        }
        super(sd, sDVariableArray, false);
        Preconditions.checkState(minLength == null != (maxLength == null), "Cannot have only one of minLength and maxLengthnon-null: both must be simultaneously null or non-null. minLength=%s, maxLength=%s", (Object)minLength, (Object)maxLength);
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.outputType = outputType;
        this.addArgs();
    }

    private void addArgs() {
        if (this.minLength != null) {
            this.addIArgument(this.minLength);
        }
        if (this.maxLength != null) {
            this.addIArgument(this.maxLength);
        }
    }

    @Override
    public String opName() {
        return "bincount";
    }

    @Override
    public String tensorflowName() {
        return "Bincount";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        if (attributesForNode.containsKey("T")) {
            this.outputType = TFGraphMapper.convertType(attributesForNode.get("T").getType());
        }
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputTypes) {
        Preconditions.checkState(inputTypes != null && inputTypes.size() >= 1 && inputTypes.size() <= 4, "Expected 1 to 4 input types, got %s for op %s", inputTypes, this.getClass());
        if (inputTypes.size() >= 2) {
            return Collections.singletonList(inputTypes.get(1));
        }
        Preconditions.checkNotNull((Object)this.outputType, "No output type available - output type must be set unless weights input is available");
        return Collections.singletonList(this.outputType);
    }
}

