/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.comparison;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformSameOp;
import org.nd4j.linalg.indexing.conditions.Condition;
import org.nd4j.linalg.indexing.conditions.Conditions;

public class CompareAndReplace
extends BaseTransformSameOp {
    private Condition condition;
    private double compare;
    private double set;
    private double eps;
    private Conditions.ConditionMode mode;

    public CompareAndReplace(SameDiff sameDiff, SDVariable to, SDVariable from, Condition condition) {
        super(sameDiff, to, from, false);
        this.condition = condition;
        this.compare = condition.getValue();
        this.set = 0.0;
        this.mode = condition.conditionType();
        this.eps = condition.epsThreshold();
        this.extraArgs = new Object[]{this.compare, this.set, this.eps, (double)this.mode.index};
    }

    public CompareAndReplace() {
    }

    public CompareAndReplace(INDArray x, INDArray y, Condition condition) {
        this(x, y, null, condition);
    }

    public CompareAndReplace(INDArray x, INDArray y, INDArray z, Condition condition) {
        super(x, y, z);
        this.compare = condition.getValue();
        this.set = 0.0;
        this.mode = condition.conditionType();
        this.eps = condition.epsThreshold();
        this.extraArgs = new Object[]{this.compare, this.set, this.eps, (double)this.mode.index};
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("compare", this.compare);
        ret.put("set", this.set);
        ret.put("eps", this.eps);
        ret.put("mode", (Object)this.mode);
        return ret;
    }

    @Override
    public void setPropertiesForFunction(Map<String, Object> properties) {
        if (properties.containsKey("mode")) {
            Object mode;
            if (properties.get("mode") instanceof Integer) {
                mode = (Integer)properties.get("mode");
                this.mode = Conditions.ConditionMode.fromNumber((Integer)mode);
                if (!properties.containsKey("compare")) {
                    this.condition = Conditions.fromInt((Integer)mode);
                }
            } else if (properties.get("mode") instanceof Conditions.ConditionMode) {
                mode = (Conditions.ConditionMode)((Object)properties.get("mode"));
                this.mode = mode;
                if (!properties.containsKey("compare")) {
                    this.condition = Conditions.fromInt(((Conditions.ConditionMode)((Object)mode)).index);
                }
            }
        }
        if (properties.containsKey("compare")) {
            Double compare = (Double)properties.get("compare");
            this.compare = compare;
            if (properties.containsKey("mode")) {
                this.condition = Conditions.fromInt(this.mode.index, compare);
            }
        }
        if (properties.containsKey("set")) {
            Double set = (Double)properties.get("set");
            this.set = set;
        }
        if (properties.containsKey("eps")) {
            Double eps = (Double)properties.get("eps");
            this.eps = eps;
        }
    }

    @Override
    public int opNum() {
        return 13;
    }

    @Override
    public String opName() {
        return "car";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        SDVariable maskMatched = this.sameDiff.matchCondition(this.arg(0), this.condition).castTo(this.arg().dataType());
        SDVariable maskNotMatched = maskMatched.rsub(1.0);
        return Arrays.asList(grad.get(0).mul(maskNotMatched), grad.get(0).mul(maskMatched));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState(dataTypes != null && dataTypes.size() == 2, "Expected exactly 2 input datatypes for %s, got input %s", this.getClass(), dataTypes);
        Preconditions.checkState(dataTypes.get(0) == dataTypes.get(1), "Input data types must be the same: got %s", dataTypes);
        return Collections.singletonList(dataTypes.get(0));
    }
}

