/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class DotProductAttentionBp
extends DynamicCustomOp {
    private boolean scaled;

    public DotProductAttentionBp(SameDiff sameDiff, SDVariable queries, SDVariable keys, SDVariable values, SDVariable eps, SDVariable mask, boolean scaled) {
        SDVariable[] sDVariableArray;
        if (mask == null) {
            SDVariable[] sDVariableArray2 = new SDVariable[4];
            sDVariableArray2[0] = queries;
            sDVariableArray2[1] = keys;
            sDVariableArray2[2] = values;
            sDVariableArray = sDVariableArray2;
            sDVariableArray2[3] = eps;
        } else {
            SDVariable[] sDVariableArray3 = new SDVariable[5];
            sDVariableArray3[0] = queries;
            sDVariableArray3[1] = keys;
            sDVariableArray3[2] = values;
            sDVariableArray3[3] = eps;
            sDVariableArray = sDVariableArray3;
            sDVariableArray3[4] = mask;
        }
        super(null, sameDiff, sDVariableArray, false);
        this.scaled = scaled;
        this.addIArgument(scaled ? 1 : 0);
    }

    @Override
    public String opName() {
        return "dot_product_attention_bp";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        throw new UnsupportedOperationException("Differentiation of " + this.getClass().getName() + " not supported");
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState(dataTypes != null && (dataTypes.size() == 4 || dataTypes.size() == 5), "Expected 4 or 5 input datatypes, got %s", dataTypes);
        DataType first = dataTypes.get(0);
        for (int i = 0; i < dataTypes.size(); ++i) {
            Preconditions.checkState(dataTypes.get(i).isFPType(), "Input %s datatype must be a floating point type, got datypes %s", dataTypes);
            if (i <= 0) continue;
            Preconditions.checkState(first == dataTypes.get(i), "All datatypes must be same type, got input datatypes %s", dataTypes);
        }
        return Arrays.asList(first, first, first);
    }

    public DotProductAttentionBp() {
    }
}

