/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.factory.Nd4j;

public class SpaceToBatch
extends DynamicCustomOp {
    protected int[] blocks;
    protected int[][] padding;

    public SpaceToBatch() {
    }

    public SpaceToBatch(SameDiff sameDiff, SDVariable x, int[] blocks, int[] paddingTop, int ... paddingBottom) {
        this(sameDiff, new SDVariable[]{x}, blocks, new int[][]{paddingBottom, paddingBottom}, false);
    }

    public SpaceToBatch(SameDiff sameDiff, SDVariable[] args, int[] blocks, int[][] padding, boolean inPlace) {
        super(null, sameDiff, new SDVariable[]{args[0], sameDiff.constant(Nd4j.createFromArray(padding))}, inPlace);
        this.blocks = blocks;
        this.padding = padding;
        this.addIArgument(blocks[0]);
    }

    public SpaceToBatch(INDArray x, int[] blocks, int[] paddingTop, int ... paddingBottom) {
        this.addInputArgument(x);
        this.blocks = blocks;
        this.padding = this.padding;
        this.addIArgument(blocks[0]);
    }

    @Override
    public String opName() {
        return "space_to_batch";
    }

    @Override
    public String onnxName() {
        return "space_to_batch";
    }

    @Override
    public String tensorflowName() {
        return "SpaceToBatch";
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (this.blocks != null) {
            ret.put("blocks", this.blocks);
        }
        if (this.padding != null) {
            ret.put("padding", this.padding);
        }
        return ret;
    }

    @Override
    public void configureFromArguments() {
        super.configureFromArguments();
    }

    @Override
    public void setPropertiesForFunction(Map<String, Object> properties) {
        if (properties.containsKey("padding")) {
            int[][] padding = (int[][])properties.get("padding");
            this.padding = padding;
        }
        if (properties.containsKey("blocks")) {
            int[] blocks = (int[])properties.get("blocks");
            this.blocks = blocks;
        }
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        SDVariable gradient = this.sameDiff.setupFunction(i_v.get(0));
        return Arrays.asList(this.sameDiff.cnn().batchToSpace(gradient, this.blocks, this.padding[0], this.padding[1]));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        return Collections.singletonList(dataTypes.get(0));
    }
}

