/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.impl;

import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.api.ops.random.BaseRandomOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;

public class Choice
extends BaseRandomOp {
    public Choice() {
    }

    public Choice(@NonNull INDArray source, @NonNull INDArray probabilities, @NonNull INDArray z) {
        super(source, probabilities, z);
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (probabilities == null) {
            throw new NullPointerException("probabilities is marked non-null but is null");
        }
        if (z == null) {
            throw new NullPointerException("z is marked non-null but is null");
        }
        Preconditions.checkArgument(source.dataType() == probabilities.dataType() && z.dataType() == source.dataType(), "Data types of all arguments should match");
        Preconditions.checkState(source.length() == probabilities.length(), "From & probabilities length mismatch: %s vs. %s", source.length(), probabilities.length());
        if (probabilities.elementWiseStride() < 1 || source.elementWiseStride() < 1) {
            throw new IllegalStateException("Source and probabilities should have element-wise stride >= 1");
        }
        this.extraArgs = new Object[]{0.0};
    }

    @Override
    public int opNum() {
        return 5;
    }

    @Override
    public String opName() {
        return "choice";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape(OpContext oc) {
        return this.calculateOutputShape();
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        LongShapeDescriptor longShapeDescriptor = LongShapeDescriptor.fromShape(this.shape, this.dataType);
        return Arrays.asList(longShapeDescriptor);
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        throw new UnsupportedOperationException("Choice does not have a derivative");
    }
}

