/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cache;

import java.util.Arrays;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TadDescriptor {
    private static final Logger log = LoggerFactory.getLogger(TadDescriptor.class);
    private int dimensionLength;
    private int[] dimension;
    private long[] shape;

    public TadDescriptor(INDArray array, int[] dimension) {
        this.dimensionLength = dimension == null ? 0 : dimension.length;
        this.dimension = dimension;
        this.shape = TadDescriptor.dataBufferToArray(array.shapeInfoDataBuffer());
    }

    public static long[] dataBufferToArray(DataBuffer buffer) {
        int rank2 = buffer.getInt(0L);
        long[] ret = new long[Shape.shapeInfoLength(rank2)];
        ret[0] = rank2;
        for (int e = 1; e < Shape.shapeInfoLength(rank2); ++e) {
            ret[e] = buffer.getInt(e);
        }
        return ret;
    }

    public int getDimensionLength() {
        return this.dimensionLength;
    }

    public int[] getDimension() {
        return this.dimension;
    }

    public long[] getShape() {
        return this.shape;
    }

    public void setDimensionLength(int dimensionLength) {
        this.dimensionLength = dimensionLength;
    }

    public void setDimension(int[] dimension) {
        this.dimension = dimension;
    }

    public void setShape(long[] shape) {
        this.shape = shape;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TadDescriptor)) {
            return false;
        }
        TadDescriptor other = (TadDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDimensionLength() != other.getDimensionLength()) {
            return false;
        }
        if (!Arrays.equals(this.getDimension(), other.getDimension())) {
            return false;
        }
        return Arrays.equals(this.getShape(), other.getShape());
    }

    protected boolean canEqual(Object other) {
        return other instanceof TadDescriptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDimensionLength();
        result = result * 59 + Arrays.hashCode(this.getDimension());
        result = result * 59 + Arrays.hashCode(this.getShape());
        return result;
    }

    public String toString() {
        return "TadDescriptor(dimensionLength=" + this.getDimensionLength() + ", dimension=" + Arrays.toString(this.getDimension()) + ", shape=" + Arrays.toString(this.getShape()) + ")";
    }
}

