/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.checkutil;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;
import org.nd4j.common.primitives.Pair;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class NDArrayCreationUtil {
    private NDArrayCreationUtil() {
    }

    public static List<Pair<INDArray, String>> getAllTestMatricesWithShape(char ordering, int rows, int cols, int seed, DataType dataType) {
        ArrayList<Pair<INDArray, String>> all = new ArrayList<Pair<INDArray, String>>();
        Nd4j.getRandom().setSeed(seed);
        all.add(new Pair<INDArray, String>(Nd4j.linspace(1L, (long)(rows * cols), (long)(rows * cols), dataType).reshape(ordering, rows, cols), "Nd4j..linspace(1,rows * cols,rows * cols).reshape(rows,cols)"));
        all.add(NDArrayCreationUtil.getTransposedMatrixWithShape(ordering, rows, cols, seed, dataType));
        all.addAll(NDArrayCreationUtil.getSubMatricesWithShape(ordering, rows, cols, seed, dataType));
        all.addAll(NDArrayCreationUtil.getTensorAlongDimensionMatricesWithShape(ordering, rows, cols, seed, dataType));
        all.add(NDArrayCreationUtil.getPermutedWithShape(ordering, rows, cols, seed, dataType));
        all.add(NDArrayCreationUtil.getReshapedWithShape(ordering, rows, cols, seed, dataType));
        return all;
    }

    public static List<Pair<INDArray, String>> getAllTestMatricesWithShape(long rows, long cols, long seed, DataType dataType) {
        ArrayList<Pair<INDArray, String>> all = new ArrayList<Pair<INDArray, String>>();
        Nd4j.getRandom().setSeed(seed);
        all.add(new Pair<INDArray, String>(Nd4j.linspace(1L, rows * cols, rows * cols, dataType).reshape(rows, cols), "Nd4j..linspace(1,rows * cols,rows * cols).reshape(rows,cols)"));
        all.add(NDArrayCreationUtil.getTransposedMatrixWithShape(rows, cols, seed, dataType));
        all.addAll(NDArrayCreationUtil.getSubMatricesWithShape(rows, cols, seed, dataType));
        all.addAll(NDArrayCreationUtil.getTensorAlongDimensionMatricesWithShape(rows, cols, seed, dataType));
        all.add(NDArrayCreationUtil.getPermutedWithShape(rows, cols, seed, dataType));
        all.add(NDArrayCreationUtil.getReshapedWithShape(rows, cols, seed, dataType));
        return all;
    }

    public static List<Pair<INDArray, String>> getTestMatricesWithVaryingShapes(int rank2, char order2, DataType dataType) {
        ArrayList<Pair<INDArray, String>> all = new ArrayList<Pair<INDArray, String>>();
        if (rank2 == 0) {
            all.add(new Pair<INDArray, String>(Nd4j.scalar(dataType, Nd4j.rand(dataType, 1, 1).getDouble(0L)), "{}"));
            return all;
        }
        int maxCount = (int)Math.pow(2.0, rank2);
        int[] defaultOnes = new int[rank2];
        Arrays.fill(defaultOnes, 1);
        for (int i = 0; i < maxCount; ++i) {
            int[] iShape = ArrayUtils.clone((int[])defaultOnes);
            int b = 0;
            for (int num = i; num > 0; num /= 2) {
                iShape[b] = num % 2 + 1;
                ++b;
            }
            all.add(new Pair<INDArray, String>(Nd4j.rand(dataType, order2, iShape), ArrayUtils.toString((Object)iShape)));
        }
        int[] aRandomShape = new int[rank2];
        Random ran = new Random();
        for (int i = 0; i < rank2; ++i) {
            aRandomShape[i] = 2 + ran.nextInt(6);
        }
        all.add(new Pair<INDArray, String>(Nd4j.rand(dataType, order2, aRandomShape), ArrayUtils.toString((Object)aRandomShape)));
        return all;
    }

    public static Pair<INDArray, String> getTransposedMatrixWithShape(char ordering, int rows, int cols, int seed, DataType dataType) {
        Nd4j.getRandom().setSeed(seed);
        INDArray out = Nd4j.linspace(1L, (long)(rows * cols), (long)(rows * cols), dataType).reshape(ordering, cols, rows);
        return new Pair<INDArray, String>(out.transpose(), "getTransposedMatrixWithShape(" + rows + "," + cols + "," + seed + ")");
    }

    public static Pair<INDArray, String> getTransposedMatrixWithShape(long rows, long cols, long seed, DataType dataType) {
        Nd4j.getRandom().setSeed(seed);
        INDArray out = Nd4j.linspace(1L, rows * cols, rows * cols, dataType).reshape(cols, rows);
        return new Pair<INDArray, String>(out.transpose(), "getTransposedMatrixWithShape(" + rows + "," + cols + "," + seed + ")");
    }

    public static List<Pair<INDArray, String>> getSubMatricesWithShape(long rows, long cols, long seed, DataType dataType) {
        return NDArrayCreationUtil.getSubMatricesWithShape(Nd4j.order().charValue(), rows, cols, seed, dataType);
    }

    public static List<Pair<INDArray, String>> getSubMatricesWithShape(char ordering, long rows, long cols, long seed, DataType dataType) {
        Nd4j.getRandom().setSeed(seed);
        long[] shape = new long[]{2L * rows + 4L, 2L * cols + 4L};
        int len = ArrayUtil.prod(shape);
        INDArray orig = Nd4j.linspace(1L, (long)len, (long)len, dataType).reshape(ordering, shape);
        INDArray first = orig.get(NDArrayIndex.interval(0L, rows), NDArrayIndex.interval(0L, cols));
        Nd4j.getRandom().setSeed(seed);
        orig = Nd4j.linspace(1L, (long)len, (long)len, dataType).reshape(shape);
        INDArray second = orig.get(NDArrayIndex.interval(3L, rows + 3L), NDArrayIndex.interval(3L, cols + 3L));
        Nd4j.getRandom().setSeed(seed);
        orig = Nd4j.linspace(1L, (long)len, (long)len, dataType).reshape(ordering, shape);
        INDArray third = orig.get(NDArrayIndex.interval(rows, 2L * rows), NDArrayIndex.interval(cols, 2L * cols));
        String baseMsg = "getSubMatricesWithShape(" + rows + "," + cols + "," + seed + ")";
        ArrayList<Pair<INDArray, String>> list = new ArrayList<Pair<INDArray, String>>(3);
        list.add(new Pair<INDArray, String>(first, baseMsg + ".get(0)"));
        list.add(new Pair<INDArray, String>(second, baseMsg + ".get(1)"));
        list.add(new Pair<INDArray, String>(third, baseMsg + ".get(2)"));
        return list;
    }

    public static List<Pair<INDArray, String>> getTensorAlongDimensionMatricesWithShape(char ordering, long rows, long cols, long seed, DataType dataType) {
        Nd4j.getRandom().setSeed(seed);
        INDArray[] out = new INDArray[12];
        INDArray temp01 = Nd4j.linspace(1L, cols * rows * 4L, cols * rows * 4L, dataType).reshape(cols, rows, 4L);
        out[0] = temp01.tensorAlongDimension(0L, 0, 1).reshape(rows, cols);
        long[] temp01Shape = new long[]{cols, rows, 4L};
        int len = ArrayUtil.prod(temp01Shape);
        temp01 = Nd4j.linspace(1L, (long)len, (long)len, dataType).reshape(temp01Shape);
        out[1] = temp01.tensorAlongDimension(2L, 0, 1).reshape(rows, cols);
        Nd4j.getRandom().setSeed(seed);
        INDArray temp02 = Nd4j.linspace(1L, (long)len, (long)len, dataType).reshape(cols, 4L, rows);
        out[2] = temp02.tensorAlongDimension(0L, 0, 2).reshape(rows, cols);
        temp02 = Nd4j.linspace(1L, (long)len, (long)len, dataType).reshape(cols, 4L, rows);
        out[3] = temp02.tensorAlongDimension(2L, 0, 2).reshape(rows, cols);
        INDArray temp10 = Nd4j.linspace(1L, (long)len, (long)len, dataType).reshape(rows, cols, 4L);
        out[4] = temp10.tensorAlongDimension(0L, 1, 0).reshape(rows, cols);
        temp10 = Nd4j.linspace(1L, (long)len, (long)len, dataType).reshape(rows, cols, 4L);
        out[5] = temp10.tensorAlongDimension(2L, 1, 0).reshape(rows, cols);
        INDArray temp12 = Nd4j.linspace(1L, (long)len, (long)len, dataType).reshape(4L, cols, rows);
        out[6] = temp12.tensorAlongDimension(0L, 1, 2).reshape(rows, cols);
        temp12 = Nd4j.linspace(1L, (long)len, (long)len, dataType).reshape(4L, cols, rows);
        out[7] = temp12.tensorAlongDimension(2L, 1, 2).reshape(rows, cols);
        INDArray temp20 = Nd4j.linspace(1L, (long)len, (long)len, dataType).reshape(rows, 4L, cols);
        out[8] = temp20.tensorAlongDimension(0L, 2, 0).reshape(rows, cols);
        temp20 = Nd4j.linspace(1L, (long)len, (long)len, dataType).reshape(rows, 4L, cols);
        out[9] = temp20.tensorAlongDimension(2L, 2, 0).reshape(rows, cols);
        INDArray temp21 = Nd4j.linspace(1L, (long)len, (long)len, dataType).reshape(4L, rows, cols);
        out[10] = temp21.tensorAlongDimension(0L, 2, 1).reshape(rows, cols);
        temp21 = Nd4j.linspace(1L, (long)len, (long)len, dataType).reshape(4L, rows, cols);
        out[11] = temp21.tensorAlongDimension(2L, 2, 1).reshape(rows, cols);
        String baseMsg = "getTensorAlongDimensionMatricesWithShape(" + rows + "," + cols + "," + seed + ")";
        ArrayList<Pair<INDArray, String>> list = new ArrayList<Pair<INDArray, String>>(12);
        for (int i = 0; i < out.length; ++i) {
            list.add(new Pair<INDArray, String>(out[i], baseMsg + ".get(" + i + ")"));
        }
        return list;
    }

    public static List<Pair<INDArray, String>> getTensorAlongDimensionMatricesWithShape(long rows, long cols, long seed, DataType dataType) {
        return NDArrayCreationUtil.getTensorAlongDimensionMatricesWithShape(Nd4j.order().charValue(), rows, cols, seed, dataType);
    }

    public static Pair<INDArray, String> getPermutedWithShape(char ordering, long rows, long cols, long seed, DataType dataType) {
        Nd4j.getRandom().setSeed(seed);
        long len = rows * cols;
        INDArray arr = Nd4j.linspace(1L, len, len, dataType).reshape(cols, rows);
        return new Pair<INDArray, String>(arr.permute(1, 0), "getPermutedWithShape(" + rows + "," + cols + "," + seed + ")");
    }

    public static Pair<INDArray, String> getPermutedWithShape(long rows, long cols, long seed, DataType dataType) {
        return NDArrayCreationUtil.getPermutedWithShape(Nd4j.order().charValue(), rows, cols, seed, dataType);
    }

    public static Pair<INDArray, String> getReshapedWithShape(char ordering, long rows, long cols, long seed, DataType dataType) {
        Nd4j.getRandom().setSeed(seed);
        long[] origShape = new long[3];
        if (rows % 2L == 0L) {
            origShape[0] = rows / 2L;
            origShape[1] = cols;
            origShape[2] = 2L;
        } else if (cols % 2L == 0L) {
            origShape[0] = rows;
            origShape[1] = cols / 2L;
            origShape[2] = 2L;
        } else {
            origShape[0] = 1L;
            origShape[1] = rows;
            origShape[2] = cols;
        }
        int len = ArrayUtil.prod(origShape);
        INDArray orig = Nd4j.linspace(1L, (long)len, (long)len, dataType).reshape(ordering, origShape);
        return new Pair<INDArray, String>(orig.reshape(ordering, rows, cols), "getReshapedWithShape(" + rows + "," + cols + "," + seed + ")");
    }

    public static Pair<INDArray, String> getReshapedWithShape(long rows, long cols, long seed, DataType dataType) {
        return NDArrayCreationUtil.getReshapedWithShape(Nd4j.order().charValue(), rows, cols, seed, dataType);
    }

    public static List<Pair<INDArray, String>> getAll3dTestArraysWithShape(int seed, int[] shape, DataType dataType) {
        return NDArrayCreationUtil.getAll3dTestArraysWithShape((long)seed, ArrayUtil.toLongArray(shape), dataType);
    }

    public static List<Pair<INDArray, String>> getAll3dTestArraysWithShape(long seed, long[] shape, DataType dataType) {
        if (shape.length != 3) {
            throw new IllegalArgumentException("Shape is not length 3");
        }
        ArrayList<Pair<INDArray, String>> list = new ArrayList<Pair<INDArray, String>>();
        String baseMsg = "getAll3dTestArraysWithShape(" + seed + "," + Arrays.toString(shape) + ").get(";
        long len = ArrayUtil.prodLong(shape);
        Nd4j.getRandom().setSeed(seed);
        INDArray stdC = Nd4j.linspace(1L, len, len, dataType).reshape('c', shape);
        INDArray stdF = Nd4j.linspace(1L, len, len, dataType).reshape('f', shape);
        list.add(new Pair<INDArray, String>(stdC, baseMsg + "0)/Nd4j.linspace(1,len,len)(" + Arrays.toString(shape) + ",'c')"));
        list.add(new Pair<INDArray, String>(stdF, baseMsg + "1)/Nd4j.linspace(1,len,len(" + Arrays.toString(shape) + ",'f')"));
        list.addAll(NDArrayCreationUtil.get3dSubArraysWithShape(seed, shape, dataType));
        list.addAll(NDArrayCreationUtil.get3dTensorAlongDimensionWithShape(seed, shape, dataType));
        list.addAll(NDArrayCreationUtil.get3dPermutedWithShape(seed, shape, dataType));
        list.addAll(NDArrayCreationUtil.get3dReshapedWithShape(seed, shape, dataType));
        return list;
    }

    public static List<Pair<INDArray, String>> get3dSubArraysWithShape(int seed, int[] shape, DataType dataType) {
        return NDArrayCreationUtil.get3dSubArraysWithShape((long)seed, ArrayUtil.toLongArray(shape), dataType);
    }

    public static List<Pair<INDArray, String>> get3dSubArraysWithShape(long seed, long[] shape, DataType dataType) {
        ArrayList<Pair<INDArray, String>> list = new ArrayList<Pair<INDArray, String>>();
        String baseMsg = "get3dSubArraysWithShape(" + seed + "," + Arrays.toString(shape) + ")";
        Nd4j.getRandom().setSeed(seed);
        long[] newShape1 = Arrays.copyOf(shape, shape.length);
        newShape1[0] = newShape1[0] + 5L;
        int len = ArrayUtil.prod(newShape1);
        INDArray temp1 = Nd4j.linspace(1L, (long)len, (long)len, dataType).reshape(newShape1);
        INDArray subset1 = temp1.get(NDArrayIndex.interval(2L, shape[0] + 2L), NDArrayIndex.all(), NDArrayIndex.all());
        list.add(new Pair<INDArray, String>(subset1, baseMsg + ".get(0)"));
        long[] newShape2 = Arrays.copyOf(shape, shape.length);
        newShape2[1] = newShape2[1] + 5L;
        int len2 = ArrayUtil.prod(newShape2);
        INDArray temp2 = Nd4j.linspace(1L, (long)len2, (long)len2, dataType).reshape(newShape2);
        INDArray subset2 = temp2.get(NDArrayIndex.all(), NDArrayIndex.interval(3L, shape[1] + 3L), NDArrayIndex.all());
        list.add(new Pair<INDArray, String>(subset2, baseMsg + ".get(1)"));
        long[] newShape3 = Arrays.copyOf(shape, shape.length);
        newShape3[2] = newShape3[2] + 5L;
        int len3 = ArrayUtil.prod(newShape3);
        INDArray temp3 = Nd4j.linspace(1L, (long)len3, (long)len3, dataType).reshape(newShape3);
        INDArray subset3 = temp3.get(NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval(4L, shape[2] + 4L));
        list.add(new Pair<INDArray, String>(subset3, baseMsg + ".get(2)"));
        long[] newShape4 = Arrays.copyOf(shape, shape.length);
        newShape4[0] = newShape4[0] + 5L;
        newShape4[1] = newShape4[1] + 5L;
        newShape4[2] = newShape4[2] + 5L;
        int len4 = ArrayUtil.prod(newShape4);
        INDArray temp4 = Nd4j.linspace(1L, (long)len4, (long)len4, dataType).reshape(newShape4);
        INDArray subset4 = temp4.get(NDArrayIndex.interval(4L, shape[0] + 4L), NDArrayIndex.interval(3L, shape[1] + 3L), NDArrayIndex.interval(2L, shape[2] + 2L));
        list.add(new Pair<INDArray, String>(subset4, baseMsg + ".get(3)"));
        return list;
    }

    public static List<Pair<INDArray, String>> get3dTensorAlongDimensionWithShape(int seed, int[] shape, DataType dataType) {
        return NDArrayCreationUtil.get3dTensorAlongDimensionWithShape((long)seed, ArrayUtil.toLongArray(shape), dataType);
    }

    public static List<Pair<INDArray, String>> get3dTensorAlongDimensionWithShape(long seed, long[] shape, DataType dataType) {
        ArrayList<Pair<INDArray, String>> list = new ArrayList<Pair<INDArray, String>>();
        String baseMsg = "get3dTensorAlongDimensionWithShape(" + seed + "," + Arrays.toString(shape) + ")";
        Nd4j.getRandom().setSeed(seed);
        long[] shape4d1 = new long[]{shape[0], shape[1], shape[2], 3L};
        int lenshape4d1 = ArrayUtil.prod(shape4d1);
        INDArray orig1a = Nd4j.linspace(1L, (long)lenshape4d1, (long)lenshape4d1, dataType).reshape(shape4d1);
        INDArray tad1a = orig1a.tensorAlongDimension(0L, 0, 1, 2);
        INDArray orig1b = Nd4j.linspace(1L, (long)lenshape4d1, (long)lenshape4d1, dataType).reshape(shape4d1);
        INDArray tad1b = orig1b.tensorAlongDimension(1L, 0, 1, 2);
        list.add(new Pair<INDArray, String>(tad1a, baseMsg + ".get(0)"));
        list.add(new Pair<INDArray, String>(tad1b, baseMsg + ".get(1)"));
        long[] shape4d2 = new long[]{3L, shape[0], shape[1], shape[2]};
        int lenshape4d2 = ArrayUtil.prod(shape4d2);
        INDArray orig2 = Nd4j.linspace(1L, (long)lenshape4d2, (long)lenshape4d2, dataType).reshape(shape4d2);
        INDArray tad2 = orig2.tensorAlongDimension(1L, 1, 2, 3);
        list.add(new Pair<INDArray, String>(tad2, baseMsg + ".get(2)"));
        long[] shape4d3 = new long[]{shape[0], shape[1], 3L, shape[2]};
        int lenshape4d3 = ArrayUtil.prod(shape4d3);
        INDArray orig3 = Nd4j.linspace(1L, (long)lenshape4d3, (long)lenshape4d3, dataType).reshape(shape4d3);
        INDArray tad3 = orig3.tensorAlongDimension(1L, 1, 3, 0);
        list.add(new Pair<INDArray, String>(tad3, baseMsg + ".get(3)"));
        long[] shape4d4 = new long[]{shape[0], 3L, shape[1], shape[2]};
        int lenshape4d4 = ArrayUtil.prod(shape4d4);
        INDArray orig4 = Nd4j.linspace(1L, (long)lenshape4d4, (long)lenshape4d4, dataType).reshape(shape4d4);
        INDArray tad4 = orig4.tensorAlongDimension(1L, 2, 0, 3);
        list.add(new Pair<INDArray, String>(tad4, baseMsg + ".get(4)"));
        return list;
    }

    public static List<Pair<INDArray, String>> get3dPermutedWithShape(int seed, int[] shape, DataType dataType) {
        return NDArrayCreationUtil.get3dPermutedWithShape((long)seed, ArrayUtil.toLongArray(shape), dataType);
    }

    public static List<Pair<INDArray, String>> get3dPermutedWithShape(long seed, long[] shape, DataType dataType) {
        Nd4j.getRandom().setSeed(seed);
        long[] createdShape = new long[]{shape[1], shape[2], shape[0]};
        int lencreatedShape = ArrayUtil.prod(createdShape);
        INDArray arr = Nd4j.linspace(1L, (long)lencreatedShape, (long)lencreatedShape, dataType).reshape(createdShape);
        INDArray permuted = arr.permute(2, 0, 1);
        return Collections.singletonList(new Pair<INDArray, String>(permuted, "get3dPermutedWithShape(" + seed + "," + Arrays.toString(shape) + ").get(0)"));
    }

    public static List<Pair<INDArray, String>> get3dReshapedWithShape(int seed, int[] shape, DataType dataType) {
        return NDArrayCreationUtil.get3dReshapedWithShape((long)seed, ArrayUtil.toLongArray(shape), dataType);
    }

    public static List<Pair<INDArray, String>> get3dReshapedWithShape(long seed, long[] shape, DataType dataType) {
        Nd4j.getRandom().setSeed(seed);
        long[] shape2d = new long[]{shape[0] * shape[2], shape[1]};
        int lenshape2d = ArrayUtil.prod(shape2d);
        INDArray array2d = Nd4j.linspace(1L, (long)lenshape2d, (long)lenshape2d, dataType).reshape(shape2d);
        INDArray array3d = array2d.reshape(shape);
        return Collections.singletonList(new Pair<INDArray, String>(array3d, "get3dReshapedWithShape(" + seed + "," + Arrays.toString(shape) + ").get(0)"));
    }

    public static List<Pair<INDArray, String>> getAll4dTestArraysWithShape(int seed, long[] shape, DataType dataType) {
        return NDArrayCreationUtil.getAll4dTestArraysWithShape(seed, ArrayUtil.toInts(shape), dataType);
    }

    public static List<Pair<INDArray, String>> getAll4dTestArraysWithShape(int seed, int[] shape, DataType dataType) {
        if (shape.length != 4) {
            throw new IllegalArgumentException("Shape is not length 4");
        }
        ArrayList<Pair<INDArray, String>> list = new ArrayList<Pair<INDArray, String>>();
        String baseMsg = "getAll4dTestArraysWithShape(" + seed + "," + Arrays.toString(shape) + ").get(";
        Nd4j.getRandom().setSeed(seed);
        int len = ArrayUtil.prod(shape);
        INDArray stdC = Nd4j.linspace(1L, (long)len, (long)len, dataType).reshape('c', ArrayUtil.toLongArray(shape));
        INDArray stdF = Nd4j.linspace(1L, (long)len, (long)len, dataType).reshape('f', ArrayUtil.toLongArray(shape));
        list.add(new Pair<INDArray, String>(stdC, baseMsg + "0)/Nd4j.rand(" + Arrays.toString(shape) + ",'c')"));
        list.add(new Pair<INDArray, String>(stdF, baseMsg + "1)/Nd4j.rand(" + Arrays.toString(shape) + ",'f')"));
        list.addAll(NDArrayCreationUtil.get4dSubArraysWithShape(seed, shape, dataType));
        list.addAll(NDArrayCreationUtil.get4dTensorAlongDimensionWithShape(seed, shape, dataType));
        list.addAll(NDArrayCreationUtil.get4dPermutedWithShape(seed, shape, dataType));
        list.addAll(NDArrayCreationUtil.get4dReshapedWithShape(seed, shape, dataType));
        return list;
    }

    public static List<Pair<INDArray, String>> get4dSubArraysWithShape(int seed, int[] shape, DataType dataType) {
        ArrayList<Pair<INDArray, String>> list = new ArrayList<Pair<INDArray, String>>();
        String baseMsg = "get4dSubArraysWithShape(" + seed + "," + Arrays.toString(shape) + ")";
        Nd4j.getRandom().setSeed(seed);
        int[] newShape1 = Arrays.copyOf(shape, shape.length);
        newShape1[0] = newShape1[0] + 5;
        int len = ArrayUtil.prod(newShape1);
        INDArray temp1 = Nd4j.linspace(1L, (long)len, (long)len, dataType).reshape(ArrayUtil.toLongArray(newShape1));
        INDArray subset1 = temp1.get(NDArrayIndex.interval(2, shape[0] + 2), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all());
        list.add(new Pair<INDArray, String>(subset1, baseMsg + ".get(0)"));
        int[] newShape2 = Arrays.copyOf(shape, shape.length);
        newShape2[1] = newShape2[1] + 5;
        int len2 = ArrayUtil.prod(newShape2);
        INDArray temp2 = Nd4j.linspace(1L, (long)len2, (long)len2, dataType).reshape(ArrayUtil.toLongArray(newShape2));
        INDArray subset2 = temp2.get(NDArrayIndex.all(), NDArrayIndex.interval(3, shape[1] + 3), NDArrayIndex.all(), NDArrayIndex.all());
        list.add(new Pair<INDArray, String>(subset2, baseMsg + ".get(1)"));
        int[] newShape3 = Arrays.copyOf(shape, shape.length);
        newShape3[2] = newShape3[2] + 5;
        int len3 = ArrayUtil.prod(newShape3);
        INDArray temp3 = Nd4j.linspace(1L, (long)len3, (long)len3, dataType).reshape(ArrayUtil.toLongArray(newShape3));
        INDArray subset3 = temp3.get(NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval(4, shape[2] + 4), NDArrayIndex.all());
        list.add(new Pair<INDArray, String>(subset3, baseMsg + ".get(2)"));
        int[] newShape4 = Arrays.copyOf(shape, shape.length);
        newShape4[3] = newShape4[3] + 5;
        int len4 = ArrayUtil.prod(newShape4);
        INDArray temp4 = Nd4j.linspace(1L, (long)len4, (long)len4, dataType).reshape(ArrayUtil.toLongArray(newShape4));
        INDArray subset4 = temp4.get(NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval(3, shape[3] + 3));
        list.add(new Pair<INDArray, String>(subset4, baseMsg + ".get(3)"));
        int[] newShape5 = Arrays.copyOf(shape, shape.length);
        newShape5[0] = newShape5[0] + 5;
        newShape5[1] = newShape5[1] + 5;
        newShape5[2] = newShape5[2] + 5;
        newShape5[3] = newShape5[3] + 5;
        int len5 = ArrayUtil.prod(newShape5);
        INDArray temp5 = Nd4j.linspace(1L, (long)len5, (long)len5, dataType).reshape(ArrayUtil.toLongArray(newShape5));
        INDArray subset5 = temp5.get(NDArrayIndex.interval(4, shape[0] + 4), NDArrayIndex.interval(3, shape[1] + 3), NDArrayIndex.interval(2, shape[2] + 2), NDArrayIndex.interval(1, shape[3] + 1));
        list.add(new Pair<INDArray, String>(subset5, baseMsg + ".get(4)"));
        return list;
    }

    public static List<Pair<INDArray, String>> get4dTensorAlongDimensionWithShape(int seed, int[] shape, DataType dataType) {
        ArrayList<Pair<INDArray, String>> list = new ArrayList<Pair<INDArray, String>>();
        String baseMsg = "get4dTensorAlongDimensionWithShape(" + seed + "," + Arrays.toString(shape) + ")";
        Nd4j.getRandom().setSeed(seed);
        int[] shape4d1 = new int[]{3, shape[0], shape[1], shape[2], shape[3]};
        int len = ArrayUtil.prod(shape4d1);
        INDArray orig1a = Nd4j.linspace(1L, (long)len, (long)len, dataType).reshape(ArrayUtil.toLongArray(shape4d1));
        INDArray tad1a = orig1a.tensorAlongDimension(0L, 1, 2, 3, 4);
        INDArray orig1b = Nd4j.linspace(1L, (long)len, (long)len, dataType).reshape(ArrayUtil.toLongArray(shape4d1));
        INDArray tad1b = orig1b.tensorAlongDimension(2L, 1, 2, 3, 4);
        list.add(new Pair<INDArray, String>(tad1a, baseMsg + ".get(0)"));
        list.add(new Pair<INDArray, String>(tad1b, baseMsg + ".get(1)"));
        int[] shape4d2 = new int[]{3, shape[0], shape[1], shape[2], shape[3]};
        int len2 = ArrayUtil.prod(shape4d2);
        INDArray orig2 = Nd4j.linspace(1L, (long)len2, (long)len2, dataType).reshape(ArrayUtil.toLongArray(shape4d2));
        INDArray tad2 = orig2.tensorAlongDimension(1L, 3, 4, 2, 1);
        list.add(new Pair<INDArray, String>(tad2, baseMsg + ".get(2)"));
        int[] shape4d3 = new int[]{shape[0], shape[1], 3, shape[2], shape[3]};
        int len3 = ArrayUtil.prod(shape4d3);
        INDArray orig3 = Nd4j.linspace(1L, (long)len3, (long)len3, dataType).reshape(ArrayUtil.toLongArray(shape4d3));
        INDArray tad3 = orig3.tensorAlongDimension(1L, 4, 1, 3, 0);
        list.add(new Pair<INDArray, String>(tad3, baseMsg + ".get(3)"));
        int[] shape4d4 = new int[]{shape[0], shape[1], shape[2], shape[3], 3};
        int len4 = ArrayUtil.prod(shape4d4);
        INDArray orig4 = Nd4j.linspace(1L, (long)len4, (long)len4, dataType).reshape(ArrayUtil.toLongArray(shape4d4));
        INDArray tad4 = orig4.tensorAlongDimension(1L, 2, 0, 3, 1);
        list.add(new Pair<INDArray, String>(tad4, baseMsg + ".get(4)"));
        return list;
    }

    public static List<Pair<INDArray, String>> get4dPermutedWithShape(int seed, int[] shape, DataType dataType) {
        Nd4j.getRandom().setSeed(seed);
        int[] createdShape = new int[]{shape[1], shape[3], shape[2], shape[0]};
        INDArray arr = Nd4j.rand(dataType, createdShape);
        INDArray permuted = arr.permute(3, 0, 2, 1);
        return Collections.singletonList(new Pair<INDArray, String>(permuted, "get4dPermutedWithShape(" + seed + "," + Arrays.toString(shape) + ").get(0)"));
    }

    public static List<Pair<INDArray, String>> get4dReshapedWithShape(int seed, int[] shape, DataType dataType) {
        Nd4j.getRandom().setSeed(seed);
        int[] shape2d = new int[]{shape[0] * shape[2], shape[1] * shape[3]};
        INDArray array2d = Nd4j.rand(dataType, shape2d);
        INDArray array3d = array2d.reshape(ArrayUtil.toLongArray(shape));
        return Collections.singletonList(new Pair<INDArray, String>(array3d, "get4dReshapedWithShape(" + seed + "," + Arrays.toString(shape) + ").get(0)"));
    }

    public static List<Pair<INDArray, String>> getAll5dTestArraysWithShape(int seed, int[] shape, DataType dataType) {
        if (shape.length != 5) {
            throw new IllegalArgumentException("Shape is not length 5");
        }
        ArrayList<Pair<INDArray, String>> list = new ArrayList<Pair<INDArray, String>>();
        String baseMsg = "getAll5dTestArraysWithShape(" + seed + "," + Arrays.toString(shape) + ").get(";
        Nd4j.getRandom().setSeed(seed);
        INDArray stdC = Nd4j.rand(dataType, shape, 'c');
        INDArray stdF = Nd4j.rand(dataType, shape, 'f');
        list.add(new Pair<INDArray, String>(stdC, baseMsg + "0)/Nd4j.rand(" + Arrays.toString(shape) + ",'c')"));
        list.add(new Pair<INDArray, String>(stdF, baseMsg + "1)/Nd4j.rand(" + Arrays.toString(shape) + ",'f')"));
        list.addAll(NDArrayCreationUtil.get5dSubArraysWithShape(seed, shape, dataType));
        list.addAll(NDArrayCreationUtil.get5dTensorAlongDimensionWithShape(seed, shape, dataType));
        list.addAll(NDArrayCreationUtil.get5dPermutedWithShape(seed, shape, dataType));
        list.addAll(NDArrayCreationUtil.get5dReshapedWithShape(seed, shape, dataType));
        return list;
    }

    public static List<Pair<INDArray, String>> get5dSubArraysWithShape(int seed, int[] shape, DataType dataType) {
        ArrayList<Pair<INDArray, String>> list = new ArrayList<Pair<INDArray, String>>();
        String baseMsg = "get5dSubArraysWithShape(" + seed + "," + Arrays.toString(shape) + ")";
        Nd4j.getRandom().setSeed(seed);
        int[] newShape1 = Arrays.copyOf(shape, shape.length);
        newShape1[0] = newShape1[0] + 5;
        INDArray temp1 = Nd4j.rand(dataType, newShape1);
        INDArray subset1 = temp1.get(NDArrayIndex.interval(2, shape[0] + 2), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all());
        list.add(new Pair<INDArray, String>(subset1, baseMsg + ".get(0)"));
        int[] newShape2 = Arrays.copyOf(shape, shape.length);
        newShape2[1] = newShape2[1] + 5;
        INDArray temp2 = Nd4j.rand(dataType, newShape2);
        INDArray subset2 = temp2.get(NDArrayIndex.all(), NDArrayIndex.interval(3, shape[1] + 3), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all());
        list.add(new Pair<INDArray, String>(subset2, baseMsg + ".get(1)"));
        int[] newShape3 = Arrays.copyOf(shape, shape.length);
        newShape3[2] = newShape3[2] + 5;
        INDArray temp3 = Nd4j.rand(dataType, newShape3);
        INDArray subset3 = temp3.get(NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval(4, shape[2] + 4), NDArrayIndex.all(), NDArrayIndex.all());
        list.add(new Pair<INDArray, String>(subset3, baseMsg + ".get(2)"));
        int[] newShape4 = Arrays.copyOf(shape, shape.length);
        newShape4[3] = newShape4[3] + 5;
        INDArray temp4 = Nd4j.rand(dataType, newShape4);
        INDArray subset4 = temp4.get(NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval(3, shape[3] + 3), NDArrayIndex.all());
        list.add(new Pair<INDArray, String>(subset4, baseMsg + ".get(3)"));
        int[] newShape5 = Arrays.copyOf(shape, shape.length);
        newShape5[4] = newShape5[4] + 5;
        INDArray temp5 = Nd4j.rand(dataType, newShape5);
        INDArray subset5 = temp5.get(NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval(3, shape[4] + 3));
        list.add(new Pair<INDArray, String>(subset5, baseMsg + ".get(4)"));
        int[] newShape6 = Arrays.copyOf(shape, shape.length);
        newShape6[0] = newShape6[0] + 5;
        newShape6[1] = newShape6[1] + 5;
        newShape6[2] = newShape6[2] + 5;
        newShape6[3] = newShape6[3] + 5;
        newShape6[4] = newShape6[4] + 5;
        INDArray temp6 = Nd4j.rand(dataType, newShape6);
        INDArray subset6 = temp6.get(NDArrayIndex.interval(4, shape[0] + 4), NDArrayIndex.interval(3, shape[1] + 3), NDArrayIndex.interval(2, shape[2] + 2), NDArrayIndex.interval(1, shape[3] + 1), NDArrayIndex.interval(2, shape[4] + 2));
        list.add(new Pair<INDArray, String>(subset6, baseMsg + ".get(5)"));
        return list;
    }

    public static List<Pair<INDArray, String>> get5dTensorAlongDimensionWithShape(int seed, int[] shape, DataType dataType) {
        ArrayList<Pair<INDArray, String>> list = new ArrayList<Pair<INDArray, String>>();
        String baseMsg = "get5dTensorAlongDimensionWithShape(" + seed + "," + Arrays.toString(shape) + ")";
        Nd4j.getRandom().setSeed(seed);
        int[] shape4d1 = new int[]{3, shape[0], shape[1], shape[2], shape[3], shape[4]};
        INDArray orig1a = Nd4j.rand(dataType, shape4d1);
        INDArray tad1a = orig1a.tensorAlongDimension(0L, 1, 2, 3, 4, 5);
        INDArray orig1b = Nd4j.rand(dataType, shape4d1);
        INDArray tad1b = orig1b.tensorAlongDimension(2L, 1, 2, 3, 4, 5);
        list.add(new Pair<INDArray, String>(tad1a, baseMsg + ".get(0)"));
        list.add(new Pair<INDArray, String>(tad1b, baseMsg + ".get(1)"));
        int[] shape4d2 = new int[]{3, shape[0], shape[1], shape[2], shape[3], shape[4]};
        INDArray orig2 = Nd4j.rand(dataType, shape4d2);
        INDArray tad2 = orig2.tensorAlongDimension(1L, 3, 5, 4, 2, 1);
        list.add(new Pair<INDArray, String>(tad2, baseMsg + ".get(2)"));
        int[] shape4d3 = new int[]{shape[0], shape[1], shape[2], shape[3], shape[4], 2};
        INDArray orig3 = Nd4j.rand(dataType, shape4d3);
        INDArray tad3 = orig3.tensorAlongDimension(1L, 4, 1, 3, 2, 0);
        list.add(new Pair<INDArray, String>(tad3, baseMsg + ".get(3)"));
        int[] shape4d4 = new int[]{shape[0], shape[1], shape[2], shape[3], 3, shape[4]};
        INDArray orig4 = Nd4j.rand(dataType, shape4d4);
        INDArray tad4 = orig4.tensorAlongDimension(1L, 5, 2, 0, 3, 1);
        list.add(new Pair<INDArray, String>(tad4, baseMsg + ".get(4)"));
        return list;
    }

    public static List<Pair<INDArray, String>> get5dPermutedWithShape(int seed, int[] shape, DataType dataType) {
        Nd4j.getRandom().setSeed(seed);
        int[] createdShape = new int[]{shape[1], shape[4], shape[3], shape[2], shape[0]};
        INDArray arr = Nd4j.rand(dataType, createdShape);
        INDArray permuted = arr.permute(4, 0, 3, 2, 1);
        return Collections.singletonList(new Pair<INDArray, String>(permuted, "get5dPermutedWithShape(" + seed + "," + Arrays.toString(shape) + ").get(0)"));
    }

    public static List<Pair<INDArray, String>> get5dReshapedWithShape(int seed, int[] shape, DataType dataType) {
        Nd4j.getRandom().setSeed(seed);
        int[] shape2d = new int[]{shape[0] * shape[2], shape[4], shape[1] * shape[3]};
        INDArray array3d = Nd4j.rand(dataType, shape2d);
        INDArray array5d = array3d.reshape(ArrayUtil.toLongArray(shape));
        return Collections.singletonList(new Pair<INDArray, String>(array5d, "get5dReshapedWithShape(" + seed + "," + Arrays.toString(shape) + ").get(0)"));
    }

    public static List<Pair<INDArray, String>> getAll6dTestArraysWithShape(int seed, int[] shape, DataType dataType) {
        if (shape.length != 6) {
            throw new IllegalArgumentException("Shape is not length 6");
        }
        ArrayList<Pair<INDArray, String>> list = new ArrayList<Pair<INDArray, String>>();
        String baseMsg = "getAll6dTestArraysWithShape(" + seed + "," + Arrays.toString(shape) + ").get(";
        Nd4j.getRandom().setSeed(seed);
        INDArray stdC = Nd4j.rand(dataType, shape, 'c');
        INDArray stdF = Nd4j.rand(dataType, shape, 'f');
        list.add(new Pair<INDArray, String>(stdC, baseMsg + "0)/Nd4j.rand(" + Arrays.toString(shape) + ",'c')"));
        list.add(new Pair<INDArray, String>(stdF, baseMsg + "1)/Nd4j.rand(" + Arrays.toString(shape) + ",'f')"));
        list.addAll(NDArrayCreationUtil.get6dSubArraysWithShape(seed, shape, dataType));
        list.addAll(NDArrayCreationUtil.get6dPermutedWithShape(seed, shape, dataType));
        list.addAll(NDArrayCreationUtil.get6dReshapedWithShape(seed, shape, dataType));
        return list;
    }

    public static List<Pair<INDArray, String>> get6dSubArraysWithShape(int seed, int[] shape, DataType dataType) {
        ArrayList<Pair<INDArray, String>> list = new ArrayList<Pair<INDArray, String>>();
        String baseMsg = "get6dSubArraysWithShape(" + seed + "," + Arrays.toString(shape) + ")";
        Nd4j.getRandom().setSeed(seed);
        int[] newShape1 = Arrays.copyOf(shape, shape.length);
        newShape1[0] = newShape1[0] + 5;
        INDArray temp1 = Nd4j.rand(dataType, newShape1);
        INDArray subset1 = temp1.get(NDArrayIndex.interval(2, shape[0] + 2), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all());
        list.add(new Pair<INDArray, String>(subset1, baseMsg + ".get(0)"));
        int[] newShape2 = Arrays.copyOf(shape, shape.length);
        newShape2[1] = newShape2[1] + 5;
        INDArray temp2 = Nd4j.rand(dataType, newShape2);
        INDArray subset2 = temp2.get(NDArrayIndex.all(), NDArrayIndex.interval(3, shape[1] + 3), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all());
        list.add(new Pair<INDArray, String>(subset2, baseMsg + ".get(1)"));
        int[] newShape3 = Arrays.copyOf(shape, shape.length);
        newShape3[2] = newShape3[2] + 5;
        INDArray temp3 = Nd4j.rand(dataType, newShape3);
        INDArray subset3 = temp3.get(NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval(4, shape[2] + 4), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all());
        list.add(new Pair<INDArray, String>(subset3, baseMsg + ".get(2)"));
        int[] newShape4 = Arrays.copyOf(shape, shape.length);
        newShape4[3] = newShape4[3] + 5;
        INDArray temp4 = Nd4j.rand(dataType, newShape4);
        INDArray subset4 = temp4.get(NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval(3, shape[3] + 3), NDArrayIndex.all(), NDArrayIndex.all());
        list.add(new Pair<INDArray, String>(subset4, baseMsg + ".get(3)"));
        int[] newShape5 = Arrays.copyOf(shape, shape.length);
        newShape5[4] = newShape5[4] + 5;
        INDArray temp5 = Nd4j.rand(dataType, newShape5);
        INDArray subset5 = temp5.get(NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval(3, shape[4] + 3), NDArrayIndex.all());
        list.add(new Pair<INDArray, String>(subset5, baseMsg + ".get(4)"));
        int[] newShape6 = Arrays.copyOf(shape, shape.length);
        newShape6[5] = newShape6[5] + 5;
        INDArray temp6 = Nd4j.rand(dataType, newShape6);
        INDArray subset6 = temp6.get(NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval(1, shape[5] + 1));
        list.add(new Pair<INDArray, String>(subset6, baseMsg + ".get(5)"));
        int[] newShape7 = Arrays.copyOf(shape, shape.length);
        newShape7[0] = newShape7[0] + 5;
        newShape7[1] = newShape7[1] + 5;
        newShape7[2] = newShape7[2] + 5;
        newShape7[3] = newShape7[3] + 5;
        newShape7[4] = newShape7[4] + 5;
        newShape7[5] = newShape7[5] + 5;
        INDArray temp7 = Nd4j.rand(dataType, newShape7);
        INDArray subset7 = temp7.get(NDArrayIndex.interval(4, shape[0] + 4), NDArrayIndex.interval(3, shape[1] + 3), NDArrayIndex.interval(2, shape[2] + 2), NDArrayIndex.interval(1, shape[3] + 1), NDArrayIndex.interval(2, shape[4] + 2), NDArrayIndex.interval(3, shape[5] + 3));
        list.add(new Pair<INDArray, String>(subset7, baseMsg + ".get(6)"));
        return list;
    }

    public static List<Pair<INDArray, String>> get6dPermutedWithShape(int seed, int[] shape, DataType dataType) {
        Nd4j.getRandom().setSeed(seed);
        int[] createdShape = new int[]{shape[1], shape[4], shape[5], shape[3], shape[2], shape[0]};
        INDArray arr = Nd4j.rand(dataType, createdShape);
        INDArray permuted = arr.permute(5, 0, 4, 3, 1, 2);
        return Collections.singletonList(new Pair<INDArray, String>(permuted, "get6dPermutedWithShape(" + seed + "," + Arrays.toString(shape) + ").get(0)"));
    }

    public static List<Pair<INDArray, String>> get6dReshapedWithShape(int seed, int[] shape, DataType dataType) {
        Nd4j.getRandom().setSeed(seed);
        int[] shape3d = new int[]{shape[0] * shape[2], shape[4] * shape[5], shape[1] * shape[3]};
        INDArray array3d = Nd4j.rand(dataType, shape3d);
        INDArray array6d = array3d.reshape(ArrayUtil.toLongArray(shape));
        return Collections.singletonList(new Pair<INDArray, String>(array6d, "get6dReshapedWithShape(" + seed + "," + Arrays.toString(shape) + ").get(0)"));
    }

    public static int[][] getRandomBroadCastShape(long seed, int rank2, int numShapes) {
        Nd4j.getRandom().setSeed(seed);
        INDArray coinFlip = Nd4j.getDistributions().createBinomial(1, 0.5).sample(new int[]{numShapes, rank2});
        int[][] ret = new int[coinFlip.rows()][coinFlip.columns()];
        for (int i = 0; i < coinFlip.rows(); ++i) {
            for (int j = 0; j < coinFlip.columns(); ++j) {
                int set = coinFlip.getInt(i, j);
                ret[i][j] = set > 0 ? set : Nd4j.getRandom().nextInt(9) + 1;
            }
        }
        return ret;
    }

    public static int[] broadcastToShape(int[] inputShapeWithOnes, long seed) {
        Nd4j.getRandom().setSeed(seed);
        int[] shape = new int[inputShapeWithOnes.length];
        for (int i = 0; i < shape.length; ++i) {
            shape[i] = inputShapeWithOnes[i] == 1 ? Nd4j.getRandom().nextInt(9) + 1 : inputShapeWithOnes[i];
        }
        return shape;
    }

    public static long[] broadcastToShape(long[] inputShapeWithOnes, long seed) {
        Nd4j.getRandom().setSeed(seed);
        long[] shape = new long[inputShapeWithOnes.length];
        for (int i = 0; i < shape.length; ++i) {
            shape[i] = inputShapeWithOnes[i] == 1L ? (long)(Nd4j.getRandom().nextInt(9) + 1) : inputShapeWithOnes[i];
        }
        return shape;
    }
}

