/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.AllocationsTracker;
import org.nd4j.linalg.api.memory.enums.AllocationKind;
import org.nd4j.linalg.api.ndarray.BaseShapeInfoProvider;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.api.shape.ShapeDescriptor;
import org.nd4j.linalg.api.shape.options.ArrayOptionsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectShapeInfoProvider
extends BaseShapeInfoProvider {
    private static final Logger log = LoggerFactory.getLogger(DirectShapeInfoProvider.class);
    private Map<ShapeDescriptor, Pair<DataBuffer, long[]>> shapeCache = new ConcurrentHashMap<ShapeDescriptor, Pair<DataBuffer, long[]>>();
    private Map<LongShapeDescriptor, Pair<DataBuffer, long[]>> longCache = new ConcurrentHashMap<LongShapeDescriptor, Pair<DataBuffer, long[]>>();
    private AtomicInteger counter = new AtomicInteger(0);
    private static final int MAX_ENTRIES = 1000;

    public Pair<DataBuffer, long[]> createShapeInformation(long[] shape, long[] stride, long elementWiseStride, char order2, DataType dataType) {
        long extras = 0L;
        extras = ArrayOptionsHelper.setOptionBit(extras, dataType);
        return this.createShapeInformation(shape, stride, elementWiseStride, order2, extras);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<DataBuffer, long[]> createShapeInformation(long[] shape, long[] stride, long elementWiseStride, char order2, long extras) {
        LongShapeDescriptor descriptor;
        if (elementWiseStride < 0L) {
            elementWiseStride = 0L;
        }
        if (!this.longCache.containsKey(descriptor = new LongShapeDescriptor(shape, stride, 0L, elementWiseStride, order2, extras))) {
            if (this.counter.get() < 1000) {
                DirectShapeInfoProvider directShapeInfoProvider = this;
                synchronized (directShapeInfoProvider) {
                    if (!this.longCache.containsKey(descriptor)) {
                        this.counter.incrementAndGet();
                        Pair<DataBuffer, long[]> buffer = super.createShapeInformation(shape, stride, elementWiseStride, order2, extras);
                        this.longCache.put(descriptor, buffer);
                        this.bytes.addAndGet(buffer.getFirst().length() * 8L * 2L);
                        AllocationsTracker.getInstance().markAllocated(AllocationKind.CONSTANT, 0, buffer.getFirst().length() * 8L * 2L);
                        return buffer;
                    }
                    return this.longCache.get(descriptor);
                }
            }
            return super.createShapeInformation(shape, stride, elementWiseStride, order2, extras);
        }
        return this.longCache.get(descriptor);
    }

    @Override
    public void purgeCache() {
        this.shapeCache = new ConcurrentHashMap<ShapeDescriptor, Pair<DataBuffer, long[]>>();
    }
}

