/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu.buffer;

import org.nd4j.linalg.api.memory.Deallocator;
import org.nd4j.linalg.cpu.nativecpu.buffer.BaseCpuDataBuffer;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.nd4j.nativeblas.OpaqueDataBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpuDeallocator
implements Deallocator {
    private static final Logger log = LoggerFactory.getLogger(CpuDeallocator.class);
    private final transient OpaqueDataBuffer opaqueDataBuffer;

    public CpuDeallocator(BaseCpuDataBuffer buffer) {
        this.opaqueDataBuffer = buffer.getOpaqueDataBuffer();
    }

    @Override
    public void deallocate() {
        if (this.opaqueDataBuffer == null) {
            throw new RuntimeException("opaqueDataBuffer is null");
        }
        NativeOpsHolder.getInstance().getDeviceNativeOps().deleteDataBuffer(this.opaqueDataBuffer);
    }
}

