/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu.rng;

import org.bytedeco.javacpp.PointerPointer;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.nd4j.nativeblas.OpaqueRandomGenerator;
import org.nd4j.rng.NativeRandom;

public class CpuNativeRandom
extends NativeRandom {
    private NativeOps nativeOps;

    public CpuNativeRandom() {
    }

    public CpuNativeRandom(long seed) {
        super(seed);
    }

    public CpuNativeRandom(long seed, long numberOfElements) {
        super(seed, numberOfElements);
    }

    @Override
    public void init() {
        this.nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();
        this.statePointer = this.nativeOps.createRandomGenerator(this.seed, this.seed ^ 0xFFFFFFFFDEADBEEFL);
    }

    @Override
    public void close() {
        this.nativeOps.deleteRandomGenerator((OpaqueRandomGenerator)this.statePointer);
    }

    @Override
    public PointerPointer getExtraPointers() {
        return null;
    }

    @Override
    public void setSeed(long seed) {
        this.seed = seed;
        this.currentPosition.set(0L);
        this.nativeOps.setRandomGeneratorStates((OpaqueRandomGenerator)this.statePointer, seed, seed ^ 0xFFFFFFFFDEADBEEFL);
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public int nextInt() {
        return this.nativeOps.getRandomGeneratorNextInt((OpaqueRandomGenerator)this.statePointer);
    }

    @Override
    public float nextFloat() {
        return this.nativeOps.getRandomGeneratorNextFloat((OpaqueRandomGenerator)this.statePointer);
    }

    @Override
    public double nextDouble() {
        return this.nativeOps.getRandomGeneratorNextDouble((OpaqueRandomGenerator)this.statePointer);
    }

    @Override
    public long nextLong() {
        return this.nativeOps.getRandomGeneratorNextLong((OpaqueRandomGenerator)this.statePointer);
    }

    @Override
    public long rootState() {
        return this.nativeOps.getRandomGeneratorRootState((OpaqueRandomGenerator)this.statePointer);
    }

    @Override
    public long nodeState() {
        return this.nativeOps.getRandomGeneratorNodeState((OpaqueRandomGenerator)this.statePointer);
    }

    @Override
    public void setStates(long rootState, long nodeState) {
        this.nativeOps.setRandomGeneratorStates((OpaqueRandomGenerator)this.statePointer, rootState, nodeState);
    }
}

