/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.heartbeat.utils;

import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.heartbeat.reports.Environment;

public class EnvironmentUtils {
    public static Environment buildEnvironment() {
        Environment environment = new Environment();
        environment.setJavaVersion(System.getProperty("java.specification.version"));
        environment.setNumCores(Runtime.getRuntime().availableProcessors());
        environment.setAvailableMemory(Runtime.getRuntime().maxMemory());
        environment.setOsArch(System.getProperty("os.arch"));
        environment.setOsName(System.getProperty("os.opName"));
        environment.setBackendUsed(Nd4j.getExecutioner().getClass().getSimpleName());
        return environment;
    }

    public static long buildCId() {
        long ret = 0L;
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface networkInterface : interfaces) {
                try {
                    byte[] arr = networkInterface.getHardwareAddress();
                    long seed = 0L;
                    for (int i = 0; i < arr.length; ++i) {
                        seed += ((long)arr[i] & 0xFFL) << 8 * i;
                    }
                    Random random = new Random(seed);
                    return random.nextLong();
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }
}

