/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing;

import java.util.List;
import lombok.NonNull;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.indexaccum.FirstIndex;
import org.nd4j.linalg.api.ops.impl.indexaccum.LastIndex;
import org.nd4j.linalg.api.ops.impl.reduce.longer.MatchCondition;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.CompareAndReplace;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.CompareAndSet;
import org.nd4j.linalg.api.ops.impl.transforms.custom.Choose;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.indexing.conditions.BaseCondition;
import org.nd4j.linalg.indexing.conditions.Condition;

public class BooleanIndexing {
    public static boolean and(INDArray n, Condition cond) {
        if (cond instanceof BaseCondition) {
            long val = (long)Nd4j.getExecutioner().exec(new MatchCondition(n, cond, new int[0])).getDouble(0L);
            return val == n.length();
        }
        throw new RuntimeException("Can only execute BaseCondition conditions using this method");
    }

    public static boolean[] and(INDArray n, Condition condition, int ... dimension) {
        if (!(condition instanceof BaseCondition)) {
            throw new UnsupportedOperationException("Only static Conditions are supported");
        }
        MatchCondition op = new MatchCondition(n, condition, dimension);
        INDArray arr = Nd4j.getExecutioner().exec(op);
        boolean[] result = new boolean[(int)arr.length()];
        long tadLength = Shape.getTADLength(n.shape(), dimension);
        int i = 0;
        while ((long)i < arr.length()) {
            result[i] = arr.getDouble((long)i) == (double)tadLength;
            ++i;
        }
        return result;
    }

    public static boolean[] or(INDArray n, Condition condition, int ... dimension) {
        if (!(condition instanceof BaseCondition)) {
            throw new UnsupportedOperationException("Only static Conditions are supported");
        }
        MatchCondition op = new MatchCondition(n, condition, dimension);
        INDArray arr = Nd4j.getExecutioner().exec(op);
        boolean[] result = new boolean[(int)arr.length()];
        int i = 0;
        while ((long)i < arr.length()) {
            result[i] = arr.getDouble((long)i) > 0.0;
            ++i;
        }
        return result;
    }

    public static boolean or(INDArray n, Condition cond) {
        if (cond instanceof BaseCondition) {
            long val = (long)Nd4j.getExecutioner().exec(new MatchCondition(n, cond, new int[0])).getDouble(0L);
            return val > 0L;
        }
        throw new RuntimeException("Can only execute BaseCondition conditions using this method");
    }

    public static void assignIf(@NonNull INDArray to, @NonNull INDArray from, @NonNull Condition condition) {
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (condition == null) {
            throw new NullPointerException("condition is marked non-null but is null");
        }
        if (!(condition instanceof BaseCondition)) {
            throw new UnsupportedOperationException("Only static Conditions are supported");
        }
        if (to.length() != from.length()) {
            throw new IllegalStateException("Mis matched length for to and from");
        }
        Nd4j.getExecutioner().exec(new CompareAndSet(to, from, to, condition));
    }

    public static void replaceWhere(@NonNull INDArray to, @NonNull INDArray from, @NonNull Condition condition) {
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (condition == null) {
            throw new NullPointerException("condition is marked non-null but is null");
        }
        if (!(condition instanceof BaseCondition)) {
            throw new UnsupportedOperationException("Only static Conditions are supported");
        }
        if (to.length() != from.length()) {
            throw new IllegalStateException("Mis matched length for to and from");
        }
        Nd4j.getExecutioner().exec(new CompareAndReplace(to, from, to, condition));
    }

    public static INDArray chooseFrom(@NonNull INDArray[] input, @NonNull Condition condition) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (condition == null) {
            throw new NullPointerException("condition is marked non-null but is null");
        }
        Choose choose2 = new Choose(input, condition);
        INDArray[] outputs = Nd4j.exec(choose2);
        int secondOutput = outputs[1].getInt(0);
        if (secondOutput < 1) {
            return null;
        }
        return choose2.getOutputArgument(0);
    }

    public static INDArray applyMask(INDArray arr, INDArray mask) {
        return arr.mul(mask);
    }

    public static INDArray applyMaskInPlace(INDArray arr, INDArray mask) {
        return arr.muli(mask);
    }

    public static INDArray chooseFrom(@NonNull INDArray[] input, @NonNull List<Double> tArgs, @NonNull List<Integer> iArgs, @NonNull Condition condition) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (tArgs == null) {
            throw new NullPointerException("tArgs is marked non-null but is null");
        }
        if (iArgs == null) {
            throw new NullPointerException("iArgs is marked non-null but is null");
        }
        if (condition == null) {
            throw new NullPointerException("condition is marked non-null but is null");
        }
        Choose choose2 = new Choose(input, iArgs, tArgs, condition);
        Nd4j.getExecutioner().execAndReturn(choose2);
        int secondOutput = choose2.getOutputArgument(1).getInt(0);
        if (secondOutput < 1) {
            return null;
        }
        INDArray ret = choose2.getOutputArgument(0).get(NDArrayIndex.interval(0, secondOutput));
        ret = ret.reshape(ret.length());
        return ret;
    }

    public static void replaceWhere(@NonNull INDArray to, @NonNull Number set, @NonNull Condition condition) {
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        if (set == null) {
            throw new NullPointerException("set is marked non-null but is null");
        }
        if (condition == null) {
            throw new NullPointerException("condition is marked non-null but is null");
        }
        if (!(condition instanceof BaseCondition)) {
            throw new UnsupportedOperationException("Only static Conditions are supported");
        }
        Nd4j.getExecutioner().exec(new CompareAndSet(to, set.doubleValue(), condition));
    }

    public static INDArray firstIndex(INDArray array, Condition condition) {
        if (!(condition instanceof BaseCondition)) {
            throw new UnsupportedOperationException("Only static Conditions are supported");
        }
        FirstIndex idx = new FirstIndex(array, condition, new int[0]);
        Nd4j.getExecutioner().exec(idx);
        return Nd4j.scalar(DataType.LONG, idx.getFinalResult().longValue());
    }

    public static INDArray firstIndex(INDArray array, Condition condition, int ... dimension) {
        if (!(condition instanceof BaseCondition)) {
            throw new UnsupportedOperationException("Only static Conditions are supported");
        }
        return Nd4j.getExecutioner().exec(new FirstIndex(array, condition, dimension));
    }

    public static INDArray lastIndex(INDArray array, Condition condition) {
        if (!(condition instanceof BaseCondition)) {
            throw new UnsupportedOperationException("Only static Conditions are supported");
        }
        LastIndex idx = new LastIndex(array, condition, new int[0]);
        Nd4j.getExecutioner().exec(idx);
        return Nd4j.scalar(DataType.LONG, idx.getFinalResult().longValue());
    }

    public static INDArray lastIndex(INDArray array, Condition condition, int ... dimension) {
        if (!(condition instanceof BaseCondition)) {
            throw new UnsupportedOperationException("Only static Conditions are supported");
        }
        return Nd4j.getExecutioner().exec(new LastIndex(array, condition, dimension));
    }
}

