/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing.conditions;

import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.conditions.AbsValueGreaterOrEqualsThan;
import org.nd4j.linalg.indexing.conditions.AbsValueGreaterThan;
import org.nd4j.linalg.indexing.conditions.AbsValueLessOrEqualsThan;
import org.nd4j.linalg.indexing.conditions.AbsValueLessThan;
import org.nd4j.linalg.indexing.conditions.AbsoluteEquals;
import org.nd4j.linalg.indexing.conditions.Condition;
import org.nd4j.linalg.indexing.conditions.EpsilonEquals;
import org.nd4j.linalg.indexing.conditions.EpsilonNotEquals;
import org.nd4j.linalg.indexing.conditions.EqualsCondition;
import org.nd4j.linalg.indexing.conditions.GreaterThan;
import org.nd4j.linalg.indexing.conditions.GreaterThanOrEqual;
import org.nd4j.linalg.indexing.conditions.IsFinite;
import org.nd4j.linalg.indexing.conditions.IsInfinite;
import org.nd4j.linalg.indexing.conditions.IsNaN;
import org.nd4j.linalg.indexing.conditions.LessThan;
import org.nd4j.linalg.indexing.conditions.LessThanOrEqual;
import org.nd4j.linalg.indexing.conditions.NotEqualsCondition;
import org.nd4j.linalg.indexing.conditions.NotFinite;

public class Conditions {
    private Conditions() {
    }

    public static Condition isInfinite() {
        return new IsInfinite();
    }

    public static Condition isNan() {
        return new IsNaN();
    }

    public static Condition isFinite() {
        return new IsFinite();
    }

    public static Condition notFinite() {
        return new NotFinite();
    }

    public static Condition epsNotEquals() {
        return Conditions.epsNotEquals(0.0);
    }

    public static Condition epsNotEquals(Number value) {
        return new EpsilonNotEquals(value);
    }

    public static Condition epsEquals() {
        return Conditions.epsEquals(0.0);
    }

    public static Condition epsEquals(Number value) {
        return Conditions.epsEquals(value, Nd4j.EPS_THRESHOLD);
    }

    public static Condition epsEquals(Number value, Number epsilon) {
        return new EpsilonEquals(value, epsilon.doubleValue());
    }

    public static Condition equals() {
        return Conditions.equals(0.0);
    }

    public static Condition equals(Number value) {
        return new EqualsCondition(value);
    }

    public static Condition notEquals() {
        return Conditions.notEquals(0.0);
    }

    public static Condition notEquals(Number value) {
        return new NotEqualsCondition(value);
    }

    public static Condition greaterThan() {
        return Conditions.greaterThan(0.0);
    }

    public static Condition greaterThan(Number value) {
        return new GreaterThan(value);
    }

    public static Condition lessThan() {
        return Conditions.lessThan(0.0);
    }

    public static Condition lessThan(Number value) {
        return new LessThan(value);
    }

    public static Condition lessThanOrEqual() {
        return Conditions.lessThanOrEqual(0.0);
    }

    public static Condition lessThanOrEqual(Number value) {
        return new LessThanOrEqual(value);
    }

    public static Condition greaterThanOrEqual() {
        return Conditions.greaterThanOrEqual(0.0);
    }

    public static Condition greaterThanOrEqual(Number value) {
        return new GreaterThanOrEqual(value);
    }

    public static Condition absGreaterThanOrEqual() {
        return Conditions.absGreaterThanOrEqual(0.0);
    }

    public static Condition absGreaterThanOrEqual(Number value) {
        return new AbsValueGreaterOrEqualsThan(value);
    }

    public static Condition absLessThanOrEqual() {
        return Conditions.absLessThanOrEqual(0.0);
    }

    public static Condition absLessThanOrEqual(Number value) {
        return new AbsValueLessOrEqualsThan(value);
    }

    public static Condition absGreaterThan() {
        return Conditions.absGreaterThan(0.0);
    }

    public static Condition absGreaterThan(Number value) {
        return new AbsValueGreaterThan(value);
    }

    public static Condition absLessThan() {
        return Conditions.absLessThan(0.0);
    }

    public static Condition absEquals() {
        return Conditions.absEquals(0.0);
    }

    public static Condition absEquals(double value) {
        return new AbsoluteEquals(value);
    }

    public static Condition absLessThan(Number value) {
        return new AbsValueLessThan(value);
    }

    public static Condition fromInt(int mode) {
        return Conditions.fromInt(mode, 0.0);
    }

    public static Condition fromInt(int mode, Double value) {
        if (value == null) {
            value = 0.0;
        }
        switch (ConditionMode.fromNumber(mode)) {
            case IS_FINITE: {
                return Conditions.isFinite();
            }
            case IS_NAN: {
                return Conditions.isInfinite();
            }
            case LESS_THAN: {
                return Conditions.lessThan(value);
            }
            case ABS_EQUALS: {
                return Conditions.absEquals(value);
            }
            case NOT_EQUALS: {
                return Conditions.notEquals();
            }
            case NOT_FINITE: {
                return Conditions.notFinite();
            }
            case IS_INFINITE: {
                return Conditions.isInfinite();
            }
            case GREATER_THAN: {
                return Conditions.greaterThan(value);
            }
            case ABS_LESS_THAN: {
                return Conditions.absLessThan(value);
            }
            case EPSILON_EQUALS: {
                return Conditions.epsEquals(value);
            }
            case ABS_GREATER_THAN: {
                return Conditions.absGreaterThan(value);
            }
            case EPSILON_NOT_EQUALS: {
                return Conditions.epsNotEquals(value);
            }
            case LESS_THAN_OR_EQUAL: {
                return Conditions.lessThanOrEqual(value);
            }
            case ABS_GREATER_OR_EQUAL: {
                return Conditions.absGreaterThan(value);
            }
            case GREATER_THAN_OR_EQUAL: {
                return Conditions.greaterThanOrEqual(value);
            }
            case ABS_LESS_THAN_OR_EQUAL: {
                return Conditions.absLessThanOrEqual(value);
            }
        }
        throw new IllegalArgumentException("Illegal value specified " + mode);
    }

    public static enum ConditionMode {
        EPSILON_EQUALS(0),
        EPSILON_NOT_EQUALS(1),
        LESS_THAN(2),
        GREATER_THAN(3),
        LESS_THAN_OR_EQUAL(4),
        GREATER_THAN_OR_EQUAL(5),
        ABS_LESS_THAN(6),
        ABS_GREATER_THAN(7),
        IS_INFINITE(8),
        IS_NAN(9),
        ABS_EQUALS(10),
        NOT_EQUALS(11),
        ABS_GREATER_OR_EQUAL(12),
        ABS_LESS_THAN_OR_EQUAL(13),
        IS_FINITE(14),
        NOT_FINITE(15),
        AGGREGATE(-1);

        public final int index;

        private ConditionMode(int index) {
            this.index = index;
        }

        public static ConditionMode fromNumber(int index) {
            switch (index) {
                case 0: {
                    return EPSILON_EQUALS;
                }
                case 1: {
                    return EPSILON_NOT_EQUALS;
                }
                case 2: {
                    return LESS_THAN;
                }
                case 3: {
                    return GREATER_THAN;
                }
                case 4: {
                    return LESS_THAN_OR_EQUAL;
                }
                case 5: {
                    return GREATER_THAN_OR_EQUAL;
                }
                case 6: {
                    return ABS_LESS_THAN;
                }
                case 7: {
                    return ABS_GREATER_THAN;
                }
                case 8: {
                    return IS_INFINITE;
                }
                case 9: {
                    return IS_NAN;
                }
                case 10: {
                    return ABS_EQUALS;
                }
                case 11: {
                    return NOT_EQUALS;
                }
                case 12: {
                    return ABS_GREATER_OR_EQUAL;
                }
                case 13: {
                    return ABS_LESS_THAN_OR_EQUAL;
                }
                case 14: {
                    return IS_FINITE;
                }
                case 15: {
                    return NOT_FINITE;
                }
                case -1: {
                    return AGGREGATE;
                }
            }
            throw new IllegalArgumentException("No condition number found for " + index);
        }
    }
}

