/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.profiler.data.primitives;

import java.util.Arrays;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackDescriptor {
    private static final Logger log = LoggerFactory.getLogger(StackDescriptor.class);
    protected StackTraceElement[] stackTrace;

    public StackDescriptor(@NonNull StackTraceElement[] stack2) {
        int start;
        if (stack2 == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        for (start = 0; start < stack2.length && !stack2[start].getClassName().contains("DefaultOpExecutioner"); ++start) {
        }
        if (start == stack2.length) {
            for (start = 0; start < stack2.length && (stack2[start + 1].getClassName().contains("OpProfiler") || stack2[start + 1].getClassName().contains("StackAggregator")); ++start) {
            }
        } else {
            while (start < stack2.length && stack2[start].getClassName().contains("DefaultOpExecutioner")) {
                ++start;
            }
        }
        while (start < stack2.length && stack2[start].getClassName().contains("OpProfiler")) {
            ++start;
        }
        this.stackTrace = Arrays.copyOfRange(stack2, start, stack2.length);
        ArrayUtils.reverse((Object[])this.stackTrace);
    }

    public String getEntryName() {
        return this.getElementName(0);
    }

    public String getElementName(int idx) {
        return this.stackTrace[idx].getClassName() + "." + this.stackTrace[idx].getMethodName() + ":" + this.stackTrace[idx].getLineNumber();
    }

    public int size() {
        return this.stackTrace.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackDescriptor that = (StackDescriptor)o;
        return Arrays.equals(this.stackTrace, that.stackTrace);
    }

    public int hashCode() {
        return Arrays.hashCode(this.stackTrace);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Stack trace: \n");
        for (int i = 0; i < this.size(); ++i) {
            builder.append("         ").append(i).append(": ").append(this.getElementName(i)).append("\n");
        }
        return builder.toString();
    }

    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }
}

