/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.nativeblas;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.bytedeco.javacpp.BooleanPointer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.indexer.BooleanIndexer;
import org.bytedeco.javacpp.indexer.ByteIndexer;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.HalfIndexer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.bytedeco.javacpp.indexer.LongIndexer;
import org.bytedeco.javacpp.indexer.ShortIndexer;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.javacpp.indexer.UShortIndexer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.concurrency.AffinityManager;
import org.nd4j.linalg.api.memory.MemcpyDirection;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.performance.PerformanceTracker;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.api.shape.options.ArrayOptionsHelper;
import org.nd4j.linalg.factory.BaseNDArrayFactory;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseNativeNDArrayFactory
extends BaseNDArrayFactory {
    private static final Logger log = LoggerFactory.getLogger(BaseNativeNDArrayFactory.class);
    protected NativeOps nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();

    public BaseNativeNDArrayFactory(DataType dtype, Character order2) {
        super(dtype, order2);
    }

    public BaseNativeNDArrayFactory(DataType dtype, char order2) {
        super(dtype, order2);
    }

    public BaseNativeNDArrayFactory() {
    }

    @Override
    public Pointer convertToNumpy(INDArray array) {
        LongPointer size2 = new LongPointer(1L);
        Pointer header = NativeOpsHolder.getInstance().getDeviceNativeOps().numpyHeaderForNd4j(array.data().pointer(), array.shapeInfoDataBuffer().pointer(), array.data().getElementSize(), size2);
        long headerSize = size2.get() - 1L;
        header.capacity(headerSize);
        header.position(0L);
        BytePointer bytePointer = new BytePointer((long)((int)(headerSize + (long)array.data().getElementSize() * array.data().length())));
        BytePointer headerCast = new BytePointer(header);
        ByteIndexer indexer = ByteIndexer.create((BytePointer)headerCast);
        int pos = 0;
        bytePointer.position((long)pos);
        Pointer.memcpy((Pointer)bytePointer, (Pointer)headerCast, (long)headerCast.capacity());
        pos = (int)((long)pos + headerCast.capacity());
        bytePointer.position((long)pos);
        Nd4j.getAffinityManager().ensureLocation(array, AffinityManager.Location.HOST);
        Pointer.memcpy((Pointer)bytePointer, (Pointer)array.data().pointer(), (long)((long)array.data().getElementSize() * array.data().length()));
        bytePointer.position(0L);
        return bytePointer;
    }

    @Override
    public INDArray createFromNpyPointer(Pointer pointer) {
        Pointer dataPointer = this.nativeOps.dataPointForNumpy(pointer);
        int dataBufferElementSize = this.nativeOps.elementSizeForNpyArray(pointer);
        DataBuffer data = null;
        Pointer shapeBufferPointer = this.nativeOps.shapeBufferForNumpy(pointer);
        int length = this.nativeOps.lengthForShapeBufferPointer(shapeBufferPointer);
        shapeBufferPointer.capacity((long)(8 * length));
        shapeBufferPointer.limit((long)(8 * length));
        shapeBufferPointer.position(0L);
        LongPointer intPointer = new LongPointer(shapeBufferPointer);
        LongPointer newPointer = new LongPointer((long)length);
        long perfD = PerformanceTracker.getInstance().helperStartTransaction();
        Pointer.memcpy((Pointer)newPointer, (Pointer)intPointer, (long)shapeBufferPointer.limit());
        PerformanceTracker.getInstance().helperRegisterTransaction(0, perfD, shapeBufferPointer.limit(), MemcpyDirection.HOST_TO_HOST);
        DataBuffer shapeBuffer = Nd4j.createBuffer((Pointer)newPointer, DataType.LONG, (long)length, (Indexer)LongIndexer.create((LongPointer)newPointer));
        dataPointer.position(0L);
        dataPointer.limit((long)dataBufferElementSize * Shape.length(shapeBuffer));
        dataPointer.capacity((long)dataBufferElementSize * Shape.length(shapeBuffer));
        long[] jvmShapeInfo = shapeBuffer.asLong();
        DataType dtype = ArrayOptionsHelper.dataType(jvmShapeInfo);
        switch (dtype) {
            case BOOL: {
                BooleanPointer dPointer = new BooleanPointer(dataPointer.limit() / (long)dataBufferElementSize);
                long perfX = PerformanceTracker.getInstance().helperStartTransaction();
                Pointer.memcpy((Pointer)dPointer, (Pointer)dataPointer, (long)dataPointer.limit());
                PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, dataPointer.limit(), MemcpyDirection.HOST_TO_HOST);
                data = Nd4j.createBuffer((Pointer)dPointer, dtype, Shape.length(shapeBuffer), (Indexer)BooleanIndexer.create((BooleanPointer)dPointer));
                break;
            }
            case UBYTE: {
                BooleanPointer dPointer = new BytePointer(dataPointer.limit() / (long)dataBufferElementSize);
                long perfX = PerformanceTracker.getInstance().helperStartTransaction();
                Pointer.memcpy((Pointer)dPointer, (Pointer)dataPointer, (long)dataPointer.limit());
                PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, dataPointer.limit(), MemcpyDirection.HOST_TO_HOST);
                data = Nd4j.createBuffer((Pointer)dPointer, dtype, Shape.length(shapeBuffer), (Indexer)UByteIndexer.create((BytePointer)dPointer));
                break;
            }
            case BYTE: {
                BooleanPointer dPointer = new BytePointer(dataPointer.limit() / (long)dataBufferElementSize);
                long perfX = PerformanceTracker.getInstance().helperStartTransaction();
                Pointer.memcpy((Pointer)dPointer, (Pointer)dataPointer, (long)dataPointer.limit());
                PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, dataPointer.limit(), MemcpyDirection.HOST_TO_HOST);
                data = Nd4j.createBuffer((Pointer)dPointer, dtype, Shape.length(shapeBuffer), (Indexer)ByteIndexer.create((BytePointer)dPointer));
                break;
            }
            case UINT64: 
            case LONG: {
                BooleanPointer dPointer = new LongPointer(dataPointer.limit() / (long)dataBufferElementSize);
                long perfX = PerformanceTracker.getInstance().helperStartTransaction();
                Pointer.memcpy((Pointer)dPointer, (Pointer)dataPointer, (long)dataPointer.limit());
                PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, dataPointer.limit(), MemcpyDirection.HOST_TO_HOST);
                data = Nd4j.createBuffer((Pointer)dPointer, dtype, Shape.length(shapeBuffer), (Indexer)LongIndexer.create((LongPointer)dPointer));
                break;
            }
            case UINT32: 
            case INT: {
                BooleanPointer dPointer = new IntPointer(dataPointer.limit() / (long)dataBufferElementSize);
                long perfX = PerformanceTracker.getInstance().helperStartTransaction();
                Pointer.memcpy((Pointer)dPointer, (Pointer)dataPointer, (long)dataPointer.limit());
                PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, dataPointer.limit(), MemcpyDirection.HOST_TO_HOST);
                data = Nd4j.createBuffer((Pointer)dPointer, dtype, Shape.length(shapeBuffer), (Indexer)IntIndexer.create((IntPointer)dPointer));
                break;
            }
            case UINT16: {
                BooleanPointer dPointer = new ShortPointer(dataPointer.limit() / (long)dataBufferElementSize);
                long perfX = PerformanceTracker.getInstance().helperStartTransaction();
                Pointer.memcpy((Pointer)dPointer, (Pointer)dataPointer, (long)dataPointer.limit());
                PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, dataPointer.limit(), MemcpyDirection.HOST_TO_HOST);
                data = Nd4j.createBuffer((Pointer)dPointer, dtype, Shape.length(shapeBuffer), (Indexer)UShortIndexer.create((ShortPointer)dPointer));
                break;
            }
            case SHORT: {
                BooleanPointer dPointer = new ShortPointer(dataPointer.limit() / (long)dataBufferElementSize);
                long perfX = PerformanceTracker.getInstance().helperStartTransaction();
                Pointer.memcpy((Pointer)dPointer, (Pointer)dataPointer, (long)dataPointer.limit());
                PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, dataPointer.limit(), MemcpyDirection.HOST_TO_HOST);
                data = Nd4j.createBuffer((Pointer)dPointer, dtype, Shape.length(shapeBuffer), (Indexer)ShortIndexer.create((ShortPointer)dPointer));
                break;
            }
            case BFLOAT16: 
            case HALF: {
                BooleanPointer dPointer = new ShortPointer(dataPointer.limit() / (long)dataBufferElementSize);
                long perfX = PerformanceTracker.getInstance().helperStartTransaction();
                Pointer.memcpy((Pointer)dPointer, (Pointer)dataPointer, (long)dataPointer.limit());
                PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, dataPointer.limit(), MemcpyDirection.HOST_TO_HOST);
                data = Nd4j.createBuffer((Pointer)dPointer, dtype, Shape.length(shapeBuffer), (Indexer)HalfIndexer.create((ShortPointer)dPointer));
                break;
            }
            case FLOAT: {
                BooleanPointer dPointer = new FloatPointer(dataPointer.limit() / (long)dataBufferElementSize);
                long perfX = PerformanceTracker.getInstance().helperStartTransaction();
                Pointer.memcpy((Pointer)dPointer, (Pointer)dataPointer, (long)dataPointer.limit());
                PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, dataPointer.limit(), MemcpyDirection.HOST_TO_HOST);
                data = Nd4j.createBuffer((Pointer)dPointer, dtype, Shape.length(shapeBuffer), (Indexer)FloatIndexer.create((FloatPointer)dPointer));
                break;
            }
            case DOUBLE: {
                BooleanPointer dPointer = new DoublePointer(dataPointer.limit() / (long)dataBufferElementSize);
                long perfX = PerformanceTracker.getInstance().helperStartTransaction();
                Pointer.memcpy((Pointer)dPointer, (Pointer)dataPointer, (long)dataPointer.limit());
                PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, dataPointer.limit(), MemcpyDirection.HOST_TO_HOST);
                data = Nd4j.createBuffer((Pointer)dPointer, dtype, Shape.length(shapeBuffer), (Indexer)DoubleIndexer.create((DoublePointer)dPointer));
            }
        }
        INDArray ret = Nd4j.create(data, Shape.shape(shapeBuffer), Shape.strideArr(shapeBuffer), 0L, Shape.order(shapeBuffer));
        Nd4j.getAffinityManager().tagLocation(ret, AffinityManager.Location.DEVICE);
        return ret;
    }

    @Override
    public INDArray createFromNpyHeaderPointer(Pointer pointer) {
        DataType dtype = DataType.fromInt(this.nativeOps.dataTypeFromNpyHeader(pointer));
        Pointer dataPointer = this.nativeOps.dataPointForNumpyHeader(pointer);
        int dataBufferElementSize = this.nativeOps.elementSizeForNpyArrayHeader(pointer);
        DataBuffer data = null;
        Pointer shapeBufferPointer = this.nativeOps.shapeBufferForNumpyHeader(pointer);
        int length = this.nativeOps.lengthForShapeBufferPointer(shapeBufferPointer);
        shapeBufferPointer.capacity((long)(8 * length));
        shapeBufferPointer.limit((long)(8 * length));
        shapeBufferPointer.position(0L);
        LongPointer intPointer = new LongPointer(shapeBufferPointer);
        LongPointer newPointer = new LongPointer((long)length);
        long perfD = PerformanceTracker.getInstance().helperStartTransaction();
        Pointer.memcpy((Pointer)newPointer, (Pointer)intPointer, (long)shapeBufferPointer.limit());
        PerformanceTracker.getInstance().helperRegisterTransaction(0, perfD, shapeBufferPointer.limit(), MemcpyDirection.HOST_TO_HOST);
        DataBuffer shapeBuffer = Nd4j.createBuffer((Pointer)newPointer, DataType.LONG, (long)length, (Indexer)LongIndexer.create((LongPointer)newPointer));
        dataPointer.position(0L);
        dataPointer.limit((long)dataBufferElementSize * Shape.length(shapeBuffer));
        dataPointer.capacity((long)dataBufferElementSize * Shape.length(shapeBuffer));
        long perfX = PerformanceTracker.getInstance().helperStartTransaction();
        switch (dtype) {
            case BYTE: {
                BytePointer dPointer = new BytePointer(dataPointer.limit() / (long)dataBufferElementSize);
                Pointer.memcpy((Pointer)dPointer, (Pointer)dataPointer, (long)dataPointer.limit());
                data = Nd4j.createBuffer((Pointer)dPointer, dtype, Shape.length(shapeBuffer), (Indexer)ByteIndexer.create((BytePointer)dPointer));
                break;
            }
            case SHORT: {
                BytePointer dPointer = new ShortPointer(dataPointer.limit() / (long)dataBufferElementSize);
                Pointer.memcpy((Pointer)dPointer, (Pointer)dataPointer, (long)dataPointer.limit());
                data = Nd4j.createBuffer((Pointer)dPointer, dtype, Shape.length(shapeBuffer), (Indexer)ShortIndexer.create((ShortPointer)dPointer));
                break;
            }
            case INT: {
                BytePointer dPointer = new IntPointer(dataPointer.limit() / (long)dataBufferElementSize);
                Pointer.memcpy((Pointer)dPointer, (Pointer)dataPointer, (long)dataPointer.limit());
                data = Nd4j.createBuffer((Pointer)dPointer, dtype, Shape.length(shapeBuffer), (Indexer)IntIndexer.create((IntPointer)dPointer));
                break;
            }
            case LONG: {
                BytePointer dPointer = new LongPointer(dataPointer.limit() / (long)dataBufferElementSize);
                Pointer.memcpy((Pointer)dPointer, (Pointer)dataPointer, (long)dataPointer.limit());
                data = Nd4j.createBuffer((Pointer)dPointer, dtype, Shape.length(shapeBuffer), (Indexer)LongIndexer.create((LongPointer)dPointer));
                break;
            }
            case UBYTE: {
                BytePointer dPointer = new BytePointer(dataPointer.limit() / (long)dataBufferElementSize);
                Pointer.memcpy((Pointer)dPointer, (Pointer)dataPointer, (long)dataPointer.limit());
                data = Nd4j.createBuffer((Pointer)dPointer, dtype, Shape.length(shapeBuffer), (Indexer)UByteIndexer.create((BytePointer)dPointer));
                break;
            }
            case UINT16: {
                BytePointer dPointer = new ShortPointer(dataPointer.limit() / (long)dataBufferElementSize);
                Pointer.memcpy((Pointer)dPointer, (Pointer)dataPointer, (long)dataPointer.limit());
                data = Nd4j.createBuffer((Pointer)dPointer, dtype, Shape.length(shapeBuffer), (Indexer)UShortIndexer.create((ShortPointer)dPointer));
                break;
            }
            case UINT32: {
                BytePointer dPointer = new IntPointer(dataPointer.limit() / (long)dataBufferElementSize);
                Pointer.memcpy((Pointer)dPointer, (Pointer)dataPointer, (long)dataPointer.limit());
                data = Nd4j.createBuffer((Pointer)dPointer, dtype, Shape.length(shapeBuffer), (Indexer)IntIndexer.create((IntPointer)dPointer));
                break;
            }
            case UINT64: {
                BytePointer dPointer = new LongPointer(dataPointer.limit() / (long)dataBufferElementSize);
                Pointer.memcpy((Pointer)dPointer, (Pointer)dataPointer, (long)dataPointer.limit());
                data = Nd4j.createBuffer((Pointer)dPointer, dtype, Shape.length(shapeBuffer), (Indexer)LongIndexer.create((LongPointer)dPointer));
                break;
            }
            case HALF: {
                BytePointer dPointer = new ShortPointer(dataPointer.limit() / (long)dataBufferElementSize);
                Pointer.memcpy((Pointer)dPointer, (Pointer)dataPointer, (long)dataPointer.limit());
                data = Nd4j.createBuffer((Pointer)dPointer, dtype, Shape.length(shapeBuffer), (Indexer)HalfIndexer.create((ShortPointer)dPointer));
                break;
            }
            case FLOAT: {
                BytePointer dPointer = new FloatPointer(dataPointer.limit() / (long)dataBufferElementSize);
                Pointer.memcpy((Pointer)dPointer, (Pointer)dataPointer, (long)dataPointer.limit());
                data = Nd4j.createBuffer((Pointer)dPointer, dtype, Shape.length(shapeBuffer), (Indexer)FloatIndexer.create((FloatPointer)dPointer));
                break;
            }
            case DOUBLE: {
                BytePointer dPointer = new DoublePointer(dataPointer.limit() / (long)dataBufferElementSize);
                Pointer.memcpy((Pointer)dPointer, (Pointer)dataPointer, (long)dataPointer.limit());
                data = Nd4j.createBuffer((Pointer)dPointer, dtype, Shape.length(shapeBuffer), (Indexer)DoubleIndexer.create((DoublePointer)dPointer));
                break;
            }
            default: {
                throw new RuntimeException("Unsupported data type: [" + (Object)((Object)dtype) + "]");
            }
        }
        PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, dataPointer.limit(), MemcpyDirection.HOST_TO_HOST);
        INDArray ret = Nd4j.create(data, Shape.shape(shapeBuffer), Shape.strideArr(shapeBuffer), 0L, Shape.order(shapeBuffer));
        return ret;
    }

    @Override
    public INDArray createFromNpyFile(File file) {
        byte[] pathBytes = file.getAbsolutePath().getBytes(Charset.forName("UTF-8"));
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(pathBytes.length).order(ByteOrder.nativeOrder());
        directBuffer.put(pathBytes);
        ((Buffer)directBuffer).rewind();
        ((Buffer)directBuffer).position(0);
        Pointer pointer = this.nativeOps.numpyFromFile(new BytePointer(directBuffer));
        INDArray result = this.createFromNpyPointer(pointer);
        this.nativeOps.releaseNumpy(pointer);
        return result;
    }

    @Override
    public Map<String, INDArray> createFromNpzFile(File file) throws Exception {
        HashMap<String, INDArray> map = new HashMap<String, INDArray>();
        FileInputStream is = new FileInputStream(file);
        while (true) {
            Object[] d;
            DataType dt;
            int elemSize;
            int b;
            byte[] localHeader = new byte[30];
            ((InputStream)is).read(localHeader);
            if (localHeader[2] != 3 || localHeader[3] != 4) {
                if (!map.isEmpty()) break;
                throw new IllegalStateException("Found malformed NZP file header: File is not a npz file? " + file.getPath());
            }
            byte fNameLength = localHeader[26];
            byte[] fNameBytes = new byte[fNameLength];
            ((InputStream)is).read(fNameBytes);
            String fName = "";
            for (int i = 0; i < fNameLength - 4; ++i) {
                fName = fName + (char)fNameBytes[i];
            }
            byte extraFieldLength = localHeader[28];
            if (extraFieldLength > 0) {
                ((InputStream)is).read(new byte[extraFieldLength]);
            }
            ((InputStream)is).read(new byte[11]);
            String headerStr = "";
            while ((b = ((InputStream)is).read()) != 10) {
                headerStr = headerStr + (char)b;
            }
            int idx = headerStr.contains("<") ? headerStr.indexOf("'<") + 2 : headerStr.indexOf("'|") + 2;
            String typeStr = headerStr.substring(idx, idx + 2);
            if (typeStr.equals("f8")) {
                elemSize = 8;
                dt = DataType.DOUBLE;
            } else if (typeStr.equals("f4")) {
                elemSize = 4;
                dt = DataType.FLOAT;
            } else if (typeStr.equals("f2")) {
                elemSize = 2;
                dt = DataType.HALF;
            } else if (typeStr.equals("i8")) {
                elemSize = 8;
                dt = DataType.LONG;
            } else if (typeStr.equals("i4")) {
                elemSize = 4;
                dt = DataType.INT;
            } else if (typeStr.equals("i2")) {
                elemSize = 2;
                dt = DataType.SHORT;
            } else if (typeStr.equals("i1")) {
                elemSize = 1;
                dt = DataType.BYTE;
            } else if (typeStr.equals("u1")) {
                elemSize = 1;
                dt = DataType.UBYTE;
            } else {
                throw new Exception("Unsupported data type: " + typeStr);
            }
            idx = headerStr.indexOf("'fortran_order': ");
            char order2 = headerStr.charAt(idx + "'fortran_order': ".length()) == 'F' ? (char)'c' : 'f';
            String shapeStr = headerStr.substring(headerStr.indexOf("(") + 1, headerStr.indexOf(")"));
            shapeStr = shapeStr.replace(" ", "");
            String[] dims = shapeStr.split(",");
            long[] shape = new long[dims.length];
            long size2 = 1L;
            for (int i = 0; i < dims.length; ++i) {
                long d2;
                shape[i] = d2 = Long.parseLong(dims[i]);
                size2 *= d2;
            }
            int numBytes = (int)(size2 * (long)elemSize);
            byte[] data = new byte[numBytes];
            ((InputStream)is).read(data);
            ByteBuffer bb = ByteBuffer.wrap(data);
            if (dt == DataType.DOUBLE) {
                double[] doubleData = new double[(int)size2];
                int i = 0;
                while ((long)i < size2) {
                    long l = bb.getLong(8 * i);
                    l = Long.reverseBytes(l);
                    doubleData[i] = Double.longBitsToDouble(l);
                    ++i;
                }
                map.put(fName, Nd4j.create(doubleData, shape, order2));
                continue;
            }
            if (dt == DataType.FLOAT) {
                float[] floatData = new float[(int)size2];
                int i = 0;
                while ((long)i < size2) {
                    float f;
                    int i2 = bb.getInt(4 * i);
                    i2 = Integer.reverseBytes(i2);
                    floatData[i] = f = Float.intBitsToFloat(i2);
                    ++i;
                }
                map.put(fName, Nd4j.create(floatData, shape, order2));
                continue;
            }
            if (dt == DataType.HALF) {
                INDArray arr = Nd4j.create(DataType.HALF, size2);
                ByteBuffer bb2 = arr.data().pointer().asByteBuffer();
                int i = 0;
                while ((long)i < size2) {
                    short s = bb.getShort(2 * i);
                    bb2.put((byte)(s >> 8 & 0xFF));
                    bb2.put((byte)(s & 0xFF));
                    ++i;
                }
                Nd4j.getAffinityManager().tagLocation(arr, AffinityManager.Location.HOST);
                map.put(fName, arr.reshape(order2, shape));
                continue;
            }
            if (dt == DataType.LONG) {
                d = new long[(int)size2];
                int i = 0;
                while ((long)i < size2) {
                    long l = bb.getLong(8 * i);
                    d[i] = l = Long.reverseBytes(l);
                    ++i;
                }
                map.put(fName, Nd4j.createFromArray(d).reshape(order2, shape));
                continue;
            }
            if (dt == DataType.INT) {
                d = new int[(int)size2];
                int i = 0;
                while ((long)i < size2) {
                    int l = bb.getInt(4 * i);
                    l = Integer.reverseBytes(l);
                    d[i] = l;
                    ++i;
                }
                map.put(fName, Nd4j.createFromArray((int[])d).reshape(order2, shape));
                continue;
            }
            if (dt == DataType.SHORT) {
                d = new short[(int)size2];
                int i = 0;
                while ((long)i < size2) {
                    short l = bb.getShort(2 * i);
                    l = Short.reverseBytes(l);
                    d[i] = l;
                    ++i;
                }
                map.put(fName, Nd4j.createFromArray((short[])d).reshape(order2, shape));
                continue;
            }
            if (dt == DataType.BYTE) {
                map.put(fName, Nd4j.createFromArray(data).reshape(order2, shape));
                continue;
            }
            if (dt != DataType.UBYTE) continue;
            d = new short[(int)size2];
            int i = 0;
            while ((long)i < size2) {
                short l = (short)(bb.get(i) & 0xFF);
                d[i] = l;
                ++i;
            }
            map.put(fName, Nd4j.createFromArray((short[])d).reshape(order2, shape).castTo(DataType.UBYTE));
        }
        return map;
    }

    public Map<String, INDArray> _createFromNpzFile(File file) throws Exception {
        byte[] pathBytes = file.getAbsolutePath().getBytes(Charset.forName("UTF-8"));
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(pathBytes.length).order(ByteOrder.nativeOrder());
        directBuffer.put(pathBytes);
        ((Buffer)directBuffer).rewind();
        ((Buffer)directBuffer).position(0);
        Pointer pointer = this.nativeOps.mapFromNpzFile(new BytePointer(directBuffer));
        int n = this.nativeOps.getNumNpyArraysInMap(pointer);
        HashMap<String, INDArray> map = new HashMap<String, INDArray>();
        for (int i = 0; i < n; ++i) {
            INDArray arr;
            DataBuffer data;
            FloatPointer dPointer;
            byte[] buffer = new byte[255];
            for (int j = 0; j < buffer.length; ++j) {
                buffer[j] = 0;
            }
            BytePointer charPointer = new BytePointer(buffer);
            String arrName = this.nativeOps.getNpyArrayNameFromMap(pointer, i, charPointer);
            Pointer arrPtr = this.nativeOps.getNpyArrayFromMap(pointer, i);
            int ndim = this.nativeOps.getNpyArrayRank(arrPtr);
            long[] shape = new long[ndim];
            LongPointer shapePtr = this.nativeOps.getNpyArrayShape(arrPtr);
            long length = 1L;
            for (int j = 0; j < ndim; ++j) {
                shape[j] = shapePtr.get((long)j);
                length *= shape[j];
            }
            int numBytes = this.nativeOps.getNpyArrayElemSize(arrPtr);
            int elemSize = numBytes * 8;
            char order2 = this.nativeOps.getNpyArrayOrder(arrPtr);
            Pointer dataPointer = this.nativeOps.dataPointForNumpyStruct(arrPtr);
            dataPointer.position(0L);
            long size2 = (long)elemSize * length;
            dataPointer.limit(size2);
            dataPointer.capacity(size2);
            if (elemSize == 32) {
                dPointer = new FloatPointer(dataPointer.limit() / (long)elemSize);
                data = Nd4j.createBuffer((Pointer)dPointer, DataType.FLOAT, length, (Indexer)FloatIndexer.create((FloatPointer)dPointer));
                arr = Nd4j.create(data, shape, Nd4j.getStrides(shape, order2), 0L, order2, DataType.FLOAT);
            } else if (elemSize == 64) {
                dPointer = new DoublePointer(dataPointer.limit() / (long)elemSize);
                data = Nd4j.createBuffer((Pointer)dPointer, DataType.DOUBLE, length, (Indexer)DoubleIndexer.create((DoublePointer)dPointer));
                arr = Nd4j.create(data, shape, Nd4j.getStrides(shape, order2), 0L, order2, DataType.DOUBLE);
            } else {
                throw new Exception("Unsupported data type: " + String.valueOf(elemSize));
            }
            map.put(arrName, arr);
        }
        return map;
    }
}

