/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.protobuf.common.collect;

import java.util.NoSuchElementException;
import org.nd4j.shade.protobuf.common.annotations.GwtCompatible;
import org.nd4j.shade.protobuf.common.base.Preconditions;
import org.nd4j.shade.protobuf.common.collect.UnmodifiableListIterator;

@GwtCompatible
abstract class AbstractIndexedListIterator<E>
extends UnmodifiableListIterator<E> {
    private final int size;
    private int position;

    protected abstract E get(int var1);

    protected AbstractIndexedListIterator(int size2) {
        this(size2, 0);
    }

    protected AbstractIndexedListIterator(int size2, int position) {
        Preconditions.checkPositionIndex(position, size2);
        this.size = size2;
        this.position = position;
    }

    @Override
    public final boolean hasNext() {
        return this.position < this.size;
    }

    @Override
    public final E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.get(this.position++);
    }

    @Override
    public final int nextIndex() {
        return this.position;
    }

    @Override
    public final boolean hasPrevious() {
        return this.position > 0;
    }

    @Override
    public final E previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        return this.get(--this.position);
    }

    @Override
    public final int previousIndex() {
        return this.position - 1;
    }
}

