/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.versioncheck;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.nd4j.common.config.ND4JClassLoading;
import org.nd4j.versioncheck.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionCheck {
    private static final Logger log = LoggerFactory.getLogger(VersionCheck.class);
    @Deprecated
    public static final String VERSION_CHECK_PROPERTY = "org.nd4j.versioncheck";
    public static final String GIT_PROPERTY_FILE_SUFFIX = "-git.properties";
    private static final String SCALA_210_SUFFIX = "_2.10";
    private static final String SCALA_211_SUFFIX = "_2.11";
    private static final String SPARK_1_VER_STRING = "spark_1";
    private static final String SPARK_2_VER_STRING = "spark_2";
    private static final String UNKNOWN_VERSION = "(Unknown)";
    private static final String DL4J_GROUPID = "org.deeplearning4j";
    private static final String DL4J_ARTIFACT = "deeplearning4j-nn";
    private static final String DATAVEC_GROUPID = "org.datavec";
    private static final String DATAVEC_ARTIFACT = "datavec-api";
    private static final String ND4J_GROUPID = "org.nd4j";
    private static final String ND4J_JBLAS_CLASS = "org.nd4j.linalg.jblas.JblasBackend";
    private static final String CANOVA_CLASS = "org.canova.api.io.data.DoubleWritable";
    private static final Set<String> GROUPIDS_TO_CHECK = new HashSet<String>(Arrays.asList("org.nd4j", "org.deeplearning4j", "org.datavec"));

    private VersionCheck() {
    }

    public static void checkVersions() {
        List<VersionInfo> dependencies;
        boolean doCheck = Boolean.parseBoolean(System.getProperty(VERSION_CHECK_PROPERTY, "true"));
        if (!doCheck) {
            return;
        }
        if (ND4JClassLoading.classPresentOnClasspath(ND4J_JBLAS_CLASS)) {
            log.error("Found incompatible/obsolete backend and version (nd4j-jblas) on classpath. ND4J is unlikely to function correctly with nd4j-jblas on the classpath. JVM will now exit.");
            System.exit(1);
        }
        if (ND4JClassLoading.classPresentOnClasspath(CANOVA_CLASS)) {
            log.error("Found incompatible/obsolete library Canova on classpath. ND4J is unlikely to function correctly with this library on the classpath. JVM will now exit.");
            System.exit(1);
        }
        if ((dependencies = VersionCheck.getVersionInfos()).size() <= 2) {
            if (dependencies.size() == 0) {
                return;
            }
            boolean dl4jViaClass = false;
            boolean datavecViaClass = false;
            for (VersionInfo vi : dependencies) {
                if (DL4J_GROUPID.equals(vi.getGroupId()) && DL4J_ARTIFACT.equals(vi.getArtifactId()) && UNKNOWN_VERSION.equals(vi.getBuildVersion())) {
                    dl4jViaClass = true;
                    continue;
                }
                if (!DATAVEC_GROUPID.equals(vi.getGroupId()) || !DATAVEC_ARTIFACT.equals(vi.getArtifactId()) || !UNKNOWN_VERSION.equals(vi.getBuildVersion())) continue;
                datavecViaClass = true;
            }
            if (dependencies.size() == 1 && (dl4jViaClass || datavecViaClass)) {
                return;
            }
            if (dependencies.size() == 2 && dl4jViaClass && datavecViaClass) {
                return;
            }
        }
        HashSet<String> foundVersions = new HashSet<String>();
        for (VersionInfo vi : dependencies) {
            String g = vi.getGroupId();
            if (g == null || !GROUPIDS_TO_CHECK.contains(g)) continue;
            String version = vi.getBuildVersion();
            if (version.contains("_spark_")) {
                version = version.replaceAll("_spark_1", "");
                version = version.replaceAll("_spark_2", "");
            }
            foundVersions.add(version);
        }
        boolean logVersions = false;
        if (foundVersions.size() > 1) {
            log.warn("*** ND4J VERSION CHECK FAILED - INCOMPATIBLE VERSIONS FOUND ***");
            log.warn("Incompatible versions (different version number) of DL4J, ND4J, RL4J, DataVec, Arbiter are unlikely to function correctly");
            logVersions = true;
        }
        boolean scala210 = false;
        boolean scala211 = false;
        boolean spark1 = false;
        boolean spark2 = false;
        for (VersionInfo vi : dependencies) {
            String artifact = vi.getArtifactId();
            if (!scala210 && artifact.contains(SCALA_210_SUFFIX)) {
                scala210 = true;
            }
            if (!scala211 && artifact.contains(SCALA_211_SUFFIX)) {
                scala211 = true;
            }
            String version = vi.getBuildVersion();
            if (!spark1 && version.contains(SPARK_1_VER_STRING)) {
                spark1 = true;
            }
            if (spark2 || !version.contains(SPARK_2_VER_STRING)) continue;
            spark2 = true;
        }
        if (scala210 && scala211) {
            log.warn("*** ND4J VERSION CHECK FAILED - FOUND BOTH SCALA VERSION 2.10 AND 2.11 ARTIFACTS ***");
            log.warn("Projects with mixed Scala versions (2.10/2.11) are unlikely to function correctly");
            logVersions = true;
        }
        if (spark1 && spark2) {
            log.warn("*** ND4J VERSION CHECK FAILED - FOUND BOTH SPARK VERSION 1 AND 2 ARTIFACTS ***");
            log.warn("Projects with mixed Spark versions (1 and 2) are unlikely to function correctly");
            logVersions = true;
        }
        if (logVersions) {
            log.info("Versions of artifacts found on classpath:");
            VersionCheck.logVersionInfo();
        }
    }

    public static List<URI> listGitPropertiesFiles() {
        Enumeration<URL> roots;
        try {
            roots = VersionCheck.class.getClassLoader().getResources("ai/skymind/");
        }
        catch (IOException e) {
            log.debug("Error listing resources for version check", (Throwable)e);
            return Collections.emptyList();
        }
        final ArrayList<URI> out = new ArrayList<URI>();
        while (roots.hasMoreElements()) {
            URL u = roots.nextElement();
            try {
                URI uri = u.toURI();
                FileSystem fileSystem = uri.getScheme().equals("jar") ? FileSystems.newFileSystem(uri, Collections.emptyMap()) : null;
                Throwable throwable = null;
                try {
                    Path myPath = Paths.get(uri);
                    Files.walkFileTree(myPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                            URI fileUri = file.toUri();
                            String s = fileUri.toString();
                            if (s.endsWith(VersionCheck.GIT_PROPERTY_FILE_SUFFIX)) {
                                out.add(fileUri);
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fileSystem == null) continue;
                    if (throwable != null) {
                        try {
                            fileSystem.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fileSystem.close();
                }
            }
            catch (NoClassDefFoundError uri) {
            }
            catch (Throwable e) {
                log.debug("Error finding/loading version check resources", e);
            }
        }
        Collections.sort(out);
        return out;
    }

    public static List<VersionInfo> getVersionInfos() {
        boolean dl4jFound = false;
        boolean datavecFound = false;
        ArrayList<VersionInfo> repState = new ArrayList<VersionInfo>();
        for (URI s : VersionCheck.listGitPropertiesFiles()) {
            VersionInfo grs;
            try {
                grs = new VersionInfo(s);
            }
            catch (Exception e) {
                log.debug("Error reading property files for {}", (Object)s);
                continue;
            }
            repState.add(grs);
            if (!dl4jFound && DL4J_GROUPID.equalsIgnoreCase(grs.getGroupId()) && DL4J_ARTIFACT.equalsIgnoreCase(grs.getArtifactId())) {
                dl4jFound = true;
            }
            if (datavecFound || !DATAVEC_GROUPID.equalsIgnoreCase(grs.getGroupId()) || !DATAVEC_ARTIFACT.equalsIgnoreCase(grs.getArtifactId())) continue;
            datavecFound = true;
        }
        if (ND4JClassLoading.classPresentOnClasspath(ND4J_JBLAS_CLASS)) {
            log.error("Found incompatible/obsolete backend and version (nd4j-jblas) on classpath. ND4J is unlikely to function correctly with nd4j-jblas on the classpath.");
        }
        if (ND4JClassLoading.classPresentOnClasspath(CANOVA_CLASS)) {
            log.error("Found incompatible/obsolete library Canova on classpath. ND4J is unlikely to function correctly with this library on the classpath.");
        }
        return repState;
    }

    public static String versionInfoString() {
        return VersionCheck.versionInfoString(Detail.GAV);
    }

    public static String versionInfoString(Detail detail) {
        StringBuilder sb = new StringBuilder();
        for (VersionInfo grp : VersionCheck.getVersionInfos()) {
            sb.append(grp.getGroupId()).append(" : ").append(grp.getArtifactId()).append(" : ").append(grp.getBuildVersion());
            switch (detail) {
                case FULL: 
                case GAVC: {
                    sb.append(" - ").append(grp.getCommitIdAbbrev());
                    if (detail != Detail.FULL) break;
                    sb.append("buildTime=").append(grp.getBuildTime()).append("branch=").append(grp.getBranch()).append("commitMsg=").append(grp.getCommitMessageShort());
                }
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void logVersionInfo() {
        VersionCheck.logVersionInfo(Detail.GAV);
    }

    public static void logVersionInfo(Detail detail) {
        List<VersionInfo> info = VersionCheck.getVersionInfos();
        for (VersionInfo grp : info) {
            switch (detail) {
                case GAV: {
                    log.info("{} : {} : {}", new Object[]{grp.getGroupId(), grp.getArtifactId(), grp.getBuildVersion()});
                    break;
                }
                case GAVC: {
                    log.info("{} : {} : {} - {}", new Object[]{grp.getGroupId(), grp.getArtifactId(), grp.getBuildVersion(), grp.getCommitIdAbbrev()});
                    break;
                }
                case FULL: {
                    log.info("{} : {} : {} - {}, buildTime={}, buildHost={} branch={}, commitMsg={}", new Object[]{grp.getGroupId(), grp.getArtifactId(), grp.getBuildVersion(), grp.getCommitId(), grp.getBuildTime(), grp.getBuildHost(), grp.getBranch(), grp.getCommitMessageShort()});
                }
            }
        }
    }

    public static enum Detail {
        GAV,
        GAVC,
        FULL;

    }
}

