/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.weightinit;

import java.util.Arrays;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.weightinit.WeightInitScheme;

public abstract class BaseWeightInitScheme
implements WeightInitScheme {
    private char order;

    public BaseWeightInitScheme() {
        this('c');
    }

    public BaseWeightInitScheme(char order2) {
        this.order = order2;
    }

    public abstract INDArray doCreate(DataType var1, long[] var2, INDArray var3);

    @Override
    public INDArray create(long[] shape, INDArray paramsView) {
        return this.handleParamsView(this.doCreate(paramsView.dataType(), shape, paramsView), paramsView);
    }

    @Override
    public INDArray create(DataType dataType, long ... shape) {
        INDArray ret = this.doCreate(dataType, shape, null);
        return ret;
    }

    @Override
    public char order() {
        return this.order;
    }

    protected INDArray handleParamsView(INDArray outputArray, INDArray paramView) {
        if (paramView == null || paramView == outputArray) {
            return outputArray;
        }
        INDArray flat = Nd4j.toFlattened(this.order(), outputArray);
        if (flat.length() != paramView.length()) {
            throw new RuntimeException("ParamView length does not match initialized weights length (view length: " + paramView.length() + ", view shape: " + Arrays.toString(paramView.shape()) + "; flattened length: " + flat.length());
        }
        paramView.assign(flat);
        return paramView.reshape(this.order(), outputArray.shape());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseWeightInitScheme)) {
            return false;
        }
        BaseWeightInitScheme other = (BaseWeightInitScheme)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.order == other.order;
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseWeightInitScheme;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.order;
        return result;
    }
}

