/*
 * Decompiled with CFR 0.152.
 */
package danyfel80.registration.evaluation;

import java.awt.Dimension;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import plugins.kernel.roi.roi2d.ROI2DPoint;

public class PointCorrespondenceEvaluation {
    private Map<String, ? extends ROI2DPoint> pts1;
    private Map<String, ? extends ROI2DPoint> pts2;
    private Dimension imgSize;
    private Set<String> commonPtsNames;
    private Map<String, Double> distances;
    double score;

    public static double evaluate(List<? extends ROI2DPoint> points1, List<? extends ROI2DPoint> points2, Dimension imageSize) {
        Objects.requireNonNull(points1, "Points 1 is null");
        Objects.requireNonNull(points2, "Points 2 is null");
        PointCorrespondenceEvaluation evaluator = new PointCorrespondenceEvaluation(points1, points2, imageSize);
        evaluator.compute();
        return evaluator.getScore();
    }

    public PointCorrespondenceEvaluation(List<? extends ROI2DPoint> points1, List<? extends ROI2DPoint> points2, Dimension imageSize) {
        this.pts1 = this.convertToPointMap(points1);
        this.pts2 = this.convertToPointMap(points2);
        this.imgSize = imageSize;
    }

    private Map<String, ? extends ROI2DPoint> convertToPointMap(List<? extends ROI2DPoint> points) {
        return points.stream().collect(Collectors.toMap(p -> p.getName(), p -> p));
    }

    private void compute() {
        this.filterCommonPoints();
        this.evaluatePointDistances();
        this.computeMedianScore();
    }

    private void filterCommonPoints() {
        Set<String> pts1Names = this.pts1.keySet();
        Set<String> pts2Names = this.pts2.keySet();
        this.commonPtsNames = new HashSet<String>(pts1Names);
        this.commonPtsNames.retainAll(pts2Names);
    }

    private void evaluatePointDistances() {
        double normalizer = Math.sqrt(this.imgSize.getWidth() * this.imgSize.getWidth() + this.imgSize.getHeight() * this.imgSize.getHeight());
        this.distances = new HashMap<String, Double>();
        for (String name : this.commonPtsNames) {
            this.distances.put(name, PointCorrespondenceEvaluation.euclideanDistance(this.pts1.get(name), this.pts2.get(name)) / normalizer);
        }
    }

    private static double euclideanDistance(ROI2DPoint point1, ROI2DPoint point2) {
        return point1.getPoint().distance(point2.getPoint());
    }

    private void computeMedianScore() {
        double[] sortedDists = this.distances.values().stream().mapToDouble(Double::doubleValue).sorted().toArray();
        System.out.println(sortedDists.length);
        this.score = sortedDists.length % 2 == 1 ? sortedDists[sortedDists.length / 2] : (sortedDists[sortedDists.length / 2 - 1] + sortedDists[sortedDists.length / 2]) / 2.0;
    }

    private double getScore() {
        return this.score;
    }
}

