/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.registration.elastic;

import algorithms.danyfel80.io.sequence.large.LargeSequenceHelper;
import danyfel80.registration.evaluation.PointCorrespondenceEvaluation;
import icy.common.exception.UnsupportedFormatException;
import icy.file.FileUtil;
import icy.roi.ROI;
import icy.util.XMLUtil;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarFile;
import plugins.kernel.roi.roi2d.ROI2DPoint;

public class PointRegistrationEvaluation
extends EzPlug {
    private EzVarFile sourceImage;
    private EzVarFile targetImage;
    private List<? extends ROI2DPoint> sourceRois;
    private List<? extends ROI2DPoint> targetRois;
    private Dimension imageSize;

    protected void initialize() {
        this.sourceImage = new EzVarFile("Source image", null);
        this.targetImage = new EzVarFile("Target image", null);
        this.addEzComponent((EzComponent)this.sourceImage);
        this.addEzComponent((EzComponent)this.targetImage);
    }

    protected void execute() {
        this.sourceRois = this.getSequenceRois((File)this.sourceImage.getValue(true));
        this.targetRois = this.getSequenceRois((File)this.targetImage.getValue(true));
        try {
            this.imageSize = this.retrieveSequenceSize((File)this.targetImage.getValue(true));
        }
        catch (UnsupportedFormatException | IOException e) {
            throw new RuntimeException(e);
        }
        System.out.println(PointCorrespondenceEvaluation.evaluate(this.sourceRois, this.targetRois, this.imageSize));
    }

    private Dimension retrieveSequenceSize(File imageFile) throws IOException, UnsupportedFormatException {
        return LargeSequenceHelper.getImageDimension((File)imageFile);
    }

    private List<? extends ROI2DPoint> getSequenceRois(File imageFile) {
        String fileName = FileUtil.getFileName((String)imageFile.toString(), (boolean)false);
        Path xmlFile = imageFile.toPath().resolveSibling(fileName + ".xml");
        if (Files.exists(xmlFile, new LinkOption[0])) {
            Document xml = XMLUtil.loadDocument((File)xmlFile.toFile());
            Element rootElement = XMLUtil.getRootElement((Document)xml);
            Element roisElement = XMLUtil.getElement((Node)rootElement, (String)"rois");
            List rois = ROI.loadROIsFromXML((Node)roisElement);
            return rois.stream().filter(r -> r instanceof ROI2DPoint).map(r -> (ROI2DPoint)r).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public void clean() {
    }
}

