/*
 * Decompiled with CFR 0.152.
 */
package danyfel80.registration.bspline.big;

import algorithms.danyfel80.io.sequence.large.LargeSequenceExporter;
import algorithms.danyfel80.io.sequence.large.LargeSequenceHelper;
import algorithms.danyfel80.io.sequence.large.LargeSequenceImporter;
import algorithms.danyfel80.io.sequence.tileprovider.ITileProvider;
import danyfel80.registration.bspline.big.BUnwarpRegistrationBigException;
import danyfel80.registration.bspline.big.TransformationSourceTileProvider;
import danyfel80.registration.bspline.big.TransformationTargetTileProvider;
import danyfel80.registration.bspline.classic.BUnwarpRegistration;
import danyfel80.registration.bspline.classic.DeformationScale;
import danyfel80.registration.bspline.classic.RegistrationMode;
import danyfel80.registration.bspline.classic.Transformation;
import icy.common.exception.UnsupportedFormatException;
import icy.common.listener.DetailedProgressListener;
import icy.file.FileUtil;
import icy.roi.ROI;
import icy.sequence.MetaDataUtil;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.type.DataType;
import icy.util.XMLUtil;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import ome.xml.meta.OMEXMLMetadata;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi2d.ROI2DPoint;

public class BUnwarpRegistrationBig {
    private static final Dimension REGISTERED_MAX_DIMENSION = new Dimension(1500, 1000);
    private File sourceFile;
    private File targetFile;
    private List<ROI2DPoint> sourceLandmarkROIs;
    private List<ROI2DPoint> targetLandmarkROIs;
    private RegistrationMode registrationMode;
    private int initialSubsampleFactor;
    private File transformedSourceFile;
    private File transformedTargetFile;
    private File transformedSourceOutputFile;
    private File transformedTargetOutputFile;
    private DeformationScale initialDeformationScale;
    private DeformationScale finalDeformationScale;
    private double divWeight;
    private double curlWeight;
    private double landmarkWeight;
    private double imageWeight;
    private double consistencyWeight;
    private double stopThreshold;
    private boolean showProcess;
    private Set<DetailedProgressListener> progressListeners = new HashSet<DetailedProgressListener>();
    private Set<DetailedProgressListener> progressOutputListeners = new HashSet<DetailedProgressListener>();
    private int subsampledSourceResolution;
    private int subsampledTargetResolution;
    private Sequence subsampledSourceSequence;
    private Sequence subsampledTargetSequence;
    private ROI2DArea sourceMask;
    private ROI2DArea targetMask;
    private BUnwarpRegistration registration;

    public File getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    public void setTargetFile(File targetFile) {
        this.targetFile = targetFile;
    }

    public void setSourceLandmarkROIs(List<ROI2DPoint> sourceLandmarkROIs) {
        this.sourceLandmarkROIs = sourceLandmarkROIs;
    }

    public void setTargetLandmarkROIs(List<ROI2DPoint> targetLandmarkROIs) {
        this.targetLandmarkROIs = targetLandmarkROIs;
    }

    public RegistrationMode getRegistrationMode() {
        return this.registrationMode;
    }

    public void setRegistrationMode(RegistrationMode registrationMode) {
        this.registrationMode = registrationMode;
    }

    public int getInitialSubsampleFactor() {
        return this.initialSubsampleFactor;
    }

    public void setInitialSubsampleFactor(int initialSubsampleFactor) {
        this.initialSubsampleFactor = initialSubsampleFactor;
    }

    public File getTransformedSourceFile() {
        return this.transformedSourceFile;
    }

    public void setTransformedSourceFile(File transformedSourceFile) {
        this.transformedSourceFile = transformedSourceFile;
    }

    public File getTransformedTargetFile() {
        return this.transformedTargetFile;
    }

    public void setTransformedTargetFile(File transformedTargetFile) {
        this.transformedTargetFile = transformedTargetFile;
    }

    public File getTransformedSourceOutputFile() {
        return this.transformedSourceOutputFile;
    }

    public void setTransformedSourceOutputFile(File transformedSourceOutputFile) {
        this.transformedSourceOutputFile = transformedSourceOutputFile;
    }

    public File getTransformedTargetOutputFile() {
        return this.transformedTargetOutputFile;
    }

    public void setTransformedTargetOutputFile(File transformedTargetOutputFile) {
        this.transformedTargetOutputFile = transformedTargetOutputFile;
    }

    public DeformationScale getInitialDeformationScale() {
        return this.initialDeformationScale;
    }

    public void setInitialDeformationScale(DeformationScale initialDeformationScale) {
        this.initialDeformationScale = initialDeformationScale;
    }

    public DeformationScale getFinalDeformationScale() {
        return this.finalDeformationScale;
    }

    public void setFinalDeformationScale(DeformationScale finalDeformationScale) {
        this.finalDeformationScale = finalDeformationScale;
    }

    public double getDivWeight() {
        return this.divWeight;
    }

    public void setDivWeight(double divWeight) {
        this.divWeight = divWeight;
    }

    public double getCurlWeight() {
        return this.curlWeight;
    }

    public void setCurlWeight(double curlWeight) {
        this.curlWeight = curlWeight;
    }

    public double getLandmarkWeight() {
        return this.landmarkWeight;
    }

    public void setLandmarkWeight(double landmarkWeight) {
        this.landmarkWeight = landmarkWeight;
    }

    public double getImageWeight() {
        return this.imageWeight;
    }

    public void setImageWeight(double imageWeight) {
        this.imageWeight = imageWeight;
    }

    public double getConsistencyWeight() {
        return this.consistencyWeight;
    }

    public void setConsistencyWeight(double consistencyWeight) {
        this.consistencyWeight = consistencyWeight;
    }

    public double getStopThreshold() {
        return this.stopThreshold;
    }

    public void setStopThreshold(double stopThreshold) {
        this.stopThreshold = stopThreshold;
    }

    public boolean isShowProcess() {
        return this.showProcess;
    }

    public void setShowProcess(boolean showProcess) {
        this.showProcess = showProcess;
    }

    public void addProgressListener(DetailedProgressListener listener) {
        this.progressListeners.add(listener);
    }

    public void addProgressOutputListener(DetailedProgressListener listener) {
        this.progressOutputListeners.add(listener);
    }

    private void notifyProgress(double progress, String message) {
        for (DetailedProgressListener l : this.progressListeners) {
            l.notifyProgress(progress, message, null);
        }
    }

    private void notifyProgressOutput(Sequence sequence) {
        for (DetailedProgressListener l : this.progressOutputListeners) {
            l.notifyProgress(Double.NaN, "", sequence);
        }
    }

    public void compute() throws BUnwarpRegistrationBigException, InterruptedException {
        long startTime = System.currentTimeMillis();
        try {
            this.importSubsampledSequences();
        }
        catch (Exception e) {
            throw new BUnwarpRegistrationBigException("Could not import input images.", e);
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Images loaded: " + (endTime - startTime) + "ms");
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        startTime = System.currentTimeMillis();
        try {
            this.performRegistration();
        }
        catch (Exception e) {
            throw new BUnwarpRegistrationBigException("Could not perform the registration.", e);
        }
        endTime = System.currentTimeMillis();
        System.out.println("Transformation computed: " + (endTime - startTime) + "ms");
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        startTime = System.currentTimeMillis();
        try {
            this.applyTransformationOnTransformedImages();
        }
        catch (InterruptedException e) {
            throw new BUnwarpRegistrationBigException("Could not apply transformation to large images: Interrupted", e);
        }
        catch (Exception e) {
            throw new BUnwarpRegistrationBigException("Could not apply transformation to large images:\n" + e.getMessage(), e);
        }
        endTime = System.currentTimeMillis();
        System.out.println("Registered images saved: " + (endTime - startTime) + "ms");
    }

    private void importSubsampledSequences() throws Exception {
        this.importSubsampledSourceSequence();
        this.importSubsampledTargetSequence();
    }

    private void importSubsampledSourceSequence() throws Exception {
        this.subsampledSourceResolution = LargeSequenceHelper.getResolutionLevel((File)this.getSourceFile(), (Dimension)REGISTERED_MAX_DIMENSION);
        this.subsampledSourceSequence = this.importSubsampledSequence(this.getSourceFile(), this.subsampledSourceResolution, "source");
        ArrayList rois = this.subsampledSourceSequence.getROIs();
        this.subsampledSourceSequence = SequenceUtil.convertToType((Sequence)this.subsampledSourceSequence, (DataType)DataType.UBYTE, (boolean)true, (boolean)true);
        this.subsampledSourceSequence.addROIs((Collection)rois, false);
        this.notifyProgressOutput(this.subsampledSourceSequence);
    }

    private void importSubsampledTargetSequence() throws Exception {
        this.subsampledTargetResolution = LargeSequenceHelper.getResolutionLevel((File)this.getTargetFile(), (Dimension)REGISTERED_MAX_DIMENSION);
        this.subsampledTargetSequence = this.importSubsampledSequence(this.getTargetFile(), this.subsampledTargetResolution, "target");
        ArrayList rois = this.subsampledTargetSequence.getROIs();
        this.subsampledTargetSequence = SequenceUtil.convertToType((Sequence)this.subsampledTargetSequence, (DataType)DataType.UBYTE, (boolean)true, (boolean)true);
        this.subsampledTargetSequence.addROIs((Collection)rois, false);
        this.notifyProgressOutput(this.subsampledTargetSequence);
    }

    private Sequence importSubsampledSequence(File file, int resolution, String label) throws Exception {
        LargeSequenceImporter importer = new LargeSequenceImporter();
        importer.setFilePath(file.toPath());
        importer.setTargetResolution((double)this.subsampledSourceResolution);
        importer.addProgressListener((progress, message, data) -> {
            this.notifyProgress(progress, String.format("Loading " + label + " image (%s)", message));
            return true;
        });
        return importer.call();
    }

    private void performRegistration() throws BUnwarpRegistrationBigException, InterruptedException {
        this.registration = new BUnwarpRegistration();
        this.setRegistrationParameters();
        for (DetailedProgressListener listener : this.progressListeners) {
            this.registration.addProgressListener(listener);
        }
        for (DetailedProgressListener listener : this.progressOutputListeners) {
            this.registration.addProgressOutputListener(listener);
        }
        this.registration.compute();
    }

    private void setRegistrationParameters() throws BUnwarpRegistrationBigException {
        this.registration.setSourceSequence(this.subsampledSourceSequence);
        this.registration.setTargetSequence(this.subsampledTargetSequence);
        this.registration.setRegistrationMode(this.getRegistrationMode());
        this.registration.setInitialSubsampleFactor(this.getInitialSubsampleFactor());
        this.registration.setTransformedSourceSequence(this.subsampledSourceSequence);
        this.registration.setTransformedTargetSequence(this.subsampledTargetSequence);
        this.registration.setInitialDeformationScale(this.getInitialDeformationScale());
        this.registration.setFinalDeformationScale(this.getFinalDeformationScale());
        this.registration.setDivWeight(this.getDivWeight());
        this.registration.setCurlWeight(this.getCurlWeight());
        this.registration.setLandmarkWeight(this.getLandmarkWeight());
        this.registration.setImageWeight(this.getImageWeight());
        this.registration.setConsistencyWeight(this.getConsistencyWeight());
        this.registration.setStopThreshold(this.getStopThreshold());
        this.registration.setShowProcess(this.isShowProcess());
        if (this.sourceLandmarkROIs == null || this.sourceLandmarkROIs.isEmpty() || this.targetLandmarkROIs == null || this.targetLandmarkROIs.isEmpty()) {
            this.extractLandmarks();
        }
        this.registration.setSourceLandmarks(BUnwarpRegistrationBig.convertLandmarksToPoints(this.sourceLandmarkROIs));
        this.registration.setTargetLandmarks(BUnwarpRegistrationBig.convertLandmarksToPoints(this.targetLandmarkROIs));
        this.extractMasks();
        this.registration.setSourceMask(this.sourceMask);
        this.registration.setTargetMask(this.targetMask);
    }

    private void extractLandmarks() throws BUnwarpRegistrationBigException {
        this.sourceLandmarkROIs = this.subsampledSourceSequence.getROIs(ROI2DPoint.class, false).stream().sorted(Comparator.comparing(ROI::getName)).collect(Collectors.toList());
        this.targetLandmarkROIs = this.subsampledTargetSequence.getROIs(ROI2DPoint.class, false).stream().sorted(Comparator.comparing(ROI::getName)).collect(Collectors.toList());
        this.checkLandmarksAreCorrectInSizeAndName();
    }

    private void checkLandmarksAreCorrectInSizeAndName() throws BUnwarpRegistrationBigException {
        if (this.sourceLandmarkROIs.size() != this.targetLandmarkROIs.size()) {
            throw new BUnwarpRegistrationBigException(String.format("Source landmarks(%d) and target landmarks(%d) have different size.", this.sourceLandmarkROIs.size(), this.targetLandmarkROIs.size()));
        }
        Iterator<ROI2DPoint> itSource = this.sourceLandmarkROIs.iterator();
        Iterator<ROI2DPoint> itTarget = this.targetLandmarkROIs.iterator();
        while (itSource.hasNext()) {
            ROI2DPoint sourceLandmark = itSource.next();
            ROI2DPoint targetLandmark = itTarget.next();
            if (sourceLandmark.getName().equals(targetLandmark.getName())) continue;
            throw new BUnwarpRegistrationBigException("No corresponding landmark for " + sourceLandmark.getName());
        }
    }

    private static List<Point2D> convertLandmarksToPoints(List<ROI2DPoint> landmarkROIs) {
        return landmarkROIs.stream().map(roi -> roi.getPoint()).collect(Collectors.toList());
    }

    private void extractMasks() {
        this.sourceMask = new ROI2DArea();
        this.sourceMask.addRect(0, 0, this.registration.getSourceSequence().getWidth(), this.registration.getSourceSequence().getHeight());
        this.targetMask = new ROI2DArea();
        this.targetMask.addRect(0, 0, this.registration.getTargetSequence().getWidth(), this.registration.getTargetSequence().getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyTransformationOnTransformedImages() throws InterruptedException {
        ThreadPoolExecutor transformExportThreads = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
        Future<Void> transformationOnSourceFuture = transformExportThreads.submit(this.getTransformationOnSourceImageTask());
        transformExportThreads.shutdown();
        try {
            try {
                transformationOnSourceFuture.get();
            }
            catch (ExecutionException e) {
                throw new BUnwarpRegistrationBigException("Could not save transformed source image:\n" + e.getMessage(), e);
            }
        }
        finally {
            transformExportThreads.shutdownNow();
            if (!transformExportThreads.awaitTermination(10L, TimeUnit.SECONDS)) {
                throw new BUnwarpRegistrationBigException("Transformation writer thread still did not finished writing source image.");
            }
        }
        if (this.getRegistrationMode() != RegistrationMode.MONO) {
            transformExportThreads = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
            Future<Void> transformationOnTargetFuture = transformExportThreads.submit(this.getTransformationOnTargetImageTask());
            transformExportThreads.shutdown();
            try {
                try {
                    transformationOnTargetFuture.get();
                }
                catch (ExecutionException e) {
                    throw new BUnwarpRegistrationBigException("Could not save transformed target image:\n" + e.getMessage(), e);
                }
            }
            finally {
                transformExportThreads.shutdownNow();
                if (!transformExportThreads.awaitTermination(10L, TimeUnit.SECONDS)) {
                    throw new BUnwarpRegistrationBigException("Transformation writer thread still did not finished writing target image.");
                }
            }
        }
    }

    private Callable<Void> getTransformationOnSourceImageTask() {
        return () -> {
            this.applyTransformationOnTransformedSourceImage();
            return null;
        };
    }

    private Callable<Void> getTransformationOnTargetImageTask() {
        return () -> {
            this.applyTransformationOnTransformedTargetImage();
            return null;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyTransformationOnTransformedSourceImage() throws InterruptedException {
        try (LargeSequenceExporter sourceExporter = new LargeSequenceExporter();){
            sourceExporter.setOutputFilePath(this.getTransformedSourceOutputFile().toPath());
            loci.formats.ome.OMEXMLMetadata outputImageMetadata = this.getTransformedSourceImageMetadata();
            sourceExporter.setOutputImageMetadata(outputImageMetadata);
            TransformationSourceTileProvider tileProvider = this.getTrasfromedSourceTileProvider(outputImageMetadata, sourceExporter.TILE_SIZE);
            sourceExporter.setTileProvider((ITileProvider)tileProvider);
            sourceExporter.addProgressListener((progress, message, data) -> {
                this.notifyProgress(progress, String.format("Creating transformed source image (%s)", message));
                return true;
            });
            try {
                sourceExporter.write();
            }
            finally {
                tileProvider.close();
            }
            this.applyTransformationOnSourceROIs();
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BUnwarpRegistrationBigException("Could not save transformed source image", e);
        }
    }

    private loci.formats.ome.OMEXMLMetadata getTransformedSourceImageMetadata() throws IOException {
        DataType sourceDataType;
        int sourceSizeC;
        Dimension targetSize;
        String name;
        try {
            name = LargeSequenceHelper.getImageName((File)this.transformedSourceFile);
            targetSize = LargeSequenceHelper.getImageDimension((File)this.transformedTargetFile);
            sourceSizeC = LargeSequenceHelper.getImageChannelCount((File)this.transformedSourceFile);
            sourceDataType = LargeSequenceHelper.getImageDataType((File)this.transformedSourceFile);
        }
        catch (Exception e) {
            throw new IOException("Could not create transformed source image metadata.", e);
        }
        loci.formats.ome.OMEXMLMetadata metaData = LargeSequenceExporter.createMetadata((int)targetSize.width, (int)targetSize.height, (int)sourceSizeC, (DataType)sourceDataType);
        MetaDataUtil.setName((OMEXMLMetadata)metaData, (int)0, (String)name);
        return metaData;
    }

    private TransformationSourceTileProvider getTrasfromedSourceTileProvider(loci.formats.ome.OMEXMLMetadata outputImageMetadata, Dimension tileSize) {
        TransformationSourceTileProvider sourceTileProvider = new TransformationSourceTileProvider();
        sourceTileProvider.setTransformedSourceFilePath(this.getTransformedSourceFile().toPath());
        sourceTileProvider.setOutputImageMetatada(outputImageMetadata);
        sourceTileProvider.setOutputTileSize(tileSize);
        sourceTileProvider.setTransformation(this.registration.getTransformation());
        sourceTileProvider.setSubsampledSourceSize(this.subsampledSourceSequence.getDimension2D());
        sourceTileProvider.setSubsampledTargetSize(this.subsampledTargetSequence.getDimension2D());
        return sourceTileProvider;
    }

    private void applyTransformationOnSourceROIs() throws InterruptedException, IOException {
        loci.formats.ome.OMEXMLMetadata outputSourceTImageMetadata;
        loci.formats.ome.OMEXMLMetadata outputTargetImageMetadata;
        loci.formats.ome.OMEXMLMetadata outputSourceImageMetadata;
        try {
            outputSourceImageMetadata = (loci.formats.ome.OMEXMLMetadata)LargeSequenceHelper.getImageMetadata((File)this.transformedSourceFile);
            outputTargetImageMetadata = (loci.formats.ome.OMEXMLMetadata)LargeSequenceHelper.getImageMetadata((File)this.transformedTargetFile);
            outputSourceTImageMetadata = (loci.formats.ome.OMEXMLMetadata)LargeSequenceHelper.getImageMetadata((File)this.transformedSourceOutputFile);
        }
        catch (UnsupportedFormatException | IOException e) {
            throw new IOException("Could not read source output image metadata", e);
        }
        Sequence tempTOutputS = new Sequence((OMEXMLMetadata)outputSourceTImageMetadata, MetaDataUtil.getName((OMEXMLMetadata)outputSourceTImageMetadata, (int)0));
        tempTOutputS.setFilename(this.transformedSourceOutputFile.getPath());
        List<ROI2DPoint> sourceRois = this.retrieveRoisFromFileXML(this.transformedSourceFile.toPath());
        Point2D.Double outputSourceSize = new Point2D.Double(MetaDataUtil.getSizeX((OMEXMLMetadata)outputSourceImageMetadata, (int)0), MetaDataUtil.getSizeY((OMEXMLMetadata)outputSourceImageMetadata, (int)0));
        Point2D.Double subsampledSourceSize = new Point2D.Double(this.subsampledSourceSequence.getWidth(), this.subsampledSourceSequence.getHeight());
        Point2D.Double outputTargetSize = new Point2D.Double(MetaDataUtil.getSizeX((OMEXMLMetadata)outputTargetImageMetadata, (int)0), MetaDataUtil.getSizeY((OMEXMLMetadata)outputTargetImageMetadata, (int)0));
        Point2D.Double subsampledTargetSize = new Point2D.Double(this.subsampledTargetSequence.getWidth(), this.subsampledTargetSequence.getHeight());
        sourceRois = this.transformSourceRois(sourceRois, this.registration.getTransformation(), outputSourceSize, subsampledSourceSize, outputTargetSize, subsampledTargetSize);
        tempTOutputS.addROIs(sourceRois, false);
        tempTOutputS.saveXMLData();
    }

    private List<ROI2DPoint> retrieveRoisFromFileXML(Path file) {
        String fileName = FileUtil.getFileName((String)file.toString(), (boolean)false);
        Path xmlFile = file.resolveSibling(fileName + ".xml");
        if (Files.exists(xmlFile, new LinkOption[0])) {
            Document xml = XMLUtil.loadDocument((File)xmlFile.toFile());
            Element rootElement = XMLUtil.getRootElement((Document)xml);
            Element roisElement = XMLUtil.getElement((Node)rootElement, (String)"rois");
            List<ROI2DPoint> rois = ROI.loadROIsFromXML((Node)roisElement).stream().filter(r -> r instanceof ROI2DPoint).map(r -> (ROI2DPoint)r).collect(Collectors.toList());
            return rois;
        }
        return Collections.emptyList();
    }

    private List<ROI2DPoint> transformSourceRois(List<ROI2DPoint> sourceRois, Transformation transformation, Point2D outputSourceSize, Point2D subsampledSourceSize, Point2D outputTargetSize, Point2D subsampledTargetSize) {
        return sourceRois.stream().map(r -> {
            Point2D pos = r.getPosition2D();
            double[] tPos = new double[]{pos.getX() * subsampledTargetSize.getX() / outputTargetSize.getX(), pos.getY() * subsampledTargetSize.getY() / outputTargetSize.getY()};
            transformation.transform(tPos[0], tPos[1], tPos, true);
            ROI2DPoint nr = new ROI2DPoint(tPos[0] * outputSourceSize.getX() / subsampledSourceSize.getX(), tPos[1] * outputSourceSize.getY() / subsampledSourceSize.getY());
            nr.setName(r.getName());
            return nr;
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyTransformationOnTransformedTargetImage() throws InterruptedException {
        try (LargeSequenceExporter targetExporter = new LargeSequenceExporter();){
            targetExporter.setOutputFilePath(this.getTransformedTargetOutputFile().toPath());
            loci.formats.ome.OMEXMLMetadata outputImageMetadata = this.getTransformedTargetImageMetadata();
            targetExporter.setOutputImageMetadata(outputImageMetadata);
            TransformationTargetTileProvider tileProvider = this.getTrasfromedTargetTileProvider(outputImageMetadata, targetExporter.TILE_SIZE);
            targetExporter.setTileProvider((ITileProvider)tileProvider);
            targetExporter.addProgressListener((progress, message, data) -> {
                this.notifyProgress(progress, String.format("Creating transformed target image (%s)", message));
                return true;
            });
            try {
                targetExporter.write();
            }
            finally {
                tileProvider.close();
            }
            this.applyTransformationOnTargetROIs();
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BUnwarpRegistrationBigException("Could not save transformed target image", e);
        }
    }

    private loci.formats.ome.OMEXMLMetadata getTransformedTargetImageMetadata() throws IOException {
        DataType targetDataType;
        int targetSizeC;
        Dimension sourceSize;
        String name;
        try {
            name = LargeSequenceHelper.getImageName((File)this.transformedTargetFile);
            sourceSize = LargeSequenceHelper.getImageDimension((File)this.transformedSourceFile);
            targetSizeC = LargeSequenceHelper.getImageChannelCount((File)this.transformedTargetFile);
            targetDataType = LargeSequenceHelper.getImageDataType((File)this.transformedTargetFile);
        }
        catch (Exception e) {
            throw new IOException("Could not create transformed target image metadata.", e);
        }
        loci.formats.ome.OMEXMLMetadata metaData = LargeSequenceExporter.createMetadata((int)sourceSize.width, (int)sourceSize.height, (int)targetSizeC, (DataType)targetDataType);
        MetaDataUtil.setName((OMEXMLMetadata)metaData, (int)0, (String)name);
        return metaData;
    }

    private TransformationTargetTileProvider getTrasfromedTargetTileProvider(loci.formats.ome.OMEXMLMetadata outputImageMetadata, Dimension tileSize) {
        TransformationTargetTileProvider targetTileProvider = new TransformationTargetTileProvider();
        targetTileProvider.setTransformedSourceFilePath(this.getTransformedTargetFile().toPath());
        targetTileProvider.setOutputImageMetatada(outputImageMetadata);
        targetTileProvider.setOutputTileSize(tileSize);
        targetTileProvider.setTransformation(this.registration.getTransformation());
        targetTileProvider.setSubsampledSourceSize(this.subsampledTargetSequence.getDimension2D());
        targetTileProvider.setSubsampledTargetSize(this.subsampledSourceSequence.getDimension2D());
        return targetTileProvider;
    }

    private void applyTransformationOnTargetROIs() throws IOException {
        loci.formats.ome.OMEXMLMetadata outputTargetTImageMetadata;
        loci.formats.ome.OMEXMLMetadata outputSourceImageMetadata;
        loci.formats.ome.OMEXMLMetadata outputTargetImageMetadata;
        try {
            outputTargetImageMetadata = (loci.formats.ome.OMEXMLMetadata)LargeSequenceHelper.getImageMetadata((File)this.transformedTargetFile);
            outputSourceImageMetadata = (loci.formats.ome.OMEXMLMetadata)LargeSequenceHelper.getImageMetadata((File)this.transformedSourceFile);
            outputTargetTImageMetadata = (loci.formats.ome.OMEXMLMetadata)LargeSequenceHelper.getImageMetadata((File)this.transformedTargetOutputFile);
        }
        catch (UnsupportedFormatException | IOException e) {
            throw new IOException("Could not read target output image metadata", e);
        }
        Sequence tempTOutputT = new Sequence((OMEXMLMetadata)outputTargetTImageMetadata, MetaDataUtil.getName((OMEXMLMetadata)outputTargetTImageMetadata, (int)0));
        tempTOutputT.setFilename(this.transformedTargetOutputFile.getPath());
        List<ROI2DPoint> targetRois = this.retrieveRoisFromFileXML(this.transformedTargetFile.toPath());
        Point2D.Double outputTargetSize = new Point2D.Double(MetaDataUtil.getSizeX((OMEXMLMetadata)outputTargetImageMetadata, (int)0), MetaDataUtil.getSizeY((OMEXMLMetadata)outputTargetImageMetadata, (int)0));
        Point2D.Double subsampledTargetSize = new Point2D.Double(this.subsampledTargetSequence.getWidth(), this.subsampledTargetSequence.getHeight());
        Point2D.Double outputSourceSize = new Point2D.Double(MetaDataUtil.getSizeX((OMEXMLMetadata)outputSourceImageMetadata, (int)0), MetaDataUtil.getSizeY((OMEXMLMetadata)outputSourceImageMetadata, (int)0));
        Point2D.Double subsampledSourceSize = new Point2D.Double(this.subsampledSourceSequence.getWidth(), this.subsampledSourceSequence.getHeight());
        targetRois = this.transformTargetRois(targetRois, this.registration.getTransformation(), outputTargetSize, subsampledTargetSize, outputSourceSize, subsampledSourceSize);
        tempTOutputT.addROIs(targetRois, false);
        tempTOutputT.saveXMLData();
    }

    private List<ROI2DPoint> transformTargetRois(List<ROI2DPoint> targetRois, Transformation transformation, Point2D outputTargetSize, Point2D subsampledTargetSize, Point2D outputSourceSize, Point2D subsampledSourceSize) {
        return targetRois.stream().map(r -> {
            Point2D pos = r.getPosition2D();
            double[] tPos = new double[]{pos.getX() * subsampledSourceSize.getX() / outputSourceSize.getX(), pos.getY() * subsampledSourceSize.getY() / outputSourceSize.getY()};
            transformation.transform(tPos[0], tPos[1], tPos, false);
            ROI2DPoint nr = new ROI2DPoint(tPos[0] * outputTargetSize.getX() / subsampledTargetSize.getX(), tPos[1] * outputTargetSize.getY() / subsampledTargetSize.getY());
            nr.setName(r.getName());
            return nr;
        }).collect(Collectors.toList());
    }
}

