/*
 * Decompiled with CFR 0.152.
 */
package danyfel80.registration.bspline.big;

import algorithms.danyfel80.io.sequence.cursor.IcyBufferedImageCursor;
import algorithms.danyfel80.io.sequence.tileprovider.CachedLargeSequenceTileProvider;
import algorithms.danyfel80.io.sequence.tileprovider.ITileProvider;
import danyfel80.registration.bspline.classic.BSplineModel;
import danyfel80.registration.bspline.classic.Transformation;
import icy.common.exception.UnsupportedFormatException;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.sequence.MetaDataUtil;
import icy.sequence.Sequence;
import icy.type.DataType;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.nio.file.Path;
import loci.formats.ome.OMEXMLMetadata;
import plugins.kernel.importer.LociImporterPlugin;

public abstract class TransformationTileProvider
implements ITileProvider {
    private Path transformedSourceFilePath;
    private OMEXMLMetadata outputImageMetadata;
    private Dimension outputTileSize;
    private Transformation transformation;
    private Dimension subsampledSourceSize;
    private Dimension subsampledTargetSize;
    private boolean providerPrepared;
    private LociImporterPlugin transformedSourceSequenceImporter;
    private Dimension transformedSourceFullSize;
    private Rectangle transformedSourceFullRectangle;
    private int transformedSourceSizeC;
    private DataType transformedSourceDataType;
    private Dimension transformedSourceTileSize;
    private Rectangle transformedSourceFullTileGrid;
    private CachedLargeSequenceTileProvider transformedSourceTileProvider;
    private Dimension outputFullSize;
    private int outputTileSizeC;
    private DataType outputTileDataType;
    private Point tileIndex;
    private Point currentTilePosition;
    private Rectangle currentTileRectangle;
    private BSplineModel coefficientsX;
    private BSplineModel coefficientsY;
    private double sourceXScaleFactor;
    private double sourceYScaleFactor;
    private Rectangle neededSourceRectangle;
    private Sequence neededSourceSequence;
    private IcyBufferedImage outputTileImage;
    private double coefficientScaleFactorY;
    private double coefficientScaleFactorX;

    public Path getTransformedSourceFilePath() {
        return this.transformedSourceFilePath;
    }

    public void setTransformedSourceFilePath(Path filePath) {
        this.transformedSourceFilePath = filePath;
    }

    public OMEXMLMetadata getOutputImageMetadata() {
        return this.outputImageMetadata;
    }

    public void setOutputImageMetatada(OMEXMLMetadata metadata) {
        this.outputImageMetadata = metadata;
    }

    public Dimension getOutputTileSize() {
        return this.outputTileSize;
    }

    public void setOutputTileSize(Dimension tileSize) {
        this.outputTileSize = tileSize;
    }

    public Transformation getTransformation() {
        return this.transformation;
    }

    public void setTransformation(Transformation transformation) {
        this.transformation = transformation;
    }

    public Dimension getSubsampledSourceSize() {
        return this.subsampledSourceSize;
    }

    public void setSubsampledSourceSize(Dimension subsampledSourceSize) {
        this.subsampledSourceSize = subsampledSourceSize;
    }

    public Dimension getSubsampledTargetSize() {
        return this.subsampledTargetSize;
    }

    public void setSubsampledTargetSize(Dimension subsampledTargetSize) {
        this.subsampledTargetSize = subsampledTargetSize;
    }

    public IcyBufferedImage getOutputTileImage() {
        return this.outputTileImage;
    }

    protected void setOutputTileImage(IcyBufferedImage outputImageTile) {
        this.outputTileImage = outputImageTile;
    }

    public IcyBufferedImage getTile(Point tileIndex) throws IOException {
        this.prepareProvider();
        this.setCurrentTileIndex(tileIndex);
        try {
            this.loadNeededInputForCurrentOutputTile();
        }
        catch (Exception e) {
            throw new IOException(String.format("Could not load needed input image for tile %s", tileIndex), e);
        }
        try {
            this.writeOutputTileImage();
        }
        catch (InterruptedException e) {
            throw new IOException(String.format("Interrupted while writing tile (%s) to output.", tileIndex), e);
        }
        return this.getOutputTileImage();
    }

    private void prepareProvider() throws IOException {
        if (!this.isProviderPrepared()) {
            this.setupTransformedSourceSequenceImporter();
            this.setupCacheTileProvider();
            this.setupOutputInformation();
            this.setupTransformationParameters();
            this.setProviderPrepared(true);
        }
    }

    protected boolean isProviderPrepared() {
        return this.providerPrepared;
    }

    protected void setProviderPrepared(boolean prepared) {
        this.providerPrepared = prepared;
    }

    private void setupTransformedSourceSequenceImporter() throws IOException {
        LociImporterPlugin transformedSourceSequenceImporter = new LociImporterPlugin();
        try {
            transformedSourceSequenceImporter.open(this.getTransformedSourceFilePath().toString(), 2);
        }
        catch (UnsupportedFormatException | IOException e) {
            transformedSourceSequenceImporter.close();
            throw new IOException("Could not open importer", e);
        }
        this.setTransformedSourceSequenceImporter(transformedSourceSequenceImporter);
        try {
            this.computeTransformedSourceFullSize();
            this.computeTransformedSourceFullRectangle();
            this.computeTransformedSourceSizeC();
            this.computeTransformedSourceDataType();
            this.computeTransformedSourceTileSize();
            this.computeTransformedSourceFullTileGrid();
        }
        catch (UnsupportedFormatException | IOException e) {
            throw new IOException("Could not retreive the needed transformed source image metadata", e);
        }
    }

    protected void setTransformedSourceSequenceImporter(LociImporterPlugin largeSequenceImporter) {
        this.transformedSourceSequenceImporter = largeSequenceImporter;
    }

    protected LociImporterPlugin getTransformedSourceSequenceImporter() {
        return this.transformedSourceSequenceImporter;
    }

    protected void computeTransformedSourceFullSize() throws UnsupportedFormatException, IOException {
        this.setTransformedSourceFullSize(new Dimension(MetaDataUtil.getSizeX((ome.xml.meta.OMEXMLMetadata)this.getTransformedSourceSequenceImporter().getOMEXMLMetaData(), (int)0), MetaDataUtil.getSizeY((ome.xml.meta.OMEXMLMetadata)this.getTransformedSourceSequenceImporter().getOMEXMLMetaData(), (int)0)));
    }

    private Dimension getTransformedSourceFullSize() {
        return this.transformedSourceFullSize;
    }

    private void setTransformedSourceFullSize(Dimension dimension) {
        this.transformedSourceFullSize = dimension;
    }

    protected void computeTransformedSourceFullRectangle() {
        this.setTransformedSourceFullRectangle(new Rectangle(this.getTransformedSourceFullSize()));
    }

    private Rectangle getTransformedSourceFullRectangle() {
        return this.transformedSourceFullRectangle;
    }

    private void setTransformedSourceFullRectangle(Rectangle rectangle) {
        this.transformedSourceFullRectangle = rectangle;
    }

    protected void computeTransformedSourceSizeC() throws UnsupportedFormatException, IOException {
        this.setTransformedSourceSizeC(MetaDataUtil.getSizeC((ome.xml.meta.OMEXMLMetadata)this.getTransformedSourceSequenceImporter().getOMEXMLMetaData(), (int)0));
    }

    protected int getTransformedSourceSizeC() {
        return this.transformedSourceSizeC;
    }

    private void setTransformedSourceSizeC(int sizeC) {
        this.transformedSourceSizeC = sizeC;
    }

    protected void computeTransformedSourceDataType() throws UnsupportedFormatException, IOException {
        this.setTransformedSourceDataType(MetaDataUtil.getDataType((ome.xml.meta.OMEXMLMetadata)this.getTransformedSourceSequenceImporter().getOMEXMLMetaData(), (int)0));
    }

    private DataType getTransformedSourceDataType() {
        return this.transformedSourceDataType;
    }

    private void setTransformedSourceDataType(DataType dataType) {
        this.transformedSourceDataType = dataType;
    }

    protected void computeTransformedSourceTileSize() throws UnsupportedFormatException, IOException {
        this.setTransformedSourceTileSize(new Dimension(this.getTransformedSourceSequenceImporter().getTileWidth(0), this.getTransformedSourceSequenceImporter().getTileHeight(0)));
    }

    private Dimension getTransformedSourceTileSize() {
        return this.transformedSourceTileSize;
    }

    private void setTransformedSourceTileSize(Dimension dimension) {
        this.transformedSourceTileSize = dimension;
    }

    protected void computeTransformedSourceFullTileGrid() {
        int maxTileX = this.getTransformedSourceFullSize().width / this.getTransformedSourceTileSize().width + (this.getTransformedSourceFullSize().width % this.getTransformedSourceTileSize().width != 0 ? 1 : 0);
        int maxTileY = this.getTransformedSourceFullSize().height / this.getTransformedSourceTileSize().height + (this.getTransformedSourceFullSize().height % this.getTransformedSourceTileSize().height != 0 ? 1 : 0);
        this.setTransformedSourceFullTileGrid(new Rectangle(0, 0, maxTileX, maxTileY));
    }

    private Rectangle getTransformedSourceFullTileGrid() {
        return this.transformedSourceFullTileGrid;
    }

    private void setTransformedSourceFullTileGrid(Rectangle rectangle) {
        this.transformedSourceFullTileGrid = rectangle;
    }

    protected void setupCacheTileProvider() throws IOException {
        try {
            this.setTransformedSourceTileProvider(new CachedLargeSequenceTileProvider.Builder(this.getTransformedSourceSequenceImporter()).build());
        }
        catch (IOException | IllegalArgumentException e) {
            throw new IOException("Could set cached tile provider for transformed source image", e);
        }
    }

    private CachedLargeSequenceTileProvider getTransformedSourceTileProvider() {
        return this.transformedSourceTileProvider;
    }

    private void setTransformedSourceTileProvider(CachedLargeSequenceTileProvider tileProvider) {
        this.transformedSourceTileProvider = tileProvider;
    }

    protected void setupOutputInformation() {
        this.computeOutputFullSize();
        this.computeOutputTileSizeC();
        this.computeOutputTileDataType();
    }

    protected void computeOutputFullSize() {
        int outputSizeX = MetaDataUtil.getSizeX((ome.xml.meta.OMEXMLMetadata)this.getOutputImageMetadata(), (int)0);
        int outputSizeY = MetaDataUtil.getSizeY((ome.xml.meta.OMEXMLMetadata)this.getOutputImageMetadata(), (int)0);
        this.setOutputFullSize(new Dimension(outputSizeX, outputSizeY));
    }

    private Dimension getOutputFullSize() {
        return this.outputFullSize;
    }

    private void setOutputFullSize(Dimension dimension) {
        this.outputFullSize = dimension;
    }

    protected void computeOutputTileSizeC() {
        int sizeC = MetaDataUtil.getSizeC((ome.xml.meta.OMEXMLMetadata)this.getOutputImageMetadata(), (int)0);
        this.setOutputTileSizeC(sizeC);
    }

    private int getOutputTileSizeC() {
        return this.outputTileSizeC;
    }

    private void setOutputTileSizeC(int sizeC) {
        this.outputTileSizeC = sizeC;
    }

    protected void computeOutputTileDataType() {
        DataType dataType = MetaDataUtil.getDataType((ome.xml.meta.OMEXMLMetadata)this.getOutputImageMetadata(), (int)0);
        this.setOutputTileDataType(dataType);
    }

    private DataType getOutputTileDataType() {
        return this.outputTileDataType;
    }

    private void setOutputTileDataType(DataType dataType) {
        this.outputTileDataType = dataType;
    }

    protected void setupTransformationParameters() {
        this.computeTransformationCoefficientModels();
        this.computeTransformationCoefficientScaleFactors();
        this.computeTransformationInterpolationScaleFactors();
    }

    protected abstract void computeTransformationCoefficientModels();

    protected BSplineModel getCoefficientsX() {
        return this.coefficientsX;
    }

    protected void setCoefficientsX(BSplineModel bSplineModel) {
        this.coefficientsX = bSplineModel;
    }

    protected BSplineModel getCoefficientsY() {
        return this.coefficientsY;
    }

    protected void setCoefficientsY(BSplineModel bSplineModel) {
        this.coefficientsY = bSplineModel;
    }

    private void computeTransformationCoefficientScaleFactors() {
        this.setCoefficientScaleFactorY((double)(this.getCoefficientsX().getHeight() - 3) / (double)(this.getOutputFullSize().height - 1));
        this.setCoefficientScaleFactorX((double)(this.getCoefficientsX().getWidth() - 3) / (double)(this.getOutputFullSize().width - 1));
    }

    protected double getCoefficientScaleFactorY() {
        return this.coefficientScaleFactorY;
    }

    protected void setCoefficientScaleFactorY(double scaleFactor) {
        this.coefficientScaleFactorY = scaleFactor;
    }

    protected double getCoefficientScaleFactorX() {
        return this.coefficientScaleFactorX;
    }

    protected void setCoefficientScaleFactorX(double scaleFactor) {
        this.coefficientScaleFactorX = scaleFactor;
    }

    private void computeTransformationInterpolationScaleFactors() {
        this.setSourceXScaleFactor(this.getTransformedSourceFullSize().getWidth() / this.getSubsampledSourceSize().getWidth());
        this.setSourceYScaleFactor(this.getTransformedSourceFullSize().getHeight() / this.getSubsampledSourceSize().getHeight());
    }

    protected double getSourceXScaleFactor() {
        return this.sourceXScaleFactor;
    }

    protected void setSourceXScaleFactor(double factorX) {
        this.sourceXScaleFactor = factorX;
    }

    protected double getSourceYScaleFactor() {
        return this.sourceYScaleFactor;
    }

    protected void setSourceYScaleFactor(double factorY) {
        this.sourceYScaleFactor = factorY;
    }

    protected void setCurrentTileIndex(Point tileIndex) {
        this.tileIndex = tileIndex;
        this.computeCurrentTileRectangle();
    }

    public Point getCurrentTileIndex() {
        return this.tileIndex;
    }

    private void computeCurrentTileRectangle() {
        this.computeCurrentTilePosition();
        this.setCurrentTileRectangle(new Rectangle(this.currentTilePosition, this.getOutputTileSize()));
        this.clipCurrentTileRectangleToOutput();
    }

    protected Rectangle getCurrentTileRectangle() {
        return this.currentTileRectangle;
    }

    protected void setCurrentTileRectangle(Rectangle rectangle) {
        this.currentTileRectangle = rectangle;
    }

    private void computeCurrentTilePosition() {
        this.setCurrentTilePosition(new Point(this.getCurrentTileIndex().x * this.getOutputTileSize().width, this.getCurrentTileIndex().y * this.getOutputTileSize().height));
    }

    protected Point getCurrentTilePosition() {
        return this.currentTilePosition;
    }

    protected void setCurrentTilePosition(Point point) {
        this.currentTilePosition = point;
    }

    protected void clipCurrentTileRectangleToOutput() {
        if (this.getCurrentTileRectangle().getMaxX() >= (double)this.getOutputFullSize().width) {
            this.getCurrentTileRectangle().width = (int)((double)this.getCurrentTileRectangle().width - (this.getCurrentTileRectangle().getMaxX() - (double)this.getOutputFullSize().width));
        }
        if (this.getCurrentTileRectangle().getMaxY() >= (double)this.getOutputFullSize().height) {
            this.getCurrentTileRectangle().height = (int)((double)this.getCurrentTileRectangle().height - (this.getCurrentTileRectangle().getMaxY() - (double)this.getOutputFullSize().height));
        }
    }

    private void loadNeededInputForCurrentOutputTile() throws Exception {
        this.computeNeededInputTilesForCurrentOutputTile();
        if (!this.getNeededSourceRectangle().isEmpty()) {
            this.setNeededSourceSequence(new Sequence(this.buildNeededInputFromCache(this.getNeededSourceRectangle())));
        }
    }

    private void computeNeededInputTilesForCurrentOutputTile() throws IOException {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (int j = 0; j < this.getCurrentTileRectangle().height; ++j) {
            double scaledY = (double)(j + this.getCurrentTileRectangle().y) * this.getCoefficientScaleFactorY() + 1.0;
            for (int i = 0; i < this.getCurrentTileRectangle().width; ++i) {
                double scaledX = (double)(i + this.getCurrentTileRectangle().x) * this.getCoefficientScaleFactorX() + 1.0;
                double interpolatedX = this.getCoefficientsX().prepareForInterpolationAndInterpolateI(scaledX, scaledY, false, false);
                double interpolatedY = this.getCoefficientsY().prepareForInterpolationAndInterpolateI(scaledX, scaledY, false, false);
                minX = Math.min(interpolatedX, minX);
                minY = Math.min(interpolatedY, minY);
                maxX = Math.max(interpolatedX, maxX);
                maxY = Math.max(interpolatedY, maxY);
            }
        }
        int scaledMinX = (int)Math.floor(minX * this.sourceXScaleFactor);
        int scaledMinY = (int)Math.floor(minY * this.sourceYScaleFactor);
        int scaledMaxX = (int)Math.ceil(maxX * this.sourceXScaleFactor);
        int scaledMaxY = (int)Math.ceil(maxY * this.sourceYScaleFactor);
        this.setNeededSourceRectangle(new Rectangle(scaledMinX, scaledMinY, scaledMaxX - scaledMinX, scaledMaxY - scaledMinY));
        Rectangle.intersect(this.getNeededSourceRectangle(), this.getTransformedSourceFullRectangle(), this.getNeededSourceRectangle());
    }

    protected Sequence getNeededSourceSequence() {
        return this.neededSourceSequence;
    }

    protected void setNeededSourceSequence(Sequence sequence) {
        this.neededSourceSequence = sequence;
    }

    private IcyBufferedImage buildNeededInputFromCache(Rectangle neededRectangle) throws IOException, InterruptedException {
        IcyBufferedImage neededImage = new IcyBufferedImage(neededRectangle.width, neededRectangle.height, this.getTransformedSourceSizeC(), this.getTransformedSourceDataType());
        Rectangle neededTileGrid = this.computeNeededTileGrid(neededRectangle);
        Point currentNeededTileIndex = new Point();
        Point currentNeededTilePosition = new Point();
        neededImage.beginUpdate();
        for (int j = 0; j < neededTileGrid.height; ++j) {
            currentNeededTileIndex.y = neededTileGrid.y + j;
            currentNeededTilePosition.y = currentNeededTileIndex.y * this.getTransformedSourceTileProvider().getTileSize().height - neededRectangle.y;
            if (0 >= currentNeededTileIndex.y && currentNeededTileIndex.y > this.getTransformedSourceFullTileGrid().height) continue;
            for (int i = 0; i < neededTileGrid.width; ++i) {
                IcyBufferedImage currentNeededTileImage;
                currentNeededTileIndex.x = neededTileGrid.x + i;
                currentNeededTilePosition.x = currentNeededTileIndex.x * this.getTransformedSourceTileProvider().getTileSize().width - neededRectangle.x;
                if (0 >= currentNeededTileIndex.x && currentNeededTileIndex.x > this.getTransformedSourceFullTileGrid().width) continue;
                try {
                    currentNeededTileImage = this.getTransformedSourceTileProvider().getTile(currentNeededTileIndex);
                }
                catch (IOException | IllegalArgumentException e) {
                    throw new IOException(String.format("Could not retrieve transformed source tile (%s)", currentNeededTileIndex), e);
                }
                neededImage.copyData(currentNeededTileImage, null, currentNeededTilePosition);
            }
        }
        neededImage.endUpdate();
        return neededImage;
    }

    private Rectangle computeNeededTileGrid(Rectangle neededRectangle) {
        int startTileX = Math.floorDiv((int)neededRectangle.getMinX(), this.getTransformedSourceTileSize().width);
        int startTileY = Math.floorDiv((int)neededRectangle.getMinY(), this.getTransformedSourceTileSize().height);
        int endTileX = Math.floorDiv((int)neededRectangle.getMaxX(), this.getTransformedSourceTileSize().width) + (Math.floorMod((int)neededRectangle.getMaxX(), this.getTransformedSourceTileSize().width) != 0 ? 1 : 0);
        int endTileY = Math.floorDiv((int)neededRectangle.getMaxY(), this.getTransformedSourceTileSize().height) + (Math.floorMod((int)neededRectangle.getMaxY(), this.getTransformedSourceTileSize().height) != 0 ? 1 : 0);
        Rectangle neededTileGrid = new Rectangle(startTileX, startTileY, endTileX - startTileX, endTileY - startTileY);
        neededTileGrid = neededTileGrid.intersection(this.getTransformedSourceFullTileGrid());
        return neededTileGrid;
    }

    private Rectangle getNeededSourceRectangle() {
        return this.neededSourceRectangle;
    }

    private void setNeededSourceRectangle(Rectangle rectangle) {
        this.neededSourceRectangle = rectangle;
    }

    private void writeOutputTileImage() throws InterruptedException {
        this.initializeOutputTileImage();
        if (this.getNeededSourceSequence() != null) {
            int c;
            BSplineModel[] neededImageModel = new BSplineModel[this.getNeededSourceSequence().getSizeC()];
            IcyBufferedImageCursor outputCursor = new IcyBufferedImageCursor(this.getOutputTileImage());
            for (c = 0; c < neededImageModel.length; ++c) {
                neededImageModel[c] = new BSplineModel(IcyBufferedImageUtil.extractChannel((IcyBufferedImage)this.getNeededSourceSequence().getFirstImage(), (int)c), false, 0);
                neededImageModel[c].setPyramidDepth(0);
                neededImageModel[c].startPyramids();
            }
            try {
                for (c = 0; c < neededImageModel.length; ++c) {
                    neededImageModel[c].getThread().join();
                }
            }
            catch (InterruptedException e) {
                System.out.println("Should never reach this");
                e.printStackTrace();
            }
            double targetYScaleFactor = (double)(this.getCoefficientsX().getHeight() - 3) / (double)(this.getOutputFullSize().height - 1);
            double targetXScaleFactor = (double)(this.getCoefficientsX().getWidth() - 3) / (double)(this.getOutputFullSize().width - 1);
            for (int j = 0; j < this.getCurrentTileRectangle().height; ++j) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                double scaledY = (double)(j + this.getCurrentTileRectangle().y) * targetYScaleFactor + 1.0;
                if (j >= this.getOutputTileImage().getHeight()) continue;
                for (int i = 0; i < this.getCurrentTileRectangle().width; ++i) {
                    double scaledX = (double)(i + this.getCurrentTileRectangle().x) * targetXScaleFactor + 1.0;
                    double interpolatedX = this.getCoefficientsX().prepareForInterpolationAndInterpolateI(scaledX, scaledY, false, false) * this.getSourceXScaleFactor();
                    double interpolatedY = this.getCoefficientsY().prepareForInterpolationAndInterpolateI(scaledX, scaledY, false, false) * this.getSourceYScaleFactor();
                    if (!(0.0 <= interpolatedX) || !(interpolatedX < (double)this.getTransformedSourceFullSize().width) || !(0.0 <= interpolatedY) || !(interpolatedY < (double)this.getTransformedSourceFullSize().height)) continue;
                    for (int c2 = 0; c2 < neededImageModel.length; ++c2) {
                        double value = neededImageModel[c2].prepareForInterpolationAndInterpolateI(interpolatedX - (double)this.getNeededSourceRectangle().x, interpolatedY - (double)this.getNeededSourceRectangle().y, false, false);
                        try {
                            outputCursor.setSafe(i, j, c2, value);
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            throw new RuntimeException(String.format("Index (%d, %d) out of bounds (%d, %d)", i, j, this.getOutputTileImage().getWidth(), this.getOutputTileImage().getHeight()), e);
                        }
                    }
                }
            }
            outputCursor.commitChanges();
        }
    }

    private void initializeOutputTileImage() {
        this.setOutputTileImage(new IcyBufferedImage(this.getCurrentTileRectangle().width, this.getCurrentTileRectangle().height, this.getOutputTileSizeC(), this.getOutputTileDataType()));
    }

    public void close() throws IOException {
        if (this.getTransformedSourceSequenceImporter() != null) {
            this.getTransformedSourceSequenceImporter().close();
        }
        if (this.getTransformedSourceTileProvider() != null) {
            try {
                this.getTransformedSourceTileProvider().close();
            }
            catch (Exception e) {
                throw new IOException("Could not close transformed source tile provider", e);
            }
        }
    }
}

