/*
 * Decompiled with CFR 0.152.
 */
package danyfel80.registration.bspline.classic;

import algorithms.danyfel80.io.sequence.cursor.IcyBufferedImageCursor;
import danyfel80.registration.bspline.classic.BSplineModel;
import danyfel80.registration.bspline.classic.DeformationScale;
import danyfel80.registration.bspline.classic.RegistrationMode;
import danyfel80.registration.bspline.classic.Transformation;
import icy.common.listener.DetailedProgressListener;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.sequence.Sequence;
import icy.type.DataType;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import plugins.kernel.roi.roi2d.ROI2DArea;

public class BUnwarpRegistration {
    private Sequence sourceSequence;
    private Sequence targetSequence;
    private ROI2DArea sourceMask;
    private ROI2DArea targetMask;
    private List<Point2D> sourceLandmarks;
    private List<Point2D> targetLandmarks;
    private RegistrationMode registrationMode;
    private int initialSubsampleFactor;
    private Sequence transformedSourceSequence;
    private Sequence transformedTargetSequence;
    private DeformationScale initialDeformationScale;
    private DeformationScale finalDeformationScale;
    private double divWeight;
    private double curlWeight;
    private double landmarkWeight;
    private double imageWeight;
    private double consistencyWeight;
    private double stopThreshold;
    private boolean showProcess;
    private Set<DetailedProgressListener> progressListeners = new HashSet<DetailedProgressListener>();
    private Set<DetailedProgressListener> progressOutputListeners = new HashSet<DetailedProgressListener>();
    private IcyBufferedImage originalSourceImage;
    private IcyBufferedImage originalTargetImage;
    private BSplineModel sourceBSplineModel;
    private BSplineModel targetBSplineModel;
    private Sequence sourceProgressOutput;
    private Sequence targetProgressOutput;
    private Transformation transformation;
    private Sequence directResult;
    private Sequence indirectResult;
    private Sequence resultTransformedSourceSequence;
    private Sequence resultTransformedTargetSequence;

    public Sequence getSourceSequence() {
        return this.sourceSequence;
    }

    public void setSourceSequence(Sequence sourceSequence) {
        this.sourceSequence = sourceSequence;
    }

    public Sequence getTargetSequence() {
        return this.targetSequence;
    }

    public void setTargetSequence(Sequence targetSequence) {
        this.targetSequence = targetSequence;
    }

    public ROI2DArea getSourceMask() {
        return this.sourceMask;
    }

    public void setSourceMask(ROI2DArea mask) {
        this.sourceMask = mask;
    }

    public ROI2DArea getTargetMask() {
        return this.targetMask;
    }

    public void setTargetMask(ROI2DArea mask) {
        this.targetMask = mask;
    }

    public List<Point2D> getSourceLandmarks() {
        return this.sourceLandmarks;
    }

    public void setSourceLandmarks(List<Point2D> sourceLandmarks) {
        this.sourceLandmarks = sourceLandmarks;
    }

    public List<Point2D> getTargetLandmarks() {
        return this.targetLandmarks;
    }

    public void setTargetLandmarks(List<Point2D> targetLandmarks) {
        this.targetLandmarks = targetLandmarks;
    }

    public RegistrationMode getRegistrationMode() {
        return this.registrationMode;
    }

    public void setRegistrationMode(RegistrationMode registrationMode) {
        this.registrationMode = registrationMode;
    }

    public int getInitialSubsampleFactor() {
        return this.initialSubsampleFactor;
    }

    public void setInitialSubsampleFactor(int initialSubsampleFactor) {
        this.initialSubsampleFactor = initialSubsampleFactor;
    }

    public Sequence getTransformedSourceSequence() {
        return this.transformedSourceSequence;
    }

    public void setTransformedSourceSequence(Sequence transformedSourceSequence) {
        this.transformedSourceSequence = transformedSourceSequence;
    }

    public Sequence getTransformedTargetSequence() {
        return this.transformedTargetSequence;
    }

    public void setTransformedTargetSequence(Sequence transformedTargetSequence) {
        this.transformedTargetSequence = transformedTargetSequence;
    }

    public DeformationScale getInitialDeformationScale() {
        return this.initialDeformationScale;
    }

    public void setInitialDeformationScale(DeformationScale initialDeformationScale) {
        this.initialDeformationScale = initialDeformationScale;
    }

    public DeformationScale getFinalDeformationScale() {
        return this.finalDeformationScale;
    }

    public void setFinalDeformationScale(DeformationScale finalDeformationScale) {
        this.finalDeformationScale = finalDeformationScale;
    }

    public double getDivWeight() {
        return this.divWeight;
    }

    public void setDivWeight(double divWeight) {
        this.divWeight = divWeight;
    }

    public double getCurlWeight() {
        return this.curlWeight;
    }

    public void setCurlWeight(double curlWeight) {
        this.curlWeight = curlWeight;
    }

    public double getLandmarkWeight() {
        return this.landmarkWeight;
    }

    public void setLandmarkWeight(double landmarkWeight) {
        this.landmarkWeight = landmarkWeight;
    }

    public double getImageWeight() {
        return this.imageWeight;
    }

    public void setImageWeight(double imageWeight) {
        this.imageWeight = imageWeight;
    }

    public double getConsistencyWeight() {
        return this.consistencyWeight;
    }

    public void setConsistencyWeight(double consistencyWeight) {
        this.consistencyWeight = consistencyWeight;
    }

    public double getStopThreshold() {
        return this.stopThreshold;
    }

    public void setStopThreshold(double stopThreshold) {
        this.stopThreshold = stopThreshold;
    }

    public boolean isShowProcess() {
        return this.showProcess;
    }

    public void setShowProcess(boolean showProcess) {
        this.showProcess = showProcess;
    }

    public void addProgressListener(DetailedProgressListener listener) {
        this.progressListeners.add(listener);
    }

    public void removeProgressListener(DetailedProgressListener listener) {
        this.progressListeners.remove(listener);
    }

    private void notifyProgress(double progress, String message) {
        for (DetailedProgressListener listener : this.progressListeners) {
            listener.notifyProgress(progress, message, null);
        }
    }

    public void addProgressOutputListener(DetailedProgressListener listener) {
        this.progressOutputListeners.add(listener);
    }

    public void removeProgressOutputListener(DetailedProgressListener listener) {
        this.progressOutputListeners.remove(listener);
    }

    public Sequence getDirectResult() {
        return this.directResult;
    }

    public Sequence getIndirectResult() {
        return this.indirectResult;
    }

    public void compute() throws InterruptedException {
        this.copyOriginalImages();
        this.createImageBSplineModels();
        this.notifyProgress(Double.NaN, "Starting image pyramids...");
        this.computePyramids();
        if (this.isShowProcess()) {
            this.initializeProgressOutput();
        }
        this.adjustConsistencyWeight();
        this.createTransformation();
        this.computeTransformation();
    }

    private void copyOriginalImages() {
        this.originalSourceImage = this.sourceSequence.getFirstImage();
        this.originalTargetImage = this.targetSequence.getFirstImage();
    }

    private void createImageBSplineModels() {
        this.sourceBSplineModel = new BSplineModel(this.sourceSequence.getFirstImage(), this.getRegistrationMode() != RegistrationMode.MONO, (int)Math.pow(2.0, this.getInitialSubsampleFactor()));
        this.sourceBSplineModel.setPyramidDepth(this.getPyramidDepth());
        this.targetBSplineModel = new BSplineModel(this.targetSequence.getFirstImage(), true, (int)Math.pow(2.0, this.getInitialSubsampleFactor()));
        this.targetBSplineModel.setPyramidDepth(this.getPyramidDepth());
    }

    private int getPyramidDepth() {
        return this.getFinalDeformationScale().getNumber() - this.getInitialDeformationScale().getNumber();
    }

    private void computePyramids() throws InterruptedException {
        this.sourceBSplineModel.startPyramids();
        this.targetBSplineModel.startPyramids();
        this.sourceBSplineModel.getThread().join();
        this.targetBSplineModel.getThread().join();
    }

    private void initializeProgressOutput() {
        this.initializeSourceProgressOutput();
        this.initializeTargetProgressOutput();
    }

    private void initializeSourceProgressOutput() {
        int Ydimt = this.targetBSplineModel.getHeight();
        int Xdimt = this.targetBSplineModel.getWidth();
        int Xdims = this.sourceBSplineModel.getWidth();
        int Ydims = this.sourceBSplineModel.getHeight();
        double[] tImage = this.targetBSplineModel.isSubOutput() ? this.targetBSplineModel.getSubImage() : this.targetBSplineModel.getImage();
        double[] sImage = this.sourceBSplineModel.isSubOutput() ? this.sourceBSplineModel.getSubImage() : this.sourceBSplineModel.getImage();
        int sSubFactorX = 1;
        int sSubFactorY = 1;
        int tSubFactorX = 1;
        int tSubFactorY = 1;
        String extraTitleS = "";
        if (this.targetBSplineModel.isSubOutput() || this.sourceBSplineModel.isSubOutput()) {
            this.notifyProgress(Double.NaN, "Initializing source -> target window...");
        }
        if (this.targetBSplineModel.isSubOutput()) {
            tSubFactorX = Xdimt / this.targetBSplineModel.getSubWidth();
            tSubFactorY = Ydimt / this.targetBSplineModel.getSubHeight();
            Xdimt = this.targetBSplineModel.getSubWidth();
            Ydimt = this.targetBSplineModel.getSubHeight();
        }
        if (this.sourceBSplineModel.isSubOutput()) {
            sSubFactorX = Xdims / this.sourceBSplineModel.getSubWidth();
            sSubFactorY = Ydims / this.sourceBSplineModel.getSubHeight();
            extraTitleS = " (Subsampled)";
            Xdims = this.sourceBSplineModel.getSubWidth();
            Ydims = this.sourceBSplineModel.getSubHeight();
        }
        IcyBufferedImage fp = new IcyBufferedImage(Xdimt, Ydimt, 1, DataType.DOUBLE);
        IcyBufferedImageCursor fpCursor = new IcyBufferedImageCursor(fp);
        for (int i = 0; i < Ydimt; ++i) {
            int i_offset_t = i * Xdimt;
            int i_offset_s = i * Xdims;
            int i_s_sub = i * sSubFactorY;
            int i_t_sub = i * tSubFactorY;
            for (int j = 0; j < Xdimt; ++j) {
                if (this.sourceMask.contains((double)(j * sSubFactorX), (double)i_s_sub) && this.targetMask.contains((double)(j * tSubFactorX), (double)i_t_sub) && j < Xdims && i < Ydims) {
                    fpCursor.setSafe(j, i, 0, tImage[i_offset_t + j] - sImage[i_offset_s + j]);
                    continue;
                }
                fpCursor.setSafe(j, i, 0, 0.0);
            }
        }
        fp.updateChannelsBounds();
        this.sourceProgressOutput = new Sequence("Output Source-Target" + extraTitleS, fp);
        this.notifySourceProgressOutputAvailable(this.sourceProgressOutput);
    }

    private void notifySourceProgressOutputAvailable(Sequence sourceOutput) {
        this.progressOutputListeners.forEach(l -> l.notifyProgress(0.0, "", sourceOutput));
    }

    private void initializeTargetProgressOutput() {
        int Ydimt = this.targetBSplineModel.getHeight();
        int Xdimt = this.targetBSplineModel.getWidth();
        int Xdims = this.sourceBSplineModel.getWidth();
        int Ydims = this.sourceBSplineModel.getHeight();
        double[] tImage = this.targetBSplineModel.isSubOutput() ? this.targetBSplineModel.getSubImage() : this.targetBSplineModel.getImage();
        double[] sImage = this.sourceBSplineModel.isSubOutput() ? this.sourceBSplineModel.getSubImage() : this.sourceBSplineModel.getImage();
        int sSubFactorX = 1;
        int sSubFactorY = 1;
        int tSubFactorX = 1;
        int tSubFactorY = 1;
        String extraTitleT = "";
        if (this.targetBSplineModel.isSubOutput() || this.sourceBSplineModel.isSubOutput()) {
            this.notifyProgress(Double.NaN, "Initializing target -> source window...");
        }
        if (this.targetBSplineModel.isSubOutput()) {
            tSubFactorX = Xdimt / this.targetBSplineModel.getSubWidth();
            tSubFactorY = Ydimt / this.targetBSplineModel.getSubHeight();
            extraTitleT = " (Subsampled)";
            Xdimt = this.targetBSplineModel.getSubWidth();
            Ydimt = this.targetBSplineModel.getSubHeight();
        }
        if (this.sourceBSplineModel.isSubOutput()) {
            sSubFactorX = Xdims / this.sourceBSplineModel.getSubWidth();
            sSubFactorY = Ydims / this.sourceBSplineModel.getSubHeight();
            Xdims = this.sourceBSplineModel.getSubWidth();
            Ydims = this.sourceBSplineModel.getSubHeight();
        }
        if (this.getRegistrationMode() != RegistrationMode.MONO) {
            IcyBufferedImage fp2 = new IcyBufferedImage(Xdims, Ydims, 1, DataType.DOUBLE);
            IcyBufferedImageCursor fp2Cursor = new IcyBufferedImageCursor(fp2);
            for (int i = 0; i < Ydims; ++i) {
                int i_offset_t = i * Xdimt;
                int i_offset_s = i * Xdims;
                int i_s_sub = i * sSubFactorY;
                int i_t_sub = i * tSubFactorY;
                for (int j = 0; j < Xdims; ++j) {
                    if (this.targetMask.contains((double)(j * tSubFactorX), (double)i_t_sub) && this.sourceMask.contains((double)(j * sSubFactorX), (double)i_s_sub) && i < Ydimt && j < Xdimt) {
                        fp2Cursor.setSafe(j, i, 0, sImage[i_offset_s + j] - tImage[i_offset_t + j]);
                        continue;
                    }
                    fp2Cursor.setSafe(j, i, 0, 0.0);
                }
            }
            fp2Cursor.commitChanges();
            this.targetProgressOutput = new Sequence("Output Target-Source" + extraTitleT, fp2);
            this.notifyTargetProgressOutputAvailable(this.targetProgressOutput);
        }
    }

    private void notifyTargetProgressOutputAvailable(Sequence targetOutput) {
        this.progressOutputListeners.forEach(l -> l.notifyProgress(0.0, "", targetOutput));
    }

    private void adjustConsistencyWeight() {
        if (this.registrationMode == RegistrationMode.MONO) {
            this.setConsistencyWeight(0.0);
        }
    }

    private void createTransformation() {
        this.transformation = new Transformation(this.getSourceSequence(), this.getTargetSequence(), this.sourceBSplineModel, this.targetBSplineModel, this.getSourceLandmarks(), this.getTargetLandmarks(), this.getSourceMask(), this.getTargetMask(), null, null, this.getInitialDeformationScale().getNumber(), this.getFinalDeformationScale().getNumber(), 0, this.getDivWeight(), this.getCurlWeight(), this.getLandmarkWeight(), this.getImageWeight(), this.getConsistencyWeight(), this.getStopThreshold(), this.isShowProcess() ? 2 : 0, this.isShowProcess(), this.getRegistrationMode().getNumber(), "", "", this.sourceProgressOutput, this.targetProgressOutput, this.originalSourceImage, this.originalTargetImage);
        this.transformation.addProgressListener((progress, message, data) -> {
            this.notifyProgress(progress, message);
            return true;
        });
    }

    public Transformation getTransformation() {
        return this.transformation;
    }

    private void computeTransformation() throws InterruptedException {
        this.notifyProgress(Double.NaN, "Registering...");
        long registrationStartTime = System.currentTimeMillis();
        if (this.getRegistrationMode() == RegistrationMode.MONO) {
            this.transformation.doUnidirectionalRegistration();
        } else {
            this.transformation.doBidirectionalRegistration();
        }
        this.restablishOriginalImages();
        if (this.sourceBSplineModel.isSubOutput()) {
            this.notifyProgress(Double.NaN, "Calculating final transformed source image");
        }
        this.directResult = this.transformation.getDirectResults();
        if (this.getRegistrationMode() != RegistrationMode.MONO) {
            if (this.targetBSplineModel.isSubOutput()) {
                this.notifyProgress(Double.NaN, "Calculating final transformed target image");
            }
            this.indirectResult = this.transformation.getInverseResults();
        }
        long registrationEndTime = System.currentTimeMillis();
        System.out.format("Registration time %d milliseconds.\n", registrationEndTime - registrationStartTime);
    }

    private void restablishOriginalImages() {
        this.getSourceSequence().setImage(0, 0, (BufferedImage)this.originalSourceImage);
        this.getTargetSequence().setImage(0, 0, (BufferedImage)this.originalTargetImage);
    }

    public Sequence getTransformedDirectResult() {
        int c;
        BSplineModel xDeformationModel = new BSplineModel(this.getTransformation().getDirectDeformationCoefficientsX());
        BSplineModel yDeformationModel = new BSplineModel(this.getTransformation().getDirectDeformationCoefficientsY());
        BSplineModel[] transformedSourceModel = new BSplineModel[this.getTransformedSourceSequence().getSizeC()];
        for (c = 0; c < transformedSourceModel.length; ++c) {
            transformedSourceModel[c] = new BSplineModel(IcyBufferedImageUtil.extractChannel((IcyBufferedImage)this.getTransformedSourceSequence().getFirstImage(), (int)c), false, 0);
            transformedSourceModel[c].setPyramidDepth(0);
            transformedSourceModel[c].startPyramids();
        }
        try {
            for (c = 0; c < transformedSourceModel.length; ++c) {
                transformedSourceModel[c].getThread().join();
            }
        }
        catch (InterruptedException e) {
            System.out.println("Should never reach this");
            e.printStackTrace();
        }
        IcyBufferedImage transformedSourceImage = new IcyBufferedImage(this.getTransformedTargetSequence().getWidth(), this.getTransformedTargetSequence().getHeight(), this.getTransformedSourceSequence().getSizeC(), this.getTransformedSourceSequence().getDataType_());
        IcyBufferedImageCursor cursor = new IcyBufferedImageCursor(transformedSourceImage);
        double sourceYScaleFactor = (double)(xDeformationModel.getHeight() - 3) / (double)(transformedSourceImage.getHeight() - 1);
        double sourceXScaleFactor = (double)(xDeformationModel.getWidth() - 3) / (double)(transformedSourceImage.getWidth() - 1);
        for (int j = 0; j < transformedSourceImage.getHeight(); ++j) {
            double scaledY = (double)j * sourceYScaleFactor + 1.0;
            for (int i = 0; i < transformedSourceImage.getWidth(); ++i) {
                double scaledX = (double)i * sourceXScaleFactor + 1.0;
                double interpolatedX = xDeformationModel.prepareForInterpolationAndInterpolateI(scaledX, scaledY, false, false);
                double interpolatedY = yDeformationModel.prepareForInterpolationAndInterpolateI(scaledX, scaledY, false, false);
                if (!(interpolatedX >= 0.0) || !(interpolatedX < (double)this.getTransformedSourceSequence().getWidth()) || !(interpolatedY >= 0.0) || !(interpolatedY < (double)this.getTransformedSourceSequence().getHeight())) continue;
                for (int c2 = 0; c2 < transformedSourceModel.length; ++c2) {
                    cursor.setSafe(i, j, c2, transformedSourceModel[c2].prepareForInterpolationAndInterpolateI(interpolatedX, interpolatedY, false, false));
                }
            }
        }
        cursor.commitChanges();
        this.resultTransformedSourceSequence = new Sequence(this.getTransformedSourceSequence().getName() + "_Transformed", transformedSourceImage);
        return this.resultTransformedSourceSequence;
    }

    public Sequence getTransformedIndirectResult() {
        int c;
        BSplineModel xDeformationModel = new BSplineModel(this.getTransformation().getInverseDeformationCoefficientsX());
        BSplineModel yDeformationModel = new BSplineModel(this.getTransformation().getInverseDeformationCoefficientsY());
        BSplineModel[] transformedTargetModel = new BSplineModel[this.getTransformedTargetSequence().getSizeC()];
        for (c = 0; c < transformedTargetModel.length; ++c) {
            transformedTargetModel[c] = new BSplineModel(IcyBufferedImageUtil.extractChannel((IcyBufferedImage)this.getTransformedTargetSequence().getFirstImage(), (int)c), false, 0);
            transformedTargetModel[c].setPyramidDepth(0);
            transformedTargetModel[c].startPyramids();
        }
        try {
            for (c = 0; c < transformedTargetModel.length; ++c) {
                transformedTargetModel[c].getThread().join();
            }
        }
        catch (InterruptedException e) {
            System.out.println("Should never reach this");
            e.printStackTrace();
        }
        IcyBufferedImage transformedTargetImage = new IcyBufferedImage(this.getTransformedSourceSequence().getWidth(), this.getTransformedSourceSequence().getHeight(), this.getTransformedTargetSequence().getSizeC(), this.getTransformedTargetSequence().getDataType_());
        IcyBufferedImageCursor cursor = new IcyBufferedImageCursor(transformedTargetImage);
        double targetYScaleFactor = (double)(xDeformationModel.getHeight() - 3) / (double)(transformedTargetImage.getHeight() - 1);
        double targetXScaleFactor = (double)(xDeformationModel.getWidth() - 3) / (double)(transformedTargetImage.getWidth() - 1);
        for (int j = 0; j < transformedTargetImage.getHeight(); ++j) {
            double scaledY = (double)j * targetYScaleFactor + 1.0;
            for (int i = 0; i < transformedTargetImage.getWidth(); ++i) {
                double scaledX = (double)i * targetXScaleFactor + 1.0;
                double interpolatedX = xDeformationModel.prepareForInterpolationAndInterpolateI(scaledX, scaledY, false, false);
                double interpolatedY = yDeformationModel.prepareForInterpolationAndInterpolateI(scaledX, scaledY, false, false);
                if (!(interpolatedX >= 0.0) || !(interpolatedX < (double)this.getTransformedTargetSequence().getWidth()) || !(interpolatedY >= 0.0) || !(interpolatedY < (double)this.getTransformedTargetSequence().getHeight())) continue;
                for (int c2 = 0; c2 < transformedTargetModel.length; ++c2) {
                    cursor.setSafe(i, j, c2, transformedTargetModel[c2].prepareForInterpolationAndInterpolateI(interpolatedX, interpolatedY, false, false));
                }
            }
        }
        cursor.commitChanges();
        this.resultTransformedTargetSequence = new Sequence(this.getTransformedTargetSequence().getName() + "_Transformed", transformedTargetImage);
        return this.resultTransformedTargetSequence;
    }
}

