/*
 * Decompiled with CFR 0.152.
 */
package danyfel80.registration.bspline.classic;

public class MathTools {
    private static final double FLT_EPSILON = Float.intBitsToFloat(0x33FFFFFF);
    private static final int MAX_SVD_ITERATIONS = 1000;

    public static double Bspline01(double x) {
        if ((x = Math.abs(x)) < 1.0) {
            return 1.0 - x;
        }
        return 0.0;
    }

    public static double Bspline02(double x) {
        if ((x = Math.abs(x)) < 0.5) {
            return 0.75 - x * x;
        }
        if (x < 1.5) {
            return 0.5 * (x -= 1.5) * x;
        }
        return 0.0;
    }

    public static double Bspline03(double x) {
        if ((x = Math.abs(x)) < 1.0) {
            return 0.5 * x * x * (x - 2.0) + 0.6666666865348816;
        }
        if (x < 2.0) {
            return (x -= 2.0) * x * x / -6.0;
        }
        return 0.0;
    }

    public static double EuclideanNorm(double a, double b) {
        double absa = Math.abs(a);
        double absb = Math.abs(b);
        if (absb < absa) {
            return absa * Math.sqrt(1.0 + absb * absb / (absa * absa));
        }
        return absb == 0.0 ? 0.0 : absb * Math.sqrt(1.0 + absa * absa / (absb * absb));
    }

    public static boolean invertMatrixSVD(int Ydim, int Xdim, double[][] B, double[][] iB) {
        int j;
        int i;
        boolean underconstrained = false;
        double[] W = new double[Xdim];
        double[][] V = new double[Xdim][Xdim];
        MathTools.singularValueDecomposition(B, W, V);
        int Nzeros = 0;
        for (int k = 0; k < Xdim; ++k) {
            if (Math.abs(W[k]) < FLT_EPSILON) {
                W[k] = 0.0;
                ++Nzeros;
                continue;
            }
            W[k] = 1.0 / W[k];
        }
        if (Ydim - Nzeros < Xdim) {
            underconstrained = true;
        }
        for (i = 0; i < Xdim; ++i) {
            for (j = 0; j < Xdim; ++j) {
                double[] dArray = V[i];
                int n = j;
                dArray[n] = dArray[n] * W[j];
            }
        }
        for (i = 0; i < Xdim; ++i) {
            for (j = 0; j < Ydim; ++j) {
                iB[i][j] = 0.0;
                for (int k = 0; k < Xdim; ++k) {
                    double[] dArray = iB[i];
                    int n = j;
                    dArray[n] = dArray[n] + V[i][k] * B[j][k];
                }
            }
        }
        return underconstrained;
    }

    public static double[] linearLeastSquares(double[][] A, double[] b) {
        double s;
        int j;
        int i;
        if (A == null || A.length == 0) {
            return null;
        }
        int lines = A.length;
        int columns = A[0].length;
        double[][] Q = new double[lines][columns];
        double[][] R = new double[columns][columns];
        double[] x = new double[columns];
        for (i = 0; i < lines; ++i) {
            for (j = 0; j < columns; ++j) {
                Q[i][j] = A[i][j];
            }
        }
        MathTools.QRdecomposition(Q, R);
        for (i = 0; i < columns; ++i) {
            s = 0.0;
            for (j = 0; j < lines; ++j) {
                s += Q[j][i] * b[j];
            }
            x[i] = s;
        }
        for (i = columns - 1; 0 <= i; --i) {
            s = R[i][i];
            if (s * s == 0.0) {
                x[i] = 0.0;
            } else {
                int n = i;
                x[n] = x[n] / s;
            }
            for (j = i - 1; 0 <= j; --j) {
                int n = j;
                x[n] = x[n] - R[j][i] * x[i];
            }
        }
        return x;
    }

    public static double nchoosek(int n, int k) {
        if (k > n) {
            return 0.0;
        }
        if (k == 0) {
            return 1.0;
        }
        if (k == 1) {
            return n;
        }
        if (k > n / 2) {
            k = n - k;
        }
        double prod = 1.0;
        for (int i = 1; i <= k; ++i) {
            prod *= (double)((n - k + i) / i);
        }
        return prod;
    }

    public static void QRdecomposition(double[][] Q, double[][] R) {
        int lines = Q.length;
        int columns = Q[0].length;
        double[][] A = new double[lines][columns];
        for (int j = 0; j < columns; ++j) {
            double s;
            int i;
            for (i = 0; i < lines; ++i) {
                A[i][j] = Q[i][j];
            }
            for (int k = 0; k < j; ++k) {
                int i2;
                s = 0.0;
                for (i2 = 0; i2 < lines; ++i2) {
                    s += A[i2][j] * Q[i2][k];
                }
                for (i2 = 0; i2 < lines; ++i2) {
                    double[] dArray = Q[i2];
                    int n = j;
                    dArray[n] = dArray[n] - s * Q[i2][k];
                }
            }
            s = 0.0;
            for (i = 0; i < lines; ++i) {
                s += Q[i][j] * Q[i][j];
            }
            s = s * s == 0.0 ? 0.0 : 1.0 / Math.sqrt(s);
            for (i = 0; i < lines; ++i) {
                double[] dArray = Q[i];
                int n = j;
                dArray[n] = dArray[n] * s;
            }
        }
        for (int i = 0; i < columns; ++i) {
            int j;
            for (j = 0; j < i; ++j) {
                R[i][j] = 0.0;
            }
            for (j = i; j < columns; ++j) {
                R[i][j] = 0.0;
                for (int k = 0; k < lines; ++k) {
                    double[] dArray = R[i];
                    int n = j;
                    dArray[n] = dArray[n] + Q[k][i] * A[k][j];
                }
            }
        }
    }

    public static void showMatrix(int Ydim, int Xdim, double[][] A) {
        for (int i = 0; i < Ydim; ++i) {
            for (int j = 0; j < Xdim; ++j) {
                System.out.print(A[i][j] + " ");
            }
            System.out.println();
        }
    }

    public static void singularValueDecomposition(double[][] U, double[] W, double[][] V) {
        int k;
        int j;
        double h;
        double f;
        double s;
        int i;
        int lines = U.length;
        int columns = U[0].length;
        double[] rv1 = new double[columns];
        int l = 0;
        int nm = 0;
        double norm = 0.0;
        double scale = 0.0;
        double g = 0.0;
        for (i = 0; i < columns; ++i) {
            int k2;
            l = i + 1;
            rv1[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i < lines) {
                for (k2 = i; k2 < lines; ++k2) {
                    scale += Math.abs(U[k2][i]);
                }
                if (scale != 0.0) {
                    for (k2 = i; k2 < lines; ++k2) {
                        double[] dArray = U[k2];
                        int n = i;
                        dArray[n] = dArray[n] / scale;
                        s += U[k2][i] * U[k2][i];
                    }
                    f = U[i][i];
                    g = 0.0 <= f ? -Math.sqrt(s) : Math.sqrt(s);
                    h = f * g - s;
                    U[i][i] = f - g;
                    for (j = l; j < columns; ++j) {
                        s = 0.0;
                        for (k = i; k < lines; ++k) {
                            s += U[k][i] * U[k][j];
                        }
                        f = s / h;
                        for (k = i; k < lines; ++k) {
                            double[] dArray = U[k];
                            int n = j;
                            dArray[n] = dArray[n] + f * U[k][i];
                        }
                    }
                    for (k2 = i; k2 < lines; ++k2) {
                        double[] dArray = U[k2];
                        int n = i;
                        dArray[n] = dArray[n] * scale;
                    }
                }
            }
            W[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i < lines && i != columns - 1) {
                for (k2 = l; k2 < columns; ++k2) {
                    scale += Math.abs(U[i][k2]);
                }
                if (scale != 0.0) {
                    for (k2 = l; k2 < columns; ++k2) {
                        double[] dArray = U[i];
                        int n = k2;
                        dArray[n] = dArray[n] / scale;
                        s += U[i][k2] * U[i][k2];
                    }
                    f = U[i][l];
                    g = 0.0 <= f ? -Math.sqrt(s) : Math.sqrt(s);
                    h = f * g - s;
                    U[i][l] = f - g;
                    for (k2 = l; k2 < columns; ++k2) {
                        rv1[k2] = U[i][k2] / h;
                    }
                    for (j = l; j < lines; ++j) {
                        s = 0.0;
                        for (k = l; k < columns; ++k) {
                            s += U[j][k] * U[i][k];
                        }
                        for (k = l; k < columns; ++k) {
                            double[] dArray = U[j];
                            int n = k;
                            dArray[n] = dArray[n] + s * rv1[k];
                        }
                    }
                    k2 = l;
                    while (k2 < columns) {
                        double[] dArray = U[i];
                        int n = k2++;
                        dArray[n] = dArray[n] * scale;
                    }
                }
            }
            norm = Math.abs(W[i]) + Math.abs(rv1[i]) < norm ? norm : Math.abs(W[i]) + Math.abs(rv1[i]);
        }
        i = columns - 1;
        while (0 <= i) {
            if (i < columns - 1) {
                if (g != 0.0) {
                    for (j = l; j < columns; ++j) {
                        V[j][i] = U[i][j] / (U[i][l] * g);
                    }
                    for (j = l; j < columns; ++j) {
                        s = 0.0;
                        for (k = l; k < columns; ++k) {
                            s += U[i][k] * V[k][j];
                        }
                        for (k = l; k < columns; ++k) {
                            if (s == 0.0) continue;
                            double[] dArray = V[k];
                            int n = j;
                            dArray[n] = dArray[n] + s * V[k][i];
                        }
                    }
                }
                for (j = l; j < columns; ++j) {
                    V[j][i] = 0.0;
                    V[i][j] = 0.0;
                }
            }
            V[i][i] = 1.0;
            g = rv1[i];
            l = i--;
        }
        int n = i = lines < columns ? lines - 1 : columns - 1;
        while (0 <= i) {
            l = i + 1;
            g = W[i];
            for (j = l; j < columns; ++j) {
                U[i][j] = 0.0;
            }
            if (g != 0.0) {
                g = 1.0 / g;
                for (j = l; j < columns; ++j) {
                    s = 0.0;
                    for (k = l; k < lines; ++k) {
                        s += U[k][i] * U[k][j];
                    }
                    f = s * g / U[i][i];
                    for (k = i; k < lines; ++k) {
                        if (f == 0.0) continue;
                        double[] dArray = U[k];
                        int n2 = j;
                        dArray[n2] = dArray[n2] + f * U[k][i];
                    }
                }
                for (j = i; j < lines; ++j) {
                    double[] dArray = U[j];
                    int n3 = i;
                    dArray[n3] = dArray[n3] * g;
                }
            } else {
                for (j = i; j < lines; ++j) {
                    U[j][i] = 0.0;
                }
            }
            double[] dArray = U[i];
            int n4 = i--;
            dArray[n4] = dArray[n4] + 1.0;
        }
        block27: for (int k3 = columns - 1; 0 <= k3; --k3) {
            for (int its = 1; its <= 1000; ++its) {
                int j2;
                double z;
                double y;
                double c;
                boolean flag = true;
                for (l = k3; 0 <= l; --l) {
                    nm = l - 1;
                    if (Math.abs(rv1[l]) + norm == norm) {
                        flag = false;
                        break;
                    }
                    if (Math.abs(W[nm]) + norm == norm) break;
                }
                if (flag) {
                    c = 0.0;
                    s = 1.0;
                    for (int i2 = l; i2 <= k3; ++i2) {
                        f = s * rv1[i2];
                        int n5 = i2;
                        rv1[n5] = rv1[n5] * c;
                        if (Math.abs(f) + norm == norm) break;
                        g = W[i2];
                        W[i2] = h = MathTools.EuclideanNorm(f, g);
                        h = 1.0 / h;
                        c = g * h;
                        s = -f * h;
                        for (int j3 = 0; j3 < lines; ++j3) {
                            y = U[j3][nm];
                            z = U[j3][i2];
                            U[j3][nm] = y * c + z * s;
                            U[j3][i2] = z * c - y * s;
                        }
                    }
                }
                z = W[k3];
                if (l == k3) {
                    if (!(z < 0.0)) continue block27;
                    W[k3] = -z;
                    for (j2 = 0; j2 < columns; ++j2) {
                        V[j2][k3] = -V[j2][k3];
                    }
                    continue block27;
                }
                if (its == 1000) {
                    return;
                }
                double x = W[l];
                nm = k3 - 1;
                y = W[nm];
                g = rv1[nm];
                h = rv1[k3];
                f = ((y - z) * (y + z) + (g - h) * (g + h)) / (2.0 * h * y);
                g = MathTools.EuclideanNorm(f, 1.0);
                f = ((x - z) * (x + z) + h * (y / (f + (0.0 <= f ? Math.abs(g) : -Math.abs(g))) - h)) / x;
                s = 1.0;
                c = 1.0;
                for (j2 = l; j2 <= nm; ++j2) {
                    int jj;
                    int i3 = j2 + 1;
                    g = rv1[i3];
                    y = W[i3];
                    h = s * g;
                    g = c * g;
                    rv1[j2] = z = MathTools.EuclideanNorm(f, h);
                    c = f / z;
                    s = h / z;
                    f = x * c + g * s;
                    g = g * c - x * s;
                    h = y * s;
                    y *= c;
                    for (jj = 0; jj < columns; ++jj) {
                        x = V[jj][j2];
                        z = V[jj][i3];
                        V[jj][j2] = x * c + z * s;
                        V[jj][i3] = z * c - x * s;
                    }
                    W[j2] = z = MathTools.EuclideanNorm(f, h);
                    if (z != 0.0) {
                        z = 1.0 / z;
                        c = f * z;
                        s = h * z;
                    }
                    f = c * g + s * y;
                    x = c * y - s * g;
                    for (jj = 0; jj < lines; ++jj) {
                        y = U[jj][j2];
                        z = U[jj][i3];
                        U[jj][j2] = y * c + z * s;
                        U[jj][i3] = z * c - y * s;
                    }
                }
                rv1[l] = 0.0;
                rv1[k3] = f;
                W[k3] = x;
            }
        }
    }

    public static void singularValueBackSubstitution(double[][] U, double[] W, double[][] V, double[] B, double[] X) {
        int j;
        int i;
        int Lines = U.length;
        int Columns = U[0].length;
        double[] aux = new double[Columns];
        for (i = 0; i < Columns; ++i) {
            aux[i] = 0.0;
            if (!(Math.abs(W[i]) > FLT_EPSILON)) continue;
            for (j = 0; j < Lines; ++j) {
                int n = i;
                aux[n] = aux[n] + U[j][i] * B[j];
            }
            int n = i;
            aux[n] = aux[n] / W[i];
        }
        for (i = 0; i < Columns; ++i) {
            X[i] = 0.0;
            for (j = 0; j < Columns; ++j) {
                int n = i;
                X[n] = X[n] + V[i][j] * aux[j];
            }
        }
    }

    public static double[][] antiSymmetricPadding(double[][] c, int extra) {
        int j;
        int i;
        int oldK = c[0].length;
        int K = 2 * extra + oldK;
        double[][] newc = new double[K][K];
        for (i = 0; i < oldK; ++i) {
            for (j = 0; j < oldK; ++j) {
                newc[i + extra][j + extra] = c[i][j];
            }
        }
        for (i = 0; i < K; ++i) {
            for (j = 0; j < K; ++j) {
                int iFrom = i;
                int jFrom = j;
                int iPivot = -1;
                int jPivot = -1;
                if (iFrom < extra) {
                    iFrom = 2 * extra - i;
                    iPivot = extra;
                    jPivot = j;
                } else if (iFrom > K - extra - 1) {
                    iFrom = 2 * (K - extra - 1) - i;
                    iPivot = K - extra - 1;
                    jPivot = j;
                }
                if (jFrom < extra) {
                    jFrom = 2 * extra - j;
                    jPivot = extra;
                    iPivot = iPivot != -1 ? iPivot : i;
                } else if (jFrom > K - extra - 1) {
                    jFrom = 2 * (K - extra - 1) - j;
                    jPivot = K - extra - 1;
                    int n = iPivot = iPivot != -1 ? iPivot : i;
                }
                if (iPivot == -1 || jPivot == -1) continue;
                newc[i][j] = 2.0 * newc[iPivot][jPivot] - newc[iFrom][jFrom];
            }
        }
        return newc;
    }

    public static double[] antiSymmetricPadding(double[] c, int n, int extra) {
        int j;
        int i;
        int oldK = n;
        int K = 2 * extra + oldK;
        double[] newc = new double[K * K];
        for (i = 0; i < oldK; ++i) {
            for (j = 0; j < oldK; ++j) {
                newc[(i + extra) * K + j + extra] = c[i * n + j];
            }
        }
        for (i = 0; i < K; ++i) {
            for (j = 0; j < K; ++j) {
                int iFrom = i;
                int jFrom = j;
                int iPivot = -1;
                int jPivot = -1;
                if (iFrom < extra) {
                    iFrom = 2 * extra - i;
                    iPivot = extra;
                    jPivot = j;
                } else if (iFrom > K - extra - 1) {
                    iFrom = 2 * (K - extra - 1) - i;
                    iPivot = K - extra - 1;
                    jPivot = j;
                }
                if (jFrom < extra) {
                    jFrom = 2 * extra - j;
                    jPivot = extra;
                    iPivot = iPivot != -1 ? iPivot : i;
                } else if (jFrom > K - extra - 1) {
                    jFrom = 2 * (K - extra - 1) - j;
                    jPivot = K - extra - 1;
                    int n2 = iPivot = iPivot != -1 ? iPivot : i;
                }
                if (iPivot == -1 || jPivot == -1) continue;
                newc[i * K + j] = 2.0 * newc[iPivot * K + jPivot] - newc[iFrom * K + jFrom];
            }
        }
        return newc;
    }

    public static float[] antiSymmetricPadding(float[] c, int n, int extra) {
        int j;
        int i;
        int oldK = n;
        int K = 2 * extra + oldK;
        System.out.println("K = " + K + " oldK = " + oldK);
        float[] newc = new float[K * K];
        for (i = 0; i < oldK; ++i) {
            for (j = 0; j < oldK; ++j) {
                newc[(i + extra) * K + j + extra] = c[i * n + j];
            }
        }
        for (i = 0; i < K; ++i) {
            for (j = 0; j < K; ++j) {
                int iFrom = i;
                int jFrom = j;
                int iPivot = -1;
                int jPivot = -1;
                if (iFrom < extra) {
                    iFrom = 2 * extra - i;
                    iPivot = extra;
                    jPivot = j;
                } else if (iFrom > K - extra - 1) {
                    iFrom = 2 * (K - extra - 1) - i;
                    iPivot = K - extra - 1;
                    jPivot = j;
                }
                if (jFrom < extra) {
                    jFrom = 2 * extra - j;
                    jPivot = extra;
                    iPivot = iPivot != -1 ? iPivot : i;
                } else if (jFrom > K - extra - 1) {
                    jFrom = 2 * (K - extra - 1) - j;
                    jPivot = K - extra - 1;
                    int n2 = iPivot = iPivot != -1 ? iPivot : i;
                }
                if (iPivot == -1 || jPivot == -1) continue;
                newc[i * K + j] = 2.0f * newc[iPivot * K + jPivot] - newc[iFrom * K + jFrom];
            }
        }
        return newc;
    }
}

