/*
 * Decompiled with CFR 0.152.
 */
package danyfel80.registration.bspline.classic;

import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageCursor;
import icy.image.IcyBufferedImageUtil;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.type.DataType;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;

public class MiscTools {
    public static final IcyBufferedImage scale(IcyBufferedImage source, double scale) {
        if (scale == 1.0) {
            return IcyBufferedImageUtil.getCopy((IcyBufferedImage)source);
        }
        if (scale < 1.0) {
            return IcyBufferedImageUtil.scale((IcyBufferedImage)source, (int)((int)((double)source.getWidth() * scale)), (int)((int)((double)source.getHeight() * scale)), (IcyBufferedImageUtil.FilterType)IcyBufferedImageUtil.FilterType.BILINEAR);
        }
        return IcyBufferedImageUtil.scale((IcyBufferedImage)source, (int)((int)Math.round((double)source.getWidth() * scale)), (int)((int)Math.round((double)source.getHeight() * scale)), (IcyBufferedImageUtil.FilterType)IcyBufferedImageUtil.FilterType.BILINEAR);
    }

    public static void drawArrow(double[][] canvas, int x1, int y1, int x2, int y2, double color, int arrow_size) {
        MiscTools.drawLine(canvas, x1, y1, x2, y2, color);
        int arrow_size2 = 2 * arrow_size;
        if ((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1) < arrow_size * arrow_size) {
            return;
        }
        if (x2 == x1) {
            if (y2 > y1) {
                MiscTools.drawLine(canvas, x2, y2, x2 - arrow_size, y2 - arrow_size2, color);
                MiscTools.drawLine(canvas, x2, y2, x2 + arrow_size, y2 - arrow_size2, color);
            } else {
                MiscTools.drawLine(canvas, x2, y2, x2 - arrow_size, y2 + arrow_size2, color);
                MiscTools.drawLine(canvas, x2, y2, x2 + arrow_size, y2 + arrow_size2, color);
            }
        } else if (y2 == y1) {
            if (x2 > x1) {
                MiscTools.drawLine(canvas, x2, y2, x2 - arrow_size2, y2 - arrow_size, color);
                MiscTools.drawLine(canvas, x2, y2, x2 - arrow_size2, y2 + arrow_size, color);
            } else {
                MiscTools.drawLine(canvas, x2, y2, x2 + arrow_size2, y2 - arrow_size, color);
                MiscTools.drawLine(canvas, x2, y2, x2 + arrow_size2, y2 + arrow_size, color);
            }
        } else {
            double t1 = Math.abs(new Integer(y2 - y1).doubleValue());
            double t2 = Math.abs(new Integer(x2 - x1).doubleValue());
            double theta = Math.atan(t1 / t2);
            if (x2 < x1) {
                theta = y2 < y1 ? Math.PI + theta : -(Math.PI + theta);
            } else if (x2 > x1 && y2 < y1) {
                theta = Math.PI * 2 - theta;
            }
            double cosTheta = Math.cos(theta);
            double sinTheta = Math.sin(theta);
            Point p2 = new Point(-arrow_size2, -arrow_size);
            Point p3 = new Point(-arrow_size2, arrow_size);
            int x = new Long(Math.round(cosTheta * (double)p2.x - sinTheta * (double)p2.y)).intValue();
            p2.y = new Long(Math.round(sinTheta * (double)p2.x + cosTheta * (double)p2.y)).intValue();
            p2.x = x;
            x = new Long(Math.round(cosTheta * (double)p3.x - sinTheta * (double)p3.y)).intValue();
            p3.y = new Long(Math.round(sinTheta * (double)p3.x + cosTheta * (double)p3.y)).intValue();
            p3.x = x;
            p2.translate(x2, y2);
            p3.translate(x2, y2);
            MiscTools.drawLine(canvas, x2, y2, p2.x, p2.y, color);
            MiscTools.drawLine(canvas, x2, y2, p3.x, p3.y, color);
        }
    }

    public static void drawLine(double[][] canvas, int x1, int y1, int x2, int y2, double color) {
        int temp;
        int dy_neg = 1;
        int dx_neg = 1;
        boolean switch_x_y = false;
        boolean neg_slope = false;
        int dx = x2 - x1;
        if (dx == 0) {
            if (y1 > y2) {
                for (int n = y2; n <= y1; ++n) {
                    MiscTools.Point(canvas, n, x1, color);
                }
                return;
            }
            for (int n = y1; n <= y2; ++n) {
                MiscTools.Point(canvas, n, x1, color);
            }
            return;
        }
        int dy = y2 - y1;
        if (dy == 0) {
            if (x1 > x2) {
                for (int n = x2; n <= x1; ++n) {
                    MiscTools.Point(canvas, y1, n, color);
                }
                return;
            }
            for (int n = x1; n <= x2; ++n) {
                MiscTools.Point(canvas, y1, n, color);
            }
            return;
        }
        double m = (double)dy / (double)dx;
        if (m > 1.0 || m < -1.0) {
            temp = x1;
            x1 = y1;
            y1 = temp;
            temp = x2;
            x2 = y2;
            y2 = temp;
            dx = x2 - x1;
            dy = y2 - y1;
            m = (double)dy / (double)dx;
            switch_x_y = true;
        }
        if (x1 > x2) {
            temp = x1;
            x1 = x2;
            x2 = temp;
            temp = y1;
            y1 = y2;
            y2 = temp;
            dx = x2 - x1;
            dy = y2 - y1;
            m = (double)dy / (double)dx;
        }
        if (m < 0.0) {
            if (dy < 0) {
                dy_neg = -1;
                dx_neg = 1;
            } else {
                dy_neg = 1;
                dx_neg = -1;
            }
            neg_slope = true;
        }
        int d = 2 * (dy * dy_neg) - dx * dx_neg;
        int incrH = 2 * dy * dy_neg;
        int incrHV = 2 * (dy * dy_neg - dx * dx_neg);
        int x = x1;
        int y = y1;
        int tempx = x;
        int tempy = y;
        if (switch_x_y) {
            temp = x;
            x = y;
            y = temp;
        }
        MiscTools.Point(canvas, y, x, color);
        x = tempx;
        y = tempy;
        while (x < x2) {
            if (d <= 0) {
                d += incrH;
            } else {
                d += incrHV;
                ++x;
                if (neg_slope) {
                    --y;
                }
            }
            tempx = ++x;
            tempy = ++y;
            if (switch_x_y) {
                temp = x;
                x = y;
                y = temp;
            }
            MiscTools.Point(canvas, y, x, color);
            x = tempx;
            y = tempy;
        }
    }

    public static void extractImage(IcyBufferedImage ip, double[] image) {
        if (ip.getSizeC() == 1) {
            IcyBufferedImage doubleImage = IcyBufferedImageUtil.convertToType((IcyBufferedImage)ip, (DataType)DataType.DOUBLE, (boolean)false);
            System.arraycopy(doubleImage.getDataXYAsDouble(0), 0, image, 0, image.length);
        } else {
            IcyBufferedImageCursor cursor = new IcyBufferedImageCursor(ip);
            for (int y = 0; y < ip.getHeight(); ++y) {
                int yAccum = y * ip.getWidth();
                for (int x = 0; x < ip.getWidth(); ++x) {
                    double averageIntensity = 0.0;
                    for (int c = 0; c < ip.getSizeC(); ++c) {
                        averageIntensity += cursor.get(x, y, c);
                    }
                    image[yAccum + x] = averageIntensity /= (double)ip.getSizeC();
                }
            }
        }
    }

    public static void loadTransformation(String filename, double[][] cx, double[][] cy) {
        try {
            int j;
            int i;
            FileReader fr = new FileReader(filename);
            BufferedReader br = new BufferedReader(fr);
            String line = br.readLine();
            int lineN = 1;
            StringTokenizer st = new StringTokenizer(line, "=");
            if (st.countTokens() != 2) {
                br.close();
                fr.close();
                System.out.println("Line " + lineN + "+: Cannot read number of intervals");
                return;
            }
            st.nextToken();
            int intervals = Integer.valueOf(st.nextToken());
            line = br.readLine();
            line = br.readLine();
            lineN += 2;
            for (i = 0; i < intervals + 3; ++i) {
                line = br.readLine();
                ++lineN;
                st = new StringTokenizer(line);
                if (st.countTokens() != intervals + 3) {
                    br.close();
                    fr.close();
                    System.out.println("Line " + lineN + ": Cannot read enough coefficients");
                    return;
                }
                for (j = 0; j < intervals + 3; ++j) {
                    cx[i][j] = Double.valueOf(st.nextToken());
                }
            }
            line = br.readLine();
            line = br.readLine();
            lineN += 2;
            for (i = 0; i < intervals + 3; ++i) {
                line = br.readLine();
                ++lineN;
                st = new StringTokenizer(line);
                if (st.countTokens() != intervals + 3) {
                    br.close();
                    fr.close();
                    System.out.println("Line " + lineN + ": Cannot read enough coefficients");
                    return;
                }
                for (j = 0; j < intervals + 3; ++j) {
                    cy[i][j] = Double.valueOf(st.nextToken());
                }
            }
            fr.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.err.println("File not found exception" + e);
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("IOException exception" + e);
            return;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            System.err.println("Number format exception" + e);
            return;
        }
    }

    public static void saveElasticTransformation(int intervals, double[][] cx, double[][] cy, String filename) {
        try {
            String aux;
            int j;
            int i;
            FileWriter fw = new FileWriter(filename);
            fw.write("Intervals=" + intervals + "\n\n");
            fw.write("X Coeffs -----------------------------------\n");
            for (i = 0; i < intervals + 3; ++i) {
                for (j = 0; j < intervals + 3; ++j) {
                    aux = "" + cx[i][j];
                    while (aux.length() < 21) {
                        aux = " " + aux;
                    }
                    fw.write(aux + " ");
                }
                fw.write("\n");
            }
            fw.write("\n");
            fw.write("Y Coeffs -----------------------------------\n");
            for (i = 0; i < intervals + 3; ++i) {
                for (j = 0; j < intervals + 3; ++j) {
                    aux = "" + cy[i][j];
                    while (aux.length() < 21) {
                        aux = " " + aux;
                    }
                    fw.write(aux + " ");
                }
                fw.write("\n");
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("IOException exception" + e);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            System.err.println("Security exception" + e);
        }
    }

    public static void Point(double[][] canvas, int y, int x, double color) {
        if (y < 0 || y >= canvas.length) {
            return;
        }
        if (x < 0 || x >= canvas[0].length) {
            return;
        }
        canvas[y][x] = color;
    }

    public static void showImage(String title, double[][] array) {
        int Ydim = array.length;
        int Xdim = array[0].length;
        IcyBufferedImage fp = new IcyBufferedImage(Xdim, Ydim, 1, DataType.DOUBLE);
        IcyBufferedImageCursor fpCursor = new IcyBufferedImageCursor(fp);
        for (int i = 0; i < Ydim; ++i) {
            for (int j = 0; j < Xdim; ++j) {
                fpCursor.setSafe(j, i, 0, array[i][j]);
            }
        }
        fpCursor.commitChanges();
        Sequence ip = new Sequence(title, fp);
        Icy.getMainInterface().addSequence(ip);
    }
}

