/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.registration.elastic;

import danyfel80.registration.bspline.big.BUnwarpRegistrationBig;
import danyfel80.registration.bspline.big.BUnwarpRegistrationBigException;
import danyfel80.registration.bspline.classic.DeformationScale;
import danyfel80.registration.bspline.classic.RegistrationMode;
import icy.gui.main.MainInterfaceBatch;
import icy.main.Icy;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.system.IcyHandledException;
import java.io.File;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarEnum;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.kernel.roi.roi2d.ROI2DPoint;

public class BigBUnwarp
extends EzPlug
implements EzStoppable,
Block {
    private EzVarFile varSourceFile;
    private EzVarFile varTargetFile;
    private VarROIArray varSourceLandmarks;
    private VarROIArray varTargetLandmarks;
    private EzVarEnum<RegistrationMode> varRegistrationMode;
    private EzVarInteger varInitialSubsampleFactor;
    private EzVarFile varTransformedSourceFile;
    private EzVarFile varTransformedTargetFile;
    private EzVarEnum<DeformationScale> varInitialDeformationScale;
    private EzVarEnum<DeformationScale> varFinalDeformationScale;
    private EzVarDouble varDivWeight;
    private EzVarDouble varCurlWeight;
    private EzVarDouble varLandmarkWeight;
    private EzVarDouble varImageWeight;
    private EzVarDouble varConsistencyWeight;
    private EzVarDouble varStopThreshold;
    private EzVarBoolean varShowProcess;
    private EzGroup advancedParamsGroup;
    private BUnwarpRegistrationBig registration;
    private List<Sequence> progressSequences;
    private EzVarFile varResultSourceFile;
    private EzVarFile varResultTargetFile;
    private VarBoolean varEndSignalVar;

    protected void initialize() {
        this.initializeInputVariables();
        this.initializeInputListeners();
        this.initializeDefaultInputValues();
        this.initializeVariableGroups();
        this.addInputComponents();
    }

    private void initializeInputVariables() {
        this.varSourceFile = new EzVarFile("Source image file", null);
        this.varTargetFile = new EzVarFile("Target image file", null);
        this.varSourceLandmarks = new VarROIArray("Source image landmarks");
        this.varTargetLandmarks = new VarROIArray("Target image landmarks");
        this.varRegistrationMode = new EzVarEnum("Registration mode", (Enum[])RegistrationMode.values());
        this.varInitialSubsampleFactor = new EzVarInteger("Starting image subsampling factor", 0, 0, 7, 1);
        this.varTransformedSourceFile = new EzVarFile("Transformed source image file", null);
        this.varTransformedTargetFile = new EzVarFile("Transformed target image file", null);
        this.varInitialDeformationScale = new EzVarEnum("Initial deformation size", (Enum[])Arrays.stream(DeformationScale.values()).limit(DeformationScale.values().length - 1).toArray(DeformationScale[]::new));
        this.varFinalDeformationScale = new EzVarEnum("Final deformation size", (Enum[])DeformationScale.values());
        this.varDivWeight = new EzVarDouble("Divergence weight");
        this.varCurlWeight = new EzVarDouble("Curl weight");
        this.varLandmarkWeight = new EzVarDouble("Landmark weight");
        this.varImageWeight = new EzVarDouble("Image weight");
        this.varConsistencyWeight = new EzVarDouble("Consistency weight");
        this.varStopThreshold = new EzVarDouble("Stop threshold");
        this.varShowProcess = new EzVarBoolean("Show process", false);
        this.varResultSourceFile = new EzVarFile("Result source image file", null);
        this.varResultTargetFile = new EzVarFile("Result target image file", null);
    }

    private void initializeInputListeners() {
        this.varRegistrationMode.addVarChangeListener((sourceVar, newMode) -> this.varConsistencyWeight.setEnabled(newMode != RegistrationMode.MONO));
        this.varSourceFile.addVarChangeListener((sourceVar, newFile) -> this.varTransformedSourceFile.setValue(newFile));
        this.varTargetFile.addVarChangeListener((sourceVar, newFile) -> this.varTransformedTargetFile.setValue(newFile));
    }

    private void initializeDefaultInputValues() {
        this.varRegistrationMode.setValue((Object)RegistrationMode.MONO);
        this.varInitialSubsampleFactor.setValue((Object)0);
        this.varInitialDeformationScale.setValue((Object)DeformationScale.VERY_COARSE);
        this.varFinalDeformationScale.setValue((Object)DeformationScale.FINE);
        this.varDivWeight.setValue((Object)0.0);
        this.varCurlWeight.setValue((Object)0.0);
        this.varLandmarkWeight.setValue((Object)0.0);
        this.varImageWeight.setValue((Object)1.0);
        this.varConsistencyWeight.setValue((Object)10.0);
        this.varStopThreshold.setValue((Object)0.01);
        this.varShowProcess.setValue((Object)false);
    }

    private void initializeVariableGroups() {
        EzGroup transformedSequenceGroup = new EzGroup("Images to be transformed", new EzComponent[]{this.varTransformedSourceFile, this.varTransformedTargetFile});
        EzGroup weightsGroup = new EzGroup("Weights", new EzComponent[]{this.varDivWeight, this.varCurlWeight, this.varLandmarkWeight, this.varImageWeight, this.varConsistencyWeight});
        this.advancedParamsGroup = new EzGroup("Advanced Parameters", new EzComponent[]{this.varInitialDeformationScale, this.varFinalDeformationScale, transformedSequenceGroup, weightsGroup, this.varStopThreshold, this.varShowProcess});
        transformedSequenceGroup.setFoldedState(true);
        weightsGroup.setFoldedState(true);
        this.advancedParamsGroup.setFoldedState(true);
    }

    private void addInputComponents() {
        this.addEzComponent((EzComponent)this.varSourceFile);
        this.addEzComponent((EzComponent)this.varTargetFile);
        this.addEzComponent((EzComponent)this.varRegistrationMode);
        this.addEzComponent((EzComponent)this.varInitialSubsampleFactor);
        this.addEzComponent((EzComponent)this.advancedParamsGroup);
    }

    public void declareInput(VarList inputMap) {
        this.initializeInputVariables();
        this.initializeDefaultInputValues();
        this.addInputVariablesToMap(inputMap);
    }

    private void addInputVariablesToMap(VarList inputMap) {
        inputMap.add(this.varSourceFile.name, this.varSourceFile.getVariable());
        inputMap.add(this.varTargetFile.name, this.varTargetFile.getVariable());
        inputMap.add(this.varSourceLandmarks.getName(), (Var)this.varSourceLandmarks);
        inputMap.add(this.varTargetLandmarks.getName(), (Var)this.varTargetLandmarks);
        inputMap.add(this.varRegistrationMode.name, this.varRegistrationMode.getVariable());
        inputMap.add(this.varInitialSubsampleFactor.name, this.varInitialSubsampleFactor.getVariable());
        inputMap.add(this.varInitialDeformationScale.name, this.varInitialDeformationScale.getVariable());
        inputMap.add(this.varFinalDeformationScale.name, this.varFinalDeformationScale.getVariable());
        inputMap.add(this.varTransformedSourceFile.name, this.varTransformedSourceFile.getVariable());
        inputMap.add(this.varTransformedTargetFile.name, this.varTransformedTargetFile.getVariable());
        inputMap.add(this.varDivWeight.name, this.varDivWeight.getVariable());
        inputMap.add(this.varCurlWeight.name, this.varCurlWeight.getVariable());
        inputMap.add(this.varLandmarkWeight.name, this.varLandmarkWeight.getVariable());
        inputMap.add(this.varImageWeight.name, this.varImageWeight.getVariable());
        inputMap.add(this.varConsistencyWeight.name, this.varConsistencyWeight.getVariable());
        inputMap.add(this.varStopThreshold.name, this.varStopThreshold.getVariable());
        inputMap.add(this.varShowProcess.name, this.varShowProcess.getVariable());
        inputMap.add(this.varResultSourceFile.name, this.varResultSourceFile.getVariable());
        inputMap.add(this.varResultTargetFile.name, this.varResultTargetFile.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        this.varEndSignalVar = new VarBoolean("Signal", false);
    }

    protected void execute() {
        this.notifyProgress(Double.NaN, "Starting process...");
        this.createRegistration();
        this.readParameters();
        try {
            this.computeRegistration();
        }
        catch (InterruptedException e) {
            throw new IcyHandledException("Registration interrupted", (Throwable)e);
        }
        catch (BUnwarpRegistrationBigException e) {
            e.printStackTrace();
            throw new IcyHandledException("Could not perform registration", (Throwable)e);
        }
    }

    private void createRegistration() {
        this.registration = new BUnwarpRegistrationBig();
    }

    private void notifyProgress(double progress, String message) {
        if (!this.isHeadLess()) {
            this.getUI().setProgressBarMessage(message);
            this.getUI().setProgressBarValue(progress);
        }
    }

    private void readParameters() {
        this.registration.setSourceFile((File)this.varSourceFile.getValue(true));
        this.registration.setTargetFile((File)this.varTargetFile.getValue(true));
        if (this.varSourceLandmarks.getValue() != null && ((ROI[])this.varSourceLandmarks.getValue()).length > 0 && this.varTargetLandmarks.getValue() != null && ((ROI[])this.varTargetLandmarks.getValue()).length > 0) {
            List<ROI2DPoint> sourceLandmarks = Arrays.stream((Object[])this.varSourceLandmarks.getValue()).filter(roi -> roi instanceof ROI2DPoint).map(roi -> (ROI2DPoint)roi).collect(Collectors.toList());
            List<ROI2DPoint> targetLandmarks = Arrays.stream((Object[])this.varTargetLandmarks.getValue()).filter(roi -> roi instanceof ROI2DPoint).map(roi -> (ROI2DPoint)roi).collect(Collectors.toList());
            if (sourceLandmarks.size() == targetLandmarks.size()) {
                this.registration.setSourceLandmarkROIs(sourceLandmarks);
                this.registration.setTargetLandmarkROIs(targetLandmarks);
            }
        }
        this.registration.setRegistrationMode((RegistrationMode)((Object)this.varRegistrationMode.getValue(true)));
        this.registration.setInitialSubsampleFactor((Integer)this.varInitialSubsampleFactor.getValue(true));
        this.registration.setInitialDeformationScale((DeformationScale)((Object)this.varInitialDeformationScale.getValue(true)));
        this.registration.setFinalDeformationScale((DeformationScale)((Object)this.varFinalDeformationScale.getValue(true)));
        this.registration.setDivWeight((Double)this.varDivWeight.getValue(true));
        this.registration.setCurlWeight((Double)this.varCurlWeight.getValue(true));
        this.registration.setLandmarkWeight((Double)this.varLandmarkWeight.getValue(true));
        this.registration.setImageWeight((Double)this.varImageWeight.getValue(true));
        if (this.registration.getRegistrationMode() != RegistrationMode.MONO) {
            this.registration.setConsistencyWeight((Double)this.varConsistencyWeight.getValue(true));
        }
        this.registration.setStopThreshold((Double)this.varStopThreshold.getValue(true));
        this.registration.setShowProcess((Boolean)this.varShowProcess.getValue(true));
        this.registration.setTransformedSourceFile((File)this.varTransformedSourceFile.getValue(true));
        this.registration.setTransformedTargetFile((File)this.varTransformedTargetFile.getValue(true));
        if (this.varResultSourceFile.getValue() == null) {
            this.registration.setTransformedSourceOutputFile(this.getOutputFileName((File)this.varTransformedSourceFile.getValue(true)));
        } else {
            this.registration.setTransformedSourceOutputFile((File)this.varResultSourceFile.getValue(true));
        }
        if (this.varResultTargetFile.getValue() == null) {
            this.registration.setTransformedTargetOutputFile(this.getOutputFileName((File)this.varTransformedTargetFile.getValue(true)));
        } else {
            this.registration.setTransformedTargetOutputFile((File)this.varResultTargetFile.getValue(true));
        }
    }

    private File getOutputFileName(File inputFile) {
        Path inputFilePath = inputFile.toPath();
        String inputFileName = inputFilePath.getFileName().toString();
        int indexOfExtension = inputFileName.lastIndexOf(46);
        if (indexOfExtension >= 1) {
            inputFileName = inputFileName.substring(0, indexOfExtension);
        }
        inputFileName = inputFileName + "_Warped.tif";
        return inputFilePath.resolveSibling(inputFileName).toFile();
    }

    private void computeRegistration() throws InterruptedException, BUnwarpRegistrationBigException {
        this.addProgressListeners();
        if (this.isHeadLess()) {
            this.varEndSignalVar.setValue((Object)false);
        }
        try {
            this.registration.compute();
        }
        finally {
            this.cleanProgress();
        }
        if (this.isHeadLess()) {
            this.varEndSignalVar.setValue((Object)true);
        }
    }

    private void addProgressListeners() {
        if (!this.isHeadLess()) {
            this.registration.addProgressListener((progress, message, data) -> {
                this.getUI().setProgressBarMessage(message);
                this.getUI().setProgressBarValue(progress);
                return true;
            });
        } else {
            DecimalFormat formatter = new DecimalFormat("000.");
            this.registration.addProgressListener((progress, message, data) -> {
                System.out.format("Registering %s%%: %s\n", formatter.format(progress * 100.0), message);
                return true;
            });
        }
        this.progressSequences = new ArrayList<Sequence>();
        if (((Boolean)this.varShowProcess.getValue()).booleanValue() && !(Icy.getMainInterface() instanceof MainInterfaceBatch)) {
            this.registration.addProgressOutputListener((progress, message, data) -> {
                this.progressSequences.add((Sequence)data);
                this.addSequence((Sequence)data);
                return true;
            });
        }
    }

    private void cleanProgress() {
        this.progressSequences.forEach(s -> this.removeSequence((Sequence)s));
        if (!this.isHeadLess()) {
            this.getUI().setProgressBarValue(0.0);
        }
    }

    public void clean() {
    }
}

