/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.registration.elastic;

import danyfel80.registration.bspline.classic.BUnwarpRegistration;
import danyfel80.registration.bspline.classic.DeformationScale;
import danyfel80.registration.bspline.classic.RegistrationMode;
import danyfel80.registration.bspline.classic.Transformation;
import icy.gui.main.MainInterfaceBatch;
import icy.main.Icy;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.system.IcyHandledException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarEnum;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarSequence;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi2d.ROI2DPoint;

public class SimpleBUnwarp
extends EzPlug
implements EzStoppable,
Block {
    private EzVarSequence varSourceSequence;
    private EzVarSequence varTargetSequence;
    private Var<List<ROI2DPoint>> varSourceLandmarks;
    private Var<List<ROI2DPoint>> varTargetLandmarks;
    private Var<ROI2DArea> varSourceMask;
    private Var<ROI2DArea> varTargetMask;
    private EzVarEnum<RegistrationMode> varRegistrationMode;
    private EzVarInteger varInitialSubsampleFactor;
    private EzVarSequence varTransformedSourceSequence;
    private EzVarSequence varTransformedTargetSequence;
    private EzVarEnum<DeformationScale> varInitialDeformationScale;
    private EzVarEnum<DeformationScale> varFinalDeformationScale;
    private EzVarDouble varDivWeight;
    private EzVarDouble varCurlWeight;
    private EzVarDouble varLandmarkWeight;
    private EzVarDouble varImageWeight;
    private EzVarDouble varConsistencyWeight;
    private EzVarDouble varStopThreshold;
    private EzVarBoolean varShowProcess;
    private EzGroup advancedParamsGroup;
    private BUnwarpRegistration registration;
    private List<Sequence> progressSequences;
    private VarSequence varResultSourceSequence;
    private VarSequence varResultTargetSequence;
    private Var<Transformation> varResultTransformation;

    protected void initialize() {
        this.initializeInputVariables();
        this.initializeInputListeners();
        this.initializeDefaultInputValues();
        this.initializeVariableGroups();
        this.addInputComponents();
    }

    private void initializeInputVariables() {
        this.varSourceSequence = new EzVarSequence("Source image");
        this.varTargetSequence = new EzVarSequence("Target image");
        this.varSourceLandmarks = new Var("Source landmarks", new ArrayList());
        this.varTargetLandmarks = new Var("Target landmarks", new ArrayList());
        this.varSourceMask = new Var("Source mask", (Object)new ROI2DArea());
        this.varTargetMask = new Var("Target mask", (Object)new ROI2DArea());
        this.varRegistrationMode = new EzVarEnum("Registration mode", (Enum[])RegistrationMode.values());
        this.varInitialSubsampleFactor = new EzVarInteger("Starting image subsampling factor", 0, 0, 7, 1);
        this.varTransformedSourceSequence = new EzVarSequence("Transformed source image");
        this.varTransformedTargetSequence = new EzVarSequence("Transformed target image");
        this.varInitialDeformationScale = new EzVarEnum("Initial deformation size", (Enum[])Arrays.stream(DeformationScale.values()).limit(DeformationScale.values().length - 1).toArray(DeformationScale[]::new));
        this.varFinalDeformationScale = new EzVarEnum("Final deformation size", (Enum[])DeformationScale.values());
        this.varDivWeight = new EzVarDouble("Divergence weight");
        this.varCurlWeight = new EzVarDouble("Curl weight");
        this.varLandmarkWeight = new EzVarDouble("Landmark weight");
        this.varImageWeight = new EzVarDouble("Image weight");
        this.varConsistencyWeight = new EzVarDouble("Consistency weight");
        this.varStopThreshold = new EzVarDouble("Stop threshold");
        this.varShowProcess = new EzVarBoolean("Show process", false);
    }

    private void initializeInputListeners() {
        this.varSourceSequence.addVarChangeListener((sourceVar, newSequence) -> this.varTransformedSourceSequence.setValue(newSequence));
        this.varTargetSequence.addVarChangeListener((sourceVar, newSequence) -> this.varTransformedTargetSequence.setValue(newSequence));
        this.varRegistrationMode.addVarChangeListener((sourceVar, newMode) -> this.varConsistencyWeight.setEnabled(newMode != RegistrationMode.MONO));
    }

    private void initializeDefaultInputValues() {
        this.varRegistrationMode.setValue((Object)RegistrationMode.MONO);
        this.varInitialSubsampleFactor.setValue((Object)0);
        this.varInitialDeformationScale.setValue((Object)DeformationScale.VERY_COARSE);
        this.varFinalDeformationScale.setValue((Object)DeformationScale.FINE);
        this.varDivWeight.setValue((Object)0.0);
        this.varCurlWeight.setValue((Object)0.0);
        this.varLandmarkWeight.setValue((Object)0.0);
        this.varImageWeight.setValue((Object)1.0);
        this.varConsistencyWeight.setValue((Object)10.0);
        this.varStopThreshold.setValue((Object)0.01);
        this.varShowProcess.setValue((Object)false);
    }

    private void initializeVariableGroups() {
        EzGroup transformedSequenceGroup = new EzGroup("Images to be transformed", new EzComponent[]{this.varTransformedSourceSequence, this.varTransformedTargetSequence});
        EzGroup weightsGroup = new EzGroup("Weights", new EzComponent[]{this.varDivWeight, this.varCurlWeight, this.varLandmarkWeight, this.varImageWeight, this.varConsistencyWeight});
        this.advancedParamsGroup = new EzGroup("Advanced Parameters", new EzComponent[]{this.varInitialDeformationScale, this.varFinalDeformationScale, transformedSequenceGroup, weightsGroup, this.varStopThreshold, this.varShowProcess});
        transformedSequenceGroup.setFoldedState(true);
        weightsGroup.setFoldedState(true);
        this.advancedParamsGroup.setFoldedState(true);
    }

    private void addInputComponents() {
        this.addEzComponent((EzComponent)this.varSourceSequence);
        this.addEzComponent((EzComponent)this.varTargetSequence);
        this.addEzComponent((EzComponent)this.varRegistrationMode);
        this.addEzComponent((EzComponent)this.varInitialSubsampleFactor);
        this.addEzComponent((EzComponent)this.advancedParamsGroup);
    }

    public void declareInput(VarList inputMap) {
        this.initializeInputVariables();
        this.initializeDefaultInputValues();
        this.addInputVariablesToMap(inputMap);
    }

    private void addInputVariablesToMap(VarList inputMap) {
        inputMap.add(this.varSourceSequence.name, (Var)this.varSourceSequence.getVariable());
        inputMap.add(this.varTargetSequence.name, (Var)this.varTargetSequence.getVariable());
        inputMap.add(this.varSourceLandmarks.getName(), this.varSourceLandmarks);
        inputMap.add(this.varTargetLandmarks.getName(), this.varTargetLandmarks);
        inputMap.add(this.varSourceMask.getName(), this.varSourceMask);
        inputMap.add(this.varTargetMask.getName(), this.varTargetMask);
        inputMap.add(this.varRegistrationMode.name, this.varRegistrationMode.getVariable());
        inputMap.add(this.varInitialSubsampleFactor.name, this.varInitialSubsampleFactor.getVariable());
        inputMap.add(this.varInitialDeformationScale.name, this.varInitialDeformationScale.getVariable());
        inputMap.add(this.varFinalDeformationScale.name, this.varFinalDeformationScale.getVariable());
        inputMap.add(this.varTransformedSourceSequence.name, (Var)this.varTransformedSourceSequence.getVariable());
        inputMap.add(this.varTransformedTargetSequence.name, (Var)this.varTransformedTargetSequence.getVariable());
        inputMap.add(this.varDivWeight.name, this.varDivWeight.getVariable());
        inputMap.add(this.varCurlWeight.name, this.varCurlWeight.getVariable());
        inputMap.add(this.varLandmarkWeight.name, this.varLandmarkWeight.getVariable());
        inputMap.add(this.varImageWeight.name, this.varImageWeight.getVariable());
        inputMap.add(this.varConsistencyWeight.name, this.varConsistencyWeight.getVariable());
        inputMap.add(this.varStopThreshold.name, this.varStopThreshold.getVariable());
        inputMap.add(this.varShowProcess.name, this.varShowProcess.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        this.initializeOutputVariables();
        this.addOutputVariablesToMap(outputMap);
    }

    private void initializeOutputVariables() {
        this.varResultSourceSequence = new VarSequence("Result Source-Target", null);
        this.varResultTargetSequence = new VarSequence("Result Target-Source", null);
        this.varResultTransformation = new Var("Transformation model", Transformation.class);
    }

    private void addOutputVariablesToMap(VarList outputMap) {
        outputMap.add(this.varResultSourceSequence.getName(), (Var)this.varResultSourceSequence);
        outputMap.add(this.varResultTargetSequence.getName(), (Var)this.varResultTargetSequence);
        outputMap.add(this.varResultTransformation.getName(), this.varResultTransformation);
    }

    protected void execute() {
        this.notifyProgress(Double.NaN, "Starting process...");
        this.createRegistration();
        this.readParameters();
        try {
            this.computeRegistration();
        }
        catch (InterruptedException e) {
            throw new IcyHandledException("Registration interrupted", (Throwable)e);
        }
        this.showResults();
    }

    private void createRegistration() {
        this.registration = new BUnwarpRegistration();
    }

    private void notifyProgress(double progress, String message) {
        if (!this.isHeadLess()) {
            this.getUI().setProgressBarMessage(message);
            this.getUI().setProgressBarValue(progress);
        }
    }

    private void readParameters() {
        this.registration.setSourceSequence((Sequence)this.varSourceSequence.getValue(true));
        this.registration.setTargetSequence((Sequence)this.varTargetSequence.getValue(true));
        this.registration.setRegistrationMode((RegistrationMode)((Object)this.varRegistrationMode.getValue(true)));
        this.registration.setInitialSubsampleFactor((Integer)this.varInitialSubsampleFactor.getValue(true));
        this.registration.setTransformedSourceSequence((Sequence)this.varTransformedSourceSequence.getValue(true));
        this.registration.setTransformedTargetSequence((Sequence)this.varTransformedTargetSequence.getValue(true));
        this.registration.setInitialDeformationScale((DeformationScale)((Object)this.varInitialDeformationScale.getValue(true)));
        this.registration.setFinalDeformationScale((DeformationScale)((Object)this.varFinalDeformationScale.getValue(true)));
        this.registration.setDivWeight((Double)this.varDivWeight.getValue(true));
        this.registration.setCurlWeight((Double)this.varCurlWeight.getValue(true));
        this.registration.setLandmarkWeight((Double)this.varLandmarkWeight.getValue(true));
        this.registration.setImageWeight((Double)this.varImageWeight.getValue(true));
        this.registration.setConsistencyWeight((Double)this.varConsistencyWeight.getValue(true));
        this.registration.setStopThreshold((Double)this.varStopThreshold.getValue(true));
        this.registration.setShowProcess((Boolean)this.varShowProcess.getValue(true));
        if (this.varSourceLandmarks.getValue() == null || ((List)this.varSourceLandmarks.getValue()).isEmpty() || this.varTargetLandmarks.getValue() == null || ((List)this.varTargetLandmarks.getValue()).isEmpty()) {
            this.extractLandmarks();
        }
        this.registration.setSourceLandmarks(((List)this.varSourceLandmarks.getValue(true)).stream().map(l -> l.getPoint()).collect(Collectors.toList()));
        this.registration.setTargetLandmarks(((List)this.varTargetLandmarks.getValue(true)).stream().map(l -> l.getPoint()).collect(Collectors.toList()));
        if (this.varSourceMask.getValue() == null || ((ROI2DArea)this.varSourceMask.getValue()).isEmpty() || this.varTargetMask.getValue() == null || ((ROI2DArea)this.varTargetMask.getValue()).isEmpty()) {
            this.extractMasks();
        }
        this.registration.setSourceMask((ROI2DArea)this.varSourceMask.getValue(true));
        this.registration.setTargetMask((ROI2DArea)this.varTargetMask.getValue(true));
    }

    private void extractLandmarks() {
        this.varSourceLandmarks.setValue((Object)this.registration.getSourceSequence().getROIs(ROI2DPoint.class, false));
        this.varTargetLandmarks.setValue((Object)this.registration.getTargetSequence().getROIs(ROI2DPoint.class, false));
        this.organizeLandmarks();
    }

    private void organizeLandmarks() {
        if (((List)this.varSourceLandmarks.getValue()).size() != ((List)this.varTargetLandmarks.getValue()).size()) {
            throw new RuntimeException(String.format("Source landmarks(%d) and target landmarks(%d) have different size.", ((List)this.varSourceLandmarks.getValue()).size(), ((List)this.varTargetLandmarks.getValue()).size()));
        }
        this.varSourceLandmarks.setValue(((List)this.varSourceLandmarks.getValue()).stream().sorted(Comparator.comparing(ROI::getName)).collect(Collectors.toList()));
        this.varTargetLandmarks.setValue(((List)this.varTargetLandmarks.getValue()).stream().sorted(Comparator.comparing(ROI::getName)).collect(Collectors.toList()));
        Iterator itSource = ((List)this.varSourceLandmarks.getValue()).iterator();
        Iterator itTarget = ((List)this.varTargetLandmarks.getValue()).iterator();
        while (itSource.hasNext()) {
            ROI2DPoint sourceLandmark = (ROI2DPoint)itSource.next();
            ROI2DPoint targetLandmark = (ROI2DPoint)itTarget.next();
            if (sourceLandmark.getName().equals(targetLandmark.getName())) continue;
            throw new RuntimeException("No corresponding landmark for " + sourceLandmark.getName());
        }
    }

    private void extractMasks() {
        this.varSourceMask.setValue((Object)new ROI2DArea());
        ((ROI2DArea)this.varSourceMask.getValue()).addRect(0, 0, this.registration.getSourceSequence().getWidth(), this.registration.getSourceSequence().getHeight());
        this.varTargetMask.setValue((Object)new ROI2DArea());
        ((ROI2DArea)this.varTargetMask.getValue()).addRect(0, 0, this.registration.getTargetSequence().getWidth(), this.registration.getTargetSequence().getHeight());
    }

    private void computeRegistration() throws InterruptedException {
        this.addProgressListeners();
        try {
            this.registration.compute();
        }
        finally {
            this.cleanProgress();
        }
    }

    private void addProgressListeners() {
        if (!this.isHeadLess()) {
            this.registration.addProgressListener((progress, message, data) -> {
                this.getUI().setProgressBarMessage(message);
                this.getUI().setProgressBarValue(progress);
                return true;
            });
        } else {
            DecimalFormat formatter = new DecimalFormat("000.##");
            this.registration.addProgressListener((progress, message, data) -> {
                System.out.format("Registering %s%%: %s\n", formatter.format(progress * 100.0), message);
                return true;
            });
        }
        this.progressSequences = new ArrayList<Sequence>();
        if (((Boolean)this.varShowProcess.getValue()).booleanValue() && !(Icy.getMainInterface() instanceof MainInterfaceBatch)) {
            this.registration.addProgressOutputListener((progress, message, data) -> {
                this.progressSequences.add((Sequence)data);
                this.addSequence((Sequence)data);
                return true;
            });
        }
    }

    private void cleanProgress() {
        this.progressSequences.forEach(s -> this.removeSequence((Sequence)s));
        if (!this.isHeadLess()) {
            this.getUI().setProgressBarValue(0.0);
        }
    }

    private void showResults() {
        Sequence transformedInputSource = this.registration.getDirectResult();
        transformedInputSource.setName(this.registration.getSourceSequence().getName() + "_Warped");
        Sequence transformedSource = this.registration.getTransformedDirectResult();
        if (!this.isHeadLess()) {
            this.addSequence(transformedInputSource);
            this.addSequence(transformedSource);
        } else {
            this.varResultSourceSequence.setValue(transformedSource);
            this.varResultTransformation.setValue((Object)this.registration.getTransformation());
        }
        if (this.registration.getRegistrationMode() != RegistrationMode.MONO) {
            Sequence transformedInputTarget = this.registration.getIndirectResult();
            transformedInputTarget.setName(this.registration.getTargetSequence().getName() + "_Warped");
            Sequence transformedTarget = this.registration.getTransformedIndirectResult();
            if (!this.isHeadLess()) {
                this.addSequence(transformedInputTarget);
                this.addSequence(transformedTarget);
            } else {
                this.varResultTargetSequence.setValue(transformedTarget);
            }
        }
    }

    public void clean() {
    }
}

