/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector.detector;

import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.system.thread.ThreadUtil;
import java.util.ArrayList;
import plugins.fab.spotDetector.DetectionSpot;
import plugins.fab.spotDetector.detector.UDWTScale;
import plugins.fab.spotDetector.detector.UDWTWaveletCore;

public class UDWTWavelet {
    private ArrayList<DetectionSpot> detectionResult;

    public ArrayList<DetectionSpot> getDetectionResult() {
        return this.detectionResult;
    }

    public void detect(Sequence inputSequence, boolean detectNegative, boolean useROIforWATComputation, final double[] scaleParameters) throws InterruptedException {
        UDWTWaveletCore waveletCore = new UDWTWaveletCore();
        ArrayList detectionList = new ArrayList();
        Sequence inputComputationSequence = SequenceUtil.getCopy((Sequence)inputSequence);
        for (ROI roi : inputSequence.getROIs()) {
            inputComputationSequence.addROI(roi.getCopy());
        }
        final ArrayList<UDWTScale> UDWTScaleArrayList = new ArrayList<UDWTScale>();
        ThreadUtil.invokeNow((Runnable)new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < scaleParameters.length; ++i) {
                    boolean scaleEnabled = true;
                    if (scaleParameters[i] == 0.0) {
                        scaleEnabled = false;
                    }
                    UDWTScale scale = new UDWTScale(i + 1, scaleEnabled, scaleParameters[i]);
                    UDWTScaleArrayList.add(scale);
                }
            }
        });
        this.detectionResult = waveletCore.computeDetection(true, UDWTScaleArrayList, inputComputationSequence, detectNegative, useROIforWATComputation);
    }
}

