/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector.roi;

import icy.roi.ROI;
import icy.util.XLSUtil;
import icy.util.XMLUtil;
import java.util.ArrayList;
import java.util.HashMap;
import jxl.write.WritableSheet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fab.spotDetector.DetectionSpot;
import plugins.fab.spotDetector.GlobalDetectionToken;
import plugins.kernel.roi.descriptor.measure.ROIInteriorDescriptor;

public class ROI_XLS_Common_Saver {
    public static void saveXLS(WritableSheet page, GlobalDetectionToken gdt, String ROIGeneratorName) throws InterruptedException {
        int row = page.getRows();
        XLSUtil.setCellString((WritableSheet)page, (int)0, (int)row, (String)"Region of interest generated by : ");
        XLSUtil.setCellString((WritableSheet)page, (int)1, (int)row, (String)ROIGeneratorName);
        HashMap<ROI, ArrayList<DetectionSpot>> ROI2Detection = gdt.roi2detection;
        XLSUtil.setCellString((WritableSheet)page, (int)0, (int)(++row), (String)"ROI number");
        XLSUtil.setCellString((WritableSheet)page, (int)1, (int)row, (String)"ROI name");
        XLSUtil.setCellString((WritableSheet)page, (int)2, (int)row, (String)"ROI surface");
        XLSUtil.setCellString((WritableSheet)page, (int)3, (int)row, (String)"ROI nb detection");
        XLSUtil.setCellString((WritableSheet)page, (int)4, (int)row, (String)"ROI tag(s)");
        ++row;
        int nb = 0;
        for (ROI roi : ROI2Detection.keySet()) {
            XLSUtil.setCellNumber((WritableSheet)page, (int)0, (int)row, (double)nb);
            XLSUtil.setCellString((WritableSheet)page, (int)1, (int)row, (String)roi.getName());
            XLSUtil.setCellNumber((WritableSheet)page, (int)2, (int)row, (double)ROI_XLS_Common_Saver.computeROISurface(roi));
            XLSUtil.setCellNumber((WritableSheet)page, (int)3, (int)row, (double)ROI2Detection.get(roi).size());
            int xOffset = 4;
            Node tagNode = gdt.inputSequence.getNode("tags");
            if (tagNode != null) {
                ArrayList roiElementList = XMLUtil.getSubElements((Node)tagNode);
                for (Element roiElement : roiElementList) {
                    int roiId = XMLUtil.getAttributeIntValue((Element)roiElement, (String)"ROI_ID", (int)-1);
                    if (roiId != roi.getId()) continue;
                    ArrayList roiTagList = XMLUtil.getSubElements((Node)roiElement);
                    for (Element tag : roiTagList) {
                        String name = XMLUtil.getAttributeValue((Element)tag, (String)"name", (String)"no name");
                        XLSUtil.setCellString((WritableSheet)page, (int)xOffset, (int)row, (String)name);
                        ++xOffset;
                    }
                }
            }
            ++row;
            ++nb;
        }
        ++row;
        XLSUtil.setCellString((WritableSheet)page, (int)0, (int)(++row), (String)"Detection per ROI");
        int nbROI = 0;
        for (ROI roi : ROI2Detection.keySet()) {
            ++row;
            XLSUtil.setCellString((WritableSheet)page, (int)0, (int)(++row), (String)"ROI Number:");
            XLSUtil.setCellNumber((WritableSheet)page, (int)0, (int)row, (double)nbROI);
            ++row;
            XLSUtil.setCellString((WritableSheet)page, (int)0, (int)(++row), (String)"Detection #");
            XLSUtil.setCellString((WritableSheet)page, (int)1, (int)row, (String)"Surface");
            XLSUtil.setCellString((WritableSheet)page, (int)2, (int)row, (String)"x");
            XLSUtil.setCellString((WritableSheet)page, (int)3, (int)row, (String)"y");
            XLSUtil.setCellString((WritableSheet)page, (int)4, (int)row, (String)"z");
            XLSUtil.setCellString((WritableSheet)page, (int)5, (int)row, (String)"t");
            XLSUtil.setCellString((WritableSheet)page, (int)6, (int)row, (String)"min intensity");
            XLSUtil.setCellString((WritableSheet)page, (int)7, (int)row, (String)"max intensity");
            XLSUtil.setCellString((WritableSheet)page, (int)8, (int)row, (String)"average intensity");
            ++row;
            int detectionNumber = 0;
            for (DetectionSpot detectionSpot : ROI2Detection.get(roi)) {
                XLSUtil.setCellNumber((WritableSheet)page, (int)0, (int)row, (double)detectionNumber);
                XLSUtil.setCellNumber((WritableSheet)page, (int)1, (int)row, (double)detectionSpot.points.size());
                XLSUtil.setCellNumber((WritableSheet)page, (int)2, (int)row, (double)detectionSpot.getMassCenter().x);
                XLSUtil.setCellNumber((WritableSheet)page, (int)3, (int)row, (double)detectionSpot.getMassCenter().y);
                XLSUtil.setCellNumber((WritableSheet)page, (int)4, (int)row, (double)detectionSpot.getMassCenter().z);
                XLSUtil.setCellNumber((WritableSheet)page, (int)5, (int)row, (double)detectionSpot.getT());
                XLSUtil.setCellNumber((WritableSheet)page, (int)6, (int)row, (double)detectionSpot.minIntensity);
                XLSUtil.setCellNumber((WritableSheet)page, (int)7, (int)row, (double)detectionSpot.maxIntensity);
                XLSUtil.setCellNumber((WritableSheet)page, (int)8, (int)row, (double)detectionSpot.meanIntensity);
                ++row;
                ++detectionNumber;
            }
            ++row;
            ++nbROI;
        }
    }

    static int computeROISurface(ROI roi) throws InterruptedException {
        return (int)ROIInteriorDescriptor.computeInterior((ROI)roi);
    }
}

