/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector;

import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLoader;
import icy.plugin.abstract_.Plugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import plugins.fab.spotDetector.GeneralSpotDetectionPanel;
import plugins.fab.spotDetector.GlobalDetectionToken;
import plugins.fab.spotDetector.SpotDetector;
import plugins.fab.spotDetector.detector.DetectorDetectionAbstract;

public class DetectorPanel
extends GeneralSpotDetectionPanel
implements ActionListener {
    private static final long serialVersionUID = 2633014431215333797L;
    JComboBox inputChoice = new JComboBox();
    JPanel pluginPanel = new JPanel();
    DetectorDetectionAbstract detectorDetection = null;

    public DetectorPanel(SpotDetector spotDetector) {
        super(spotDetector);
        this.setTitle("Detector");
        this.pluginPanel.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)this.inputChoice, "North");
        this.add((Component)this.pluginPanel, "Center");
        this.buildInputChoice();
        this.inputChoice.addActionListener(this);
        this.refreshInterface();
    }

    public void process(GlobalDetectionToken gdt) throws InterruptedException {
        this.detectorDetection.process(gdt);
    }

    private void buildInputChoice() {
        this.inputChoice.removeAll();
        for (PluginDescriptor pluginDescriptor : PluginLoader.getPlugins()) {
            if (!pluginDescriptor.isInstanceOf(DetectorDetectionAbstract.class) || pluginDescriptor.isAbstract()) continue;
            this.inputChoice.addItem(pluginDescriptor);
            if (!pluginDescriptor.getClassName().contains("UDWT")) continue;
            this.inputChoice.setSelectedItem(pluginDescriptor);
        }
    }

    public void setDetectorPlugin(PluginDescriptor detectorPluginDescriptorClass) {
        System.out.println("Detector set is " + detectorPluginDescriptorClass);
        for (int i = 0; i < this.inputChoice.getModel().getSize(); ++i) {
            PluginDescriptor pd = (PluginDescriptor)this.inputChoice.getModel().getElementAt(i);
            System.out.println("*" + pd.getClassName() + "*");
            System.out.println("*" + detectorPluginDescriptorClass.getClassName() + "*");
            if (!pd.getClassName().equals(detectorPluginDescriptorClass.getClassName())) continue;
            System.out.println("Match");
            this.inputChoice.setSelectedItem(pd);
            break;
        }
    }

    private void refreshInterface() {
        PluginDescriptor pluginDescriptor = (PluginDescriptor)this.inputChoice.getSelectedItem();
        this.refreshInterface(pluginDescriptor);
    }

    private void refreshInterface(PluginDescriptor pluginDescriptor) {
        this.pluginPanel.removeAll();
        Plugin plugin = null;
        try {
            plugin = (Plugin)pluginDescriptor.getPluginClass().newInstance();
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        this.detectorDetection = (DetectorDetectionAbstract)plugin;
        this.pluginPanel.add((Component)this.detectorDetection.getPanel(), "Center");
        this.pluginPanel.updateUI();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.inputChoice) {
            this.refreshInterface();
        }
    }
}

