/*
 * Decompiled with CFR 0.152.
 */
package be.cytomine.client;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpClient {
    private static final Logger log = LogManager.getLogger(HttpClient.class);
    org.apache.http.client.HttpClient client;
    HttpHost targetHost;
    HttpClientContext localcontext;
    URL URL;
    HttpResponse response;
    Header[] headersArray;
    boolean isAuthByPrivateKey;
    String publicKey;
    String privateKey;
    String host;

    public HttpClient() {
    }

    public HttpClient(String publicKey, String privateKey, String host) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.host = host;
    }

    public void addHeader(String name, String value) {
        Header[] headers = this.headersArray != null ? new Header[this.headersArray.length + 1] : new Header[1];
        for (int i = 0; i < headers.length - 1; ++i) {
            headers[i] = this.headersArray[i];
        }
        headers[headers.length - 1] = new BasicHeader(name, value);
        this.headersArray = headers;
    }

    public void connect(String url, String username, String password) throws IOException {
        this.isAuthByPrivateKey = false;
        log.info("Connection to " + url + " with login=" + username + " and pass=" + password);
        this.URL = new URL(url);
        this.targetHost = new HttpHost(this.URL.getHost(), this.URL.getPort(), this.URL.getProtocol());
        this.client = HttpClientBuilder.create().build();
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(this.targetHost, basicAuth);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
        credsProvider.setCredentials(AuthScope.ANY, creds);
        this.localcontext = HttpClientContext.create();
        this.localcontext.setCredentialsProvider(credsProvider);
        this.localcontext.setAuthCache(authCache);
    }

    public void connect(String url) throws IOException {
        log.info("Connection to " + url);
        this.isAuthByPrivateKey = true;
        this.URL = new URL(url);
        this.targetHost = null;
        this.targetHost = url.substring(0, 8).equals("https://") ? new HttpHost(this.URL.getHost(), 443, "https") : new HttpHost(this.URL.getHost(), this.URL.getPort());
        this.client = HttpClientBuilder.create().build();
        this.localcontext = HttpClientContext.create();
    }

    public int get() throws IOException {
        HttpGet httpGet = new HttpGet(this.URL.toString());
        if (this.isAuthByPrivateKey) {
            httpGet.setHeaders(this.headersArray);
        }
        this.response = this.client.execute(this.targetHost, (HttpRequest)httpGet, (HttpContext)this.localcontext);
        return this.response.getStatusLine().getStatusCode();
    }

    public int get(String url, String dest) throws IOException {
        return this.get(url, dest, true);
    }

    public int get(String url, String dest, boolean redirect) throws IOException {
        boolean isErrorServer;
        log.debug("get:" + url);
        URL URL2 = new URL(url);
        HttpHost targetHost = new HttpHost(URL2.getHost(), URL2.getPort(), URL2.getProtocol());
        log.debug("targetHost:" + targetHost);
        DefaultHttpClient client = new DefaultHttpClient();
        log.debug("client:" + client);
        BasicHttpContext localcontext = new BasicHttpContext();
        log.debug("localcontext:" + localcontext);
        this.headersArray = null;
        this.authorize("GET", URL2.toString(), "", "application/json,*/*");
        HttpGet httpGet = new HttpGet(URL2.getPath());
        httpGet.setHeaders(this.headersArray);
        if (!redirect) {
            BasicHttpParams params = new BasicHttpParams();
            params.setParameter("http.protocol.handle-redirects", false);
            httpGet.setParams(params);
        }
        CloseableHttpResponse response = client.execute(targetHost, (HttpRequest)httpGet, (HttpContext)localcontext);
        int code = response.getStatusLine().getStatusCode();
        log.info("url=" + url + " is " + code + "(OK=" + 200 + ",MOVED=" + 302 + ")");
        boolean isOK = code == 200;
        boolean isFound = code == 302;
        boolean bl = isErrorServer = code == 500;
        if (!isOK && !isFound & !isErrorServer) {
            throw new IOException(url + " cannot be read: " + code);
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            FileOutputStream fos = new FileOutputStream(dest);
            entity.writeTo(fos);
            fos.close();
        }
        if (isFound) {
            Header locationHeader = response.getFirstHeader("location");
            if (locationHeader != null) {
                String redirectLocation = locationHeader.getValue();
                System.out.println("location: " + redirectLocation);
                this.get(redirectLocation, dest);
            } else {
                code = 404;
            }
        }
        return code;
    }

    public int delete() throws IOException {
        log.debug("Delete " + this.URL.getPath());
        HttpDelete httpDelete = new HttpDelete(this.URL.toString());
        if (this.isAuthByPrivateKey) {
            httpDelete.setHeaders(this.headersArray);
        }
        this.response = this.client.execute(this.targetHost, (HttpRequest)httpDelete, (HttpContext)this.localcontext);
        return this.response.getStatusLine().getStatusCode();
    }

    public int post(String data) throws IOException {
        log.debug("Post " + this.URL.getPath());
        HttpPost httpPost = new HttpPost(this.URL.toString());
        if (this.isAuthByPrivateKey) {
            httpPost.setHeaders(this.headersArray);
        }
        log.debug("Post send :" + data.replace("\n", ""));
        BasicHttpEntity entity = new BasicHttpEntity();
        entity.setContent(new ByteArrayInputStream(data.getBytes()));
        entity.setContentLength(data.getBytes().length);
        httpPost.setEntity(entity);
        this.response = this.client.execute(this.targetHost, (HttpRequest)httpPost, (HttpContext)this.localcontext);
        return this.response.getStatusLine().getStatusCode();
    }

    public int put(String data) throws IOException {
        log.debug("Put " + this.URL.getPath());
        HttpPut httpPut = new HttpPut(this.URL.toString());
        if (this.isAuthByPrivateKey) {
            httpPut.setHeaders(this.headersArray);
        }
        log.debug("Put send :" + data.replace("\n", ""));
        BasicHttpEntity entity = new BasicHttpEntity();
        entity.setContent(new ByteArrayInputStream(data.getBytes()));
        entity.setContentLength(data.getBytes().length);
        httpPut.setEntity(entity);
        this.response = this.client.execute(this.targetHost, (HttpRequest)httpPut, (HttpContext)this.localcontext);
        return this.response.getStatusLine().getStatusCode();
    }

    public int post(byte[] data) throws IOException {
        log.debug("POST " + this.URL.toString());
        HttpPost httpPost = new HttpPost(this.URL.toString());
        if (this.isAuthByPrivateKey) {
            httpPost.setHeaders(this.headersArray);
        }
        log.debug("Post send :" + data.length);
        InputStreamEntity reqEntity = new InputStreamEntity((InputStream)new ByteArrayInputStream(data), data.length);
        reqEntity.setContentType("binary/octet-stream");
        reqEntity.setChunked(false);
        BufferedHttpEntity myEntity = null;
        try {
            myEntity = new BufferedHttpEntity(reqEntity);
        }
        catch (IOException e) {
            log.error(e);
        }
        httpPost.setEntity(myEntity);
        this.response = this.client.execute(this.targetHost, (HttpRequest)httpPost, (HttpContext)this.localcontext);
        return this.response.getStatusLine().getStatusCode();
    }

    public int post(MultipartEntity entity) throws IOException {
        log.debug("POST " + this.URL.toString());
        HttpPost httpPost = new HttpPost(this.URL.toString());
        if (this.isAuthByPrivateKey) {
            httpPost.setHeaders(this.headersArray);
        }
        log.debug("Post send :" + entity);
        httpPost.setEntity(entity);
        this.response = this.client.execute(this.targetHost, (HttpRequest)httpPost, (HttpContext)this.localcontext);
        return this.response.getStatusLine().getStatusCode();
    }

    public int put(byte[] data) throws IOException {
        log.debug("Put " + this.URL.getPath());
        HttpPut httpPut = new HttpPut(this.URL.getPath());
        if (this.isAuthByPrivateKey) {
            httpPut.setHeaders(this.headersArray);
        }
        log.debug("Put send :" + data.length);
        InputStreamEntity reqEntity = new InputStreamEntity((InputStream)new ByteArrayInputStream(data), data.length);
        reqEntity.setContentType("binary/octet-stream");
        reqEntity.setChunked(false);
        BufferedHttpEntity myEntity = null;
        try {
            myEntity = new BufferedHttpEntity(reqEntity);
        }
        catch (IOException e) {
            log.error(e);
        }
        httpPut.setEntity(myEntity);
        this.response = this.client.execute(this.targetHost, (HttpRequest)httpPut, (HttpContext)this.localcontext);
        return this.response.getStatusLine().getStatusCode();
    }

    public int download(String dest) throws IOException {
        log.debug("Download " + this.URL.getPath());
        HttpGet httpGet = new HttpGet(this.URL.getPath());
        if (this.isAuthByPrivateKey) {
            httpGet.setHeaders(this.headersArray);
        }
        this.response = this.client.execute(this.targetHost, (HttpRequest)httpGet, (HttpContext)this.localcontext);
        HttpEntity entity = this.response.getEntity();
        if (entity != null) {
            FileOutputStream fos = new FileOutputStream(dest);
            entity.writeTo(fos);
            fos.close();
        }
        return this.response.getStatusLine().getStatusCode();
    }

    public BufferedImage readBufferedImageFromURL(String url) throws IOException {
        boolean isErrorServer;
        log.debug("readBufferedImageFromURL:" + url);
        URL URL2 = new URL(url);
        HttpHost targetHost = new HttpHost(URL2.getHost(), URL2.getPort(), URL2.getProtocol());
        log.debug("targetHost:" + targetHost);
        DefaultHttpClient client = new DefaultHttpClient();
        log.debug("client:" + client);
        BasicHttpContext localcontext = new BasicHttpContext();
        log.debug("localcontext:" + localcontext);
        this.headersArray = null;
        this.authorize("GET", URL2.toString(), "", "application/json,*/*");
        BufferedImage img = null;
        HttpGet httpGet = new HttpGet(URL2.toString());
        httpGet.setHeaders(this.headersArray);
        CloseableHttpResponse response = client.execute(targetHost, (HttpRequest)httpGet, (HttpContext)localcontext);
        int code = response.getStatusLine().getStatusCode();
        log.info("url=" + url + " is " + code + "(OK=" + 200 + ",MOVED=" + 302 + ")");
        boolean isOK = code == 200;
        boolean isFound = code == 302;
        boolean bl = isErrorServer = code == 500;
        if (!isOK && !isFound & !isErrorServer) {
            throw new IOException(url + " cannot be read: " + code);
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            img = ImageIO.read(entity.getContent());
        }
        return img;
    }

    public static BufferedImage readBufferedImageFromPOST(String url, String post) throws IOException {
        boolean isErrorServer;
        log.debug("readBufferedImageFromURL:" + url);
        URL URL2 = new URL(url);
        HttpHost targetHost = new HttpHost(URL2.getHost(), URL2.getPort(), URL2.getProtocol());
        log.debug("targetHost:" + targetHost);
        DefaultHttpClient client = new DefaultHttpClient();
        log.debug("client:" + client);
        BasicHttpContext localcontext = new BasicHttpContext();
        log.debug("localcontext:" + localcontext);
        BufferedImage img = null;
        HttpPost httpPost = new HttpPost(URL2.toString());
        httpPost.setEntity(new StringEntity(post, "UTF-8"));
        CloseableHttpResponse response = client.execute(targetHost, (HttpRequest)httpPost, (HttpContext)localcontext);
        int code = response.getStatusLine().getStatusCode();
        log.info("url=" + url + " is " + code + "(OK=" + 200 + ",MOVED=" + 302 + ")");
        boolean isOK = code == 200;
        boolean isFound = code == 302;
        boolean bl = isErrorServer = code == 500;
        if (!isOK && !isFound & !isErrorServer) {
            throw new IOException(url + " cannot be read: " + code);
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            img = ImageIO.read(entity.getContent());
        }
        return img;
    }

    public static BufferedImage readBufferedImageFromRETRIEVAL(String url, String publicKey, String privateKey, String host) throws IOException {
        boolean isErrorServer;
        log.debug("readBufferedImageFromURL:" + url);
        URL URL2 = new URL(url);
        HttpHost targetHost = new HttpHost(URL2.getHost(), URL2.getPort(), URL2.getProtocol());
        log.debug("targetHost:" + targetHost);
        DefaultHttpClient client = new DefaultHttpClient();
        log.debug("client:" + client);
        BasicHttpContext localcontext = new BasicHttpContext();
        log.debug("localcontext:" + localcontext);
        Header[] headers = HttpClient.authorizeFromRETRIEVAL("GET", URL2.toString(), "", "", publicKey, privateKey, host);
        log.debug("headers:" + headers.length);
        BufferedImage img = null;
        HttpGet httpGet = new HttpGet(URL2.toString());
        httpGet.setHeaders(headers);
        CloseableHttpResponse response = client.execute(targetHost, (HttpRequest)httpGet, (HttpContext)localcontext);
        int code = response.getStatusLine().getStatusCode();
        log.info("url=" + url + " is " + code + "(OK=" + 200 + ",MOVED=" + 302 + ")");
        boolean isOK = code == 200;
        boolean isFound = code == 302;
        boolean bl = isErrorServer = code == 500;
        if (!isOK && !isFound & !isErrorServer) {
            throw new IOException(url + " cannot be read: " + code);
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            log.debug("img=" + entity.getContent());
            img = ImageIO.read(entity.getContent());
        }
        return img;
    }

    public static Header[] authorizeFromRETRIEVAL(String action, String urlFullStr, String contentType, String accept, String publicKey, String privateKey, String host) throws IOException {
        log.debug("authorize: action=" + action + ", url=" + urlFullStr + ", contentType=" + contentType + ",accept=" + accept);
        String url = urlFullStr.replace(host, "");
        log.debug("authorize: url short=" + url);
        Header[] headers = new Header[3];
        headers[0] = new BasicHeader("accept", accept);
        headers[1] = new BasicHeader("date", HttpClient.getActualDateStr());
        String canonicalHeaders = action + "\n\n" + contentType + "\n" + headers[1].getValue() + "\n";
        String messageToSign = canonicalHeaders + url;
        SecretKeySpec privateKeySign = new SecretKeySpec(privateKey.getBytes(), "HmacSHA1");
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(privateKeySign);
            byte[] rawHmac = mac.doFinal(new String(messageToSign.getBytes(), "UTF-8").getBytes());
            byte[] signatureBytes = Base64.encodeBase64(rawHmac, false);
            String authorization = "CYTOMINE " + publicKey + ":" + new String(signatureBytes);
            headers[2] = new BasicHeader("authorization", authorization);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
        return headers;
    }

    public void authorize(String action, String url, String contentType, String accept) throws IOException {
        url = url.replace(this.host, "");
        url = url.replace("http://" + this.host, "");
        url = url.replace("https://" + this.host, "");
        TreeMap<String, String> headers = new TreeMap<String, String>();
        headers.put("accept", accept);
        headers.put("date", HttpClient.getActualDateStr());
        log.debug("AUTHORIZE: " + action + "\\n\\n" + contentType + "\\n" + (String)headers.get("date") + "\n");
        String canonicalHeaders = action + "\n\n" + contentType + "\n" + (String)headers.get("date") + "\n";
        String messageToSign = canonicalHeaders + url;
        log.debug("publicKey=" + this.publicKey);
        log.debug("privateKey=" + this.privateKey);
        log.debug("messageToSign=" + messageToSign);
        SecretKeySpec privateKeySign = new SecretKeySpec(this.privateKey.getBytes(), "HmacSHA1");
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(privateKeySign);
            byte[] rawHmac = mac.doFinal(new String(messageToSign.getBytes(), "UTF-8").getBytes());
            byte[] signatureBytes = Base64.encodeBase64(rawHmac);
            String signature = new String(signatureBytes);
            String authorization = "CYTOMINE " + this.publicKey + ":" + signature;
            log.debug("signature=" + signature);
            log.debug("authorization=" + authorization);
            headers.put("authorization", authorization);
            for (String key : headers.keySet()) {
                this.addHeader(key, (String)headers.get(key));
            }
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    public static String getActualDateStr() {
        Date today = Calendar.getInstance().getTime();
        return new SimpleDateFormat("%E, %d %M %Y %H:%M:%S +0000").format(today);
    }

    public String getResponseData() throws IOException {
        HttpEntity entityResponse = this.response.getEntity();
        return IOUtils.toString(entityResponse.getContent());
    }

    public int getResponseCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public void disconnect() {
        log.debug("Disconnect");
        try {
            this.client.getConnectionManager().shutdown();
        }
        catch (Exception e) {
            log.error(e);
        }
    }
}

