/*
 * Decompiled with CFR 0.152.
 */
package be.cytomine.client.collections;

import be.cytomine.client.Cytomine;
import be.cytomine.client.CytomineConnection;
import be.cytomine.client.CytomineException;
import be.cytomine.client.collections.Collection;
import be.cytomine.client.models.Annotation;
import be.cytomine.client.models.ImageInstance;
import be.cytomine.client.models.Project;
import be.cytomine.client.models.Term;
import be.cytomine.client.models.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnnotationCollection
extends Collection<Annotation> {
    private static final Logger log = LogManager.getLogger(AnnotationCollection.class);
    private static final ArrayList<String> validParameters = new ArrayList();

    public AnnotationCollection(int offset, int max) {
        super(Annotation.class, max, offset);
    }

    public static AnnotationCollection fetchByProject(Project project) throws CytomineException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(project.getClass().getSimpleName().toLowerCase(), project.getId());
        return AnnotationCollection.fetchWithParameters(parameters);
    }

    public static AnnotationCollection fetchByImageInstance(ImageInstance image) throws CytomineException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("image", image.getId());
        return AnnotationCollection.fetchWithParameters(parameters);
    }

    public static AnnotationCollection fetchByUserAndProject(User user, Project project) throws CytomineException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(user.getClass().getSimpleName().toLowerCase(), user.getId());
        parameters.put(project.getClass().getSimpleName().toLowerCase(), project.getId());
        return AnnotationCollection.fetchWithParameters(parameters);
    }

    public static AnnotationCollection fetchByTermAndImageInstance(Term term, ImageInstance image) throws CytomineException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(term.getClass().getSimpleName().toLowerCase(), term.getId());
        parameters.put(Project.class.getSimpleName().toLowerCase(), image.get("project"));
        return AnnotationCollection.fetchWithParameters(parameters);
    }

    public static AnnotationCollection fetchByTermAndProject(Term term, Project project) throws CytomineException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(term.getClass().getSimpleName().toLowerCase(), term.getId());
        parameters.put(project.getClass().getSimpleName().toLowerCase(), project.getId());
        return AnnotationCollection.fetchWithParameters(parameters);
    }

    public static AnnotationCollection fetchWithParameters(Map<String, Object> parameters) throws CytomineException {
        return AnnotationCollection.fetchWithParameters(Cytomine.getInstance().getDefaultCytomineConnection(), parameters, 0, 0);
    }

    public static AnnotationCollection fetchWithParameters(Map<String, Object> parameters, int offset, int max) throws CytomineException {
        return AnnotationCollection.fetchWithParameters(Cytomine.getInstance().getDefaultCytomineConnection(), parameters, offset, max);
    }

    public static AnnotationCollection fetchWithParameters(CytomineConnection connection, Map<String, Object> parameters, int offset, int max) throws CytomineException {
        AnnotationCollection ac = new AnnotationCollection(max, offset);
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            if (!AnnotationCollection.isValid(entry.getKey())) {
                log.warn("parameter not known. It is possible than it has no effect");
            }
            ac.addFilter(entry.getKey(), entry.getValue().toString());
        }
        return (AnnotationCollection)ac.fetch(connection);
    }

    @Override
    protected String getJSONResourceURL() throws CytomineException {
        String start = "/api/annotation.json?";
        Map<String, String> filters = this.getFilters();
        for (Map.Entry<String, String> filter : filters.entrySet()) {
            start = start + "&" + filter.getKey() + "=" + filter.getValue();
        }
        return start;
    }

    private static boolean isValid(String input) {
        return validParameters.contains(input);
    }

    static {
        validParameters.add("project");
        validParameters.add("user");
        validParameters.add("term");
        validParameters.add("image");
        validParameters.add("showDefault");
        validParameters.add("showBasic");
        validParameters.add("showMeta");
        validParameters.add("showWKT");
        validParameters.add("showGIS");
        validParameters.add("showTerm");
        validParameters.add("showAlgo");
        validParameters.add("showUser");
        validParameters.add("showImage");
        validParameters.add("hideBasic");
        validParameters.add("hideMeta");
        validParameters.add("hideWKT");
        validParameters.add("hideGIS");
        validParameters.add("hideTerm");
        validParameters.add("hideAlgo");
        validParameters.add("hideUser");
        validParameters.add("hideImage");
        validParameters.add("job");
        validParameters.add("jobForTermAlgo");
        validParameters.add("suggestedTerm");
        validParameters.add("userForTermAlgo");
        validParameters.add("kmeansValue");
        validParameters.add("users");
        validParameters.add("images");
        validParameters.add("terms");
        validParameters.add("notReviewedOnly");
        validParameters.add("noTerm");
        validParameters.add("noAlgoTerm");
        validParameters.add("multipleTerm");
        validParameters.add("kmeans");
        validParameters.add("bbox");
        validParameters.add("bboxAnnotation");
        validParameters.add("baseAnnotation");
        validParameters.add("maxDistanceBaseAnnotation");
        validParameters.add("term");
    }
}

