/*
 * Decompiled with CFR 0.152.
 */
package be.cytomine.client.collections;

import be.cytomine.client.Cytomine;
import be.cytomine.client.CytomineConnection;
import be.cytomine.client.CytomineException;
import be.cytomine.client.collections.Collection;
import be.cytomine.client.models.AttachedFile;
import be.cytomine.client.models.Model;

public class AttachedFileCollection
extends Collection {
    public AttachedFileCollection() {
        this(0, 0);
    }

    public AttachedFileCollection(int offset, int max) {
        super(AttachedFile.class, max, offset);
    }

    public AttachedFileCollection(Model model) {
        this(model, 0, 0);
    }

    public AttachedFileCollection(Model model, int offset, int max) {
        super(AttachedFile.class, max, offset);
        this.addFilter("domainClassName", Cytomine.convertDomainName(model.getClass().getSimpleName().toLowerCase()));
        this.addFilter("domainIdent", model.getId().toString());
    }

    public static AttachedFileCollection fetchByAssociatedDomain(Model domain) throws CytomineException {
        return AttachedFileCollection.fetchByAssociatedDomain(domain, 0, 0);
    }

    public static AttachedFileCollection fetchByAssociatedDomain(Model domain, int offset, int max) throws CytomineException {
        return AttachedFileCollection.fetchByAssociatedDomain(Cytomine.getInstance().getDefaultCytomineConnection(), domain, offset, max);
    }

    public static AttachedFileCollection fetchByAssociatedDomain(CytomineConnection connection, Model domain) throws CytomineException {
        return AttachedFileCollection.fetchByAssociatedDomain(Cytomine.getInstance().getDefaultCytomineConnection(), domain, 0, 0);
    }

    public static AttachedFileCollection fetchByAssociatedDomain(CytomineConnection connection, Model domain, int offset, int max) throws CytomineException {
        AttachedFileCollection afc = new AttachedFileCollection(max, offset);
        afc.addFilter("domainClassName", Cytomine.convertDomainName(domain.getClass().getSimpleName().toLowerCase()));
        afc.addFilter("domainIdent", domain.getId().toString());
        return (AttachedFileCollection)afc.fetch();
    }

    @Override
    public String getJSONResourceURL() {
        String base = this.isFilterBy("domainClassName") ? "/api/domain/" + this.getFilter("domainClassName") + "/" + this.getFilter("domainIdent") + "/attachedfile.json" : "/api/attachedfile.json";
        return base;
    }
}

