/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.command.process.connected;

import java.util.List;
import org.bioimageanalysis.icy.icytomine.command.process.connected.ConnectedCommandProcess;
import org.bioimageanalysis.icy.icytomine.core.model.Image;

public class ImagesCommandProcess
extends ConnectedCommandProcess<String> {
    private static final String COMMAND = "images";
    private static final String NAME = "List images";
    private static final String[] ARGS_DESCRIPTION = new String[]{"projectID"};
    private static final String DESCRIPTION = "Lists all images associated to a project.";

    @Override
    public String getCommand() {
        return COMMAND;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getArgumentsDescription() {
        return ARGS_DESCRIPTION;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String call() throws Exception {
        if (this.getArguments().length < 1) {
            throw new IllegalArgumentException("Expected at least 1 argument but got 0");
        }
        StringBuffer imageList = new StringBuffer();
        for (int p = 0; p < this.getArguments().length; ++p) {
            Long projectId = Long.parseLong(this.getArguments()[p]);
            List<Image> imgs = this.getClient().getProjectImages(projectId);
            imageList.append("Projects (ID, Name, # User annotations, # Algorithm annotations ):\n");
            for (Image img : imgs) {
                imageList.append(img.getId() + " " + img.getName().orElse("Not specified") + " " + img.getAnnotationsOfUsersNumber().orElse(0L) + " " + img.getAnnotationsOfAlgorithmNumber().orElse(0L) + "\n");
            }
        }
        return imageList.toString();
    }
}

