/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core.model.filters;

import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.model.Annotation;
import org.bioimageanalysis.icy.icytomine.core.model.Term;
import org.bioimageanalysis.icy.icytomine.core.model.filters.AnnotationFilter;

public class AnnotationFilterByTerm
extends AnnotationFilter {
    private Set<TermItem> activeTerms = new HashSet<TermItem>(0);

    public void setActiveTerms(Set<TermItem> activeTerms) {
        Set<TermItem> previousTerms = this.activeTerms;
        this.activeTerms = activeTerms;
        if (!Objects.equal(previousTerms, this.activeTerms)) {
            this.computeActiveAnnotations(AnnotationFilter.ComputationMode.RECOMPUTE_JUST_THIS);
        }
    }

    public Set<TermItem> getActiveTerms() {
        return this.activeTerms;
    }

    @Override
    protected Set<Annotation> applyFilter(Set<Annotation> inputAnnotations) {
        return inputAnnotations.parallelStream().filter(a -> this.isActive((Annotation)a)).collect(Collectors.toSet());
    }

    public Boolean isActive(Annotation annotation) {
        Set<Term> terms;
        try {
            terms = annotation.getAssociatedTerms();
        }
        catch (CytomineClientException e) {
            e.printStackTrace();
            terms = new HashSet<Term>();
        }
        Set termItems = terms.stream().map(t -> new TermItem((Term)t)).collect(Collectors.toSet());
        if (termItems.isEmpty()) {
            termItems.add(TermItem.NO_TERM);
        }
        termItems.retainAll(this.getActiveTerms());
        return !termItems.isEmpty();
    }

    public static class TermItem {
        public static final TermItem NO_TERM = new TermItem(null);
        public static final TermItem ALL = new TermItem(null);
        public static final TermItem NONE = new TermItem(null);
        private Term term;

        public TermItem(Term term) {
            this.term = term;
        }

        public Term getTerm() {
            return this.term;
        }

        public String toString() {
            if (this.term != null) {
                return this.term.getName().orElse("Not specified");
            }
            if (this == ALL) {
                return "Select All";
            }
            if (this == NONE) {
                return "Select None";
            }
            return "No term";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.term == null ? 0 : this.term.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TermItem)) {
                return false;
            }
            TermItem other = (TermItem)obj;
            if (this.term == null) {
                if (other.term != null) {
                    return false;
                }
                if (this == ALL) {
                    return other == ALL;
                }
                if (this == NONE) {
                    return other == NONE;
                }
                if (this == NO_TERM) {
                    return other == NO_TERM;
                }
                return false;
            }
            return this.term.equals(other.term);
        }
    }
}

