/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core.model.filters;

import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.bioimageanalysis.icy.icytomine.core.model.Annotation;
import org.bioimageanalysis.icy.icytomine.core.model.User;
import org.bioimageanalysis.icy.icytomine.core.model.filters.AnnotationFilter;

public class AnnotationFilterByUser
extends AnnotationFilter {
    private Set<UserItem> activeUsers = new HashSet<UserItem>(0);

    public void setActiveUsers(Set<UserItem> activeUsers) {
        Set<UserItem> previousUsers = this.activeUsers;
        this.activeUsers = activeUsers;
        if (!Objects.equal(previousUsers, this.activeUsers)) {
            this.computeActiveAnnotations(AnnotationFilter.ComputationMode.RECOMPUTE_JUST_THIS);
        }
    }

    public Set<UserItem> getActiveUsers() {
        return this.activeUsers;
    }

    @Override
    protected Set<Annotation> applyFilter(Set<Annotation> inputAnnotations) {
        return inputAnnotations.parallelStream().filter(a -> this.isActive((Annotation)a)).collect(Collectors.toSet());
    }

    public Boolean isActive(Annotation annotation) {
        User user = annotation.getUser();
        UserItem userItem = new UserItem(user);
        return this.activeUsers.contains(userItem);
    }

    public static class UserItem {
        public static final UserItem NO_USER = new UserItem(null);
        public static final UserItem ALL = new UserItem(null);
        public static final UserItem NONE = new UserItem(null);
        private User user;

        public UserItem(User user) {
            this.user = user;
        }

        public User getUser() {
            return this.user;
        }

        public String toString() {
            if (this.user != null) {
                return this.user.getName().orElse("Not specified");
            }
            if (this == ALL) {
                return "Select All";
            }
            if (this == NONE) {
                return "Select None";
            }
            return "No user";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof UserItem)) {
                return false;
            }
            UserItem other = (UserItem)obj;
            if (this.user == null) {
                if (other.user != null) {
                    return false;
                }
                if (this == ALL) {
                    return other == ALL;
                }
                if (this == NONE) {
                    return other == NONE;
                }
                if (this == NO_USER) {
                    return other == NO_USER;
                }
                return false;
            }
            return this.user.equals(other.user);
        }
    }
}

