/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import org.bioimageanalysis.icy.icytomine.core.model.Annotation;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.AnnotationTableModel;

public class AnnotationTable
extends JScrollPane {
    private JTable annotationTable = new JTable();
    private AnnotationTableModel annotationTableModel;
    private Set<AnnotationTableModel.AnnotationVisibilityListener> annotationVisibilityListeners = new HashSet<AnnotationTableModel.AnnotationVisibilityListener>();
    private Set<AnnotationSelectionListener> annotationSelectionListeners = new HashSet<AnnotationSelectionListener>();
    private Set<AnnotationDoubleClickListener> annotationDoubleClickListeners = new HashSet<AnnotationDoubleClickListener>();

    public AnnotationTable() {
        this(new HashMap());
    }

    public AnnotationTable(Map<? extends Annotation, Boolean> annotationVisibility) {
        this.setTableModel(annotationVisibility);
        this.setColumnWidths();
        this.setViewportView(this.annotationTable);
        this.addSelectionListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTableModel(Map<? extends Annotation, Boolean> annotationVisibility) {
        AnnotationTableModel newTableModel = new AnnotationTableModel(annotationVisibility);
        JTable jTable = this.annotationTable;
        synchronized (jTable) {
            this.removeAnnotationVisibilityListenersFromTableModel();
            this.annotationTable.setModel(newTableModel);
            this.annotationTableModel = newTableModel;
            newTableModel.fireTableDataChanged();
            this.addAnnotationVisibilityListenersToTableModel();
        }
    }

    public AnnotationTableModel getTableModel() {
        return this.annotationTableModel;
    }

    private void removeAnnotationVisibilityListenersFromTableModel() {
        if (this.annotationTableModel != null) {
            this.annotationVisibilityListeners.forEach(listener -> this.annotationTableModel.removeAnnotationVisibilityListener((AnnotationTableModel.AnnotationVisibilityListener)listener));
        }
    }

    private void addAnnotationVisibilityListenersToTableModel() {
        this.annotationVisibilityListeners.forEach(listener -> this.annotationTableModel.addAnnotationVisibilityListener((AnnotationTableModel.AnnotationVisibilityListener)listener));
    }

    private void setColumnWidths() {
        this.annotationTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.annotationTable.getColumnModel().getColumn(0).setMinWidth(30);
        this.annotationTable.getColumnModel().getColumn(1).setMinWidth(50);
        this.annotationTable.getColumnModel().getColumn(2).setMinWidth(60);
        this.annotationTable.getColumnModel().getColumn(3).setMinWidth(30);
    }

    private void addSelectionListener() {
        this.annotationTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.notifySelectionChange();
            }
        });
        this.annotationTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2 && AnnotationTable.this.annotationTable.getSelectedRow() != -1) {
                    Point point = e.getPoint();
                    int row = AnnotationTable.this.annotationTable.rowAtPoint(point);
                    if (row != -1) {
                        AnnotationTable.this.notifyDoubleClickSelection();
                    }
                }
            }
        });
    }

    private void notifySelectionChange() {
        Set<Annotation> selectedAnnotations = this.getSelectedAnnotations();
        this.annotationSelectionListeners.forEach(l -> l.selectionChanged(selectedAnnotations));
    }

    public Set<Annotation> getSelectedAnnotations() {
        ListSelectionModel selectionModel = this.annotationTable.getSelectionModel();
        HashSet<Annotation> selectedAnnotations = new HashSet<Annotation>();
        if (!selectionModel.isSelectionEmpty()) {
            int minIndex = selectionModel.getMinSelectionIndex();
            int maxIndex = selectionModel.getMaxSelectionIndex();
            for (int i = minIndex; i <= maxIndex; ++i) {
                if (!selectionModel.isSelectedIndex(i)) continue;
                selectedAnnotations.add(((AnnotationTableModel)this.annotationTable.getModel()).getAnnotationAt(i));
            }
        }
        return selectedAnnotations;
    }

    private void notifyDoubleClickSelection() {
        this.annotationDoubleClickListeners.forEach(l -> l.annotationDoubleClicked(this.getSelectedAnnotation()));
    }

    private Annotation getSelectedAnnotation() {
        ListSelectionModel selectionModel = this.annotationTable.getSelectionModel();
        int rowIndex = selectionModel.getMinSelectionIndex();
        if (rowIndex != -1) {
            return ((AnnotationTableModel)this.annotationTable.getModel()).getAnnotationAt(rowIndex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotationVisibilityListener(AnnotationTableModel.AnnotationVisibilityListener listener) {
        JTable jTable = this.annotationTable;
        synchronized (jTable) {
            this.annotationVisibilityListeners.add(listener);
            this.annotationTableModel.addAnnotationVisibilityListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotationVisibilityListener(AnnotationTableModel.AnnotationVisibilityListener listener) {
        JTable jTable = this.annotationTable;
        synchronized (jTable) {
            this.annotationVisibilityListeners.remove(listener);
            if (this.annotationTableModel != null) {
                this.annotationTableModel.removeAnnotationVisibilityListener(listener);
            }
        }
    }

    public void addAnnotationSelectionListener(AnnotationSelectionListener listener) {
        this.annotationSelectionListeners.add(listener);
    }

    public void removeAnnotationSelectionListener(AnnotationSelectionListener listener) {
        this.annotationSelectionListeners.remove(listener);
    }

    public void addAnnotationDoubleClickListener(AnnotationDoubleClickListener listener) {
        this.annotationDoubleClickListeners.add(listener);
    }

    public void removeAnnotationDoubleClickListener(AnnotationDoubleClickListener listener) {
        this.annotationDoubleClickListeners.remove(listener);
    }

    public void setSelectedAnnotations(Set<Annotation> selectedAnnotations) {
        int numAnnotations = this.annotationTableModel.getRowCount();
        this.annotationTable.getSelectionModel().clearSelection();
        boolean firstFound = true;
        for (int row = 0; row < numAnnotations; ++row) {
            Annotation annotationAtRow = this.annotationTableModel.getAnnotationAt(row);
            if (!selectedAnnotations.contains(annotationAtRow)) continue;
            this.annotationTable.getSelectionModel().addSelectionInterval(row, row);
            if (!firstFound) continue;
            this.annotationTable.scrollRectToVisible(this.annotationTable.getCellRect(row, 0, true));
            firstFound = false;
        }
    }

    public static interface AnnotationDoubleClickListener {
        public void annotationDoubleClicked(Annotation var1);
    }

    public static interface AnnotationSelectionListener {
        public void selectionChanged(Set<Annotation> var1);
    }
}

