/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import com.vividsolutions.jts.geom.Geometry;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.referencing.CRS;
import org.opengis.filter.capability.FunctionName;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FilterFunction_setCRS
extends FunctionExpressionImpl {
    public static FunctionName NAME = new FunctionNameImpl("setCRS", Geometry.class, FunctionNameImpl.parameter("geometry", Geometry.class), FunctionNameImpl.parameter("CRS", String.class));

    public FilterFunction_setCRS() {
        super(NAME);
    }

    @Override
    public Object evaluate(Object feature) {
        CoordinateReferenceSystem crs;
        Geometry geom;
        try {
            geom = this.getExpression(0).evaluate(feature, Geometry.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Expected argument of type Geometry for argument #0");
        }
        try {
            crs = this.getExpression(1).evaluate(feature, CoordinateReferenceSystem.class);
            if (crs == null) {
                String srs = this.getExpression(1).evaluate(feature, String.class);
                try {
                    crs = CRS.decode(srs);
                }
                catch (FactoryException e) {
                    crs = CRS.parseWKT(srs);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Expected argument of type CoordinateReferenceSystem, WKT or valid EPSG code for argument #1");
        }
        if (geom != null) {
            geom.setUserData(crs);
        }
        return geom;
    }
}

