/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.cytomine.batch;

import icy.sequence.Sequence;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.bioimageanalysis.icy.icytomine.core.image.annotation.AnnotationInserter;
import org.bioimageanalysis.icy.icytomine.core.image.importer.TiledImageImporter;
import org.bioimageanalysis.icy.icytomine.core.model.Annotation;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.model.Term;
import org.bioimageanalysis.icy.icytomine.core.view.converters.MagnitudeResolutionConverter;
import plugins.adufour.blocks.lang.Loop;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.lang.VarString;
import vars.cytomine.VarCytomineImage;
import vars.geom.VarDimension;

public class CytomineAnnotationLoop
extends Loop {
    private VarList inputMap;
    private VarCytomineImage imageVar;
    private VarInteger resolutionLevelVar;
    private VarDimension paddingSizeVar;
    private VarString termNameVar;
    private VarString includedTermsPerResultVar;
    private Image targetImageInstance;
    private List<Annotation> targetImageAnnotations;
    private Integer targetResolution;
    private Dimension targetPaddingSize;
    private String[] targetTermNames;
    private boolean searchNoTerm;
    private String[] targetIncludedTermNames;
    private boolean addAdditionalNoTerm;
    private ListIterator<Annotation> currentAnnotationIterator;
    private int currentAnnotationIndex;
    private Annotation currentAnnotation;
    private Rectangle2D currentAnnotationPaddedBounds;
    private Set<Term> additionalTerms;
    private Set<Annotation> additionalAnnotations;
    private VarSequence currentAnnotationSequenceVar;
    private Sequence currentAnnotationSequence;

    public void declareInput(VarList inputMap) {
        super.declareInput(inputMap);
        this.setInputMap(inputMap);
        this.initializeInputVariables();
        this.addInputVariables();
    }

    private void setInputMap(VarList inputMap) {
        this.inputMap = inputMap;
    }

    private void initializeInputVariables() {
        this.imageVar = VarCytomineImage.ofNullable(null);
        this.resolutionLevelVar = new VarInteger("Resolution level", 0);
        this.paddingSizeVar = new VarDimension("Padding size");
        this.termNameVar = new VarString("Term name", "No Term");
        this.includedTermsPerResultVar = new VarString("Addition annotations with terms", "");
    }

    private void addInputVariables() {
        this.inputMap.add(this.imageVar.getName(), (Var)this.imageVar);
        this.inputMap.add(this.resolutionLevelVar.getName(), (Var)this.resolutionLevelVar);
        this.inputMap.add(this.paddingSizeVar.getName(), (Var)this.paddingSizeVar);
        this.inputMap.add(this.termNameVar.getName(), (Var)this.termNameVar);
        this.inputMap.add(this.includedTermsPerResultVar.getName(), (Var)this.includedTermsPerResultVar);
    }

    public void declareOutput(VarList outputMap) {
        super.declareOutput(outputMap);
        for (Var var : this.inputMap) {
            outputMap.add(var.getName(), var);
        }
        this.currentAnnotationSequenceVar = new VarSequence("Current annotation sequence", null);
        this.currentAnnotationSequenceVar.setEnabled(false);
        outputMap.add(this.currentAnnotationSequenceVar.getName(), (Var)this.currentAnnotationSequenceVar);
    }

    public void declareLoopVariables(List<Var<?>> loopVariables) {
        for (Var var : this.inputMap) {
            loopVariables.add(var);
        }
        loopVariables.add((Var<?>)this.currentAnnotationSequenceVar);
    }

    public void initializeLoop() {
        this.retrieveParameters();
        this.computeAnnotationsToLoad();
        this.initializeIterators();
    }

    private void retrieveParameters() {
        this.targetImageInstance = (Image)this.imageVar.getValue(true);
        this.targetResolution = this.resolutionLevelVar.getValue(true);
        this.targetPaddingSize = (Dimension)this.paddingSizeVar.getValue();
        this.targetTermNames = ((String)this.termNameVar.getValue(true)).split(",+");
        this.targetIncludedTermNames = ((String)this.includedTermsPerResultVar.getValue(true)).split(" *, *");
        System.out.println(Arrays.toString(this.targetTermNames));
        System.out.println(Arrays.toString(this.targetIncludedTermNames));
        if (this.targetPaddingSize == null) {
            this.targetPaddingSize = new Dimension();
        }
    }

    private void computeAnnotationsToLoad() {
        Set<Term> availableTerms = this.targetImageInstance.getProject().getOntology().getTerms(false);
        Set searchedTerms = availableTerms.stream().filter(t -> Arrays.stream(this.targetTermNames).anyMatch(targetTermName -> Objects.equals(t.getName().orElse("Not available").toLowerCase(), targetTermName.toLowerCase()))).collect(Collectors.toSet());
        this.searchNoTerm = Arrays.stream(this.targetTermNames).anyMatch(name -> name.toLowerCase().equals("no term"));
        this.additionalTerms = availableTerms.stream().filter(t -> Arrays.stream(this.targetIncludedTermNames).anyMatch(targetTermName -> Objects.equals(t.getName().orElse("No Term").toLowerCase(), targetTermName.toLowerCase()))).collect(Collectors.toSet());
        this.addAdditionalNoTerm = Arrays.stream(this.targetIncludedTermNames).anyMatch(name -> name.toLowerCase().equals("no term"));
        System.out.println("Target Terms=" + searchedTerms + ", Additional Terms=" + this.additionalTerms);
        this.targetImageAnnotations = new ArrayList<Annotation>(this.targetImageInstance.getAnnotationsWithGeometry(false));
        if (!searchedTerms.isEmpty() || this.searchNoTerm) {
            this.targetImageAnnotations = this.targetImageAnnotations.stream().filter(a -> {
                boolean isMatch = a.getAssociatedTerms().stream().anyMatch(aTerm -> searchedTerms.contains(aTerm));
                return isMatch || a.getAssociatedTerms().isEmpty() && this.searchNoTerm;
            }).collect(Collectors.toList());
        }
    }

    private void initializeIterators() {
        this.currentAnnotationIterator = this.targetImageAnnotations.listIterator();
        this.currentAnnotationIndex = 0;
    }

    public void beforeIteration() {
        this.importCurrentAnnotationTile();
        this.currentAnnotationSequenceVar.setValue(this.currentAnnotationSequence);
    }

    private void importCurrentAnnotationTile() {
        this.currentAnnotation = this.currentAnnotationIterator.next();
        this.currentAnnotationPaddedBounds = this.getCurrentAnnotationPaddedBounds();
        this.computeAdditionalAnnotations();
        this.computeCurrentAnnotationSequence();
    }

    private Rectangle2D getCurrentAnnotationPaddedBounds() {
        Rectangle2D annotationBounds = this.getCurrentAnnotationBounds();
        Dimension2D targetPaddinSizeAtResolutionZero = MagnitudeResolutionConverter.convertDimension2D(this.targetPaddingSize, this.targetResolution.intValue(), 0.0);
        Rectangle2D.Double annotationPaddedBounds = new Rectangle2D.Double(annotationBounds.getX() - targetPaddinSizeAtResolutionZero.getWidth(), annotationBounds.getY() - targetPaddinSizeAtResolutionZero.getHeight(), annotationBounds.getWidth() + 2.0 * targetPaddinSizeAtResolutionZero.getWidth(), annotationBounds.getHeight() + 2.0 * targetPaddinSizeAtResolutionZero.getHeight());
        return annotationPaddedBounds;
    }

    private Rectangle2D getCurrentAnnotationBounds() {
        return this.currentAnnotation.getYAdjustedBounds();
    }

    private void computeAdditionalAnnotations() {
        List<Annotation> availableAnnotations = this.targetImageInstance.getAnnotationsWithGeometry(false);
        this.additionalAnnotations = availableAnnotations.stream().filter(a -> a.getYAdjustedBounds().intersects(this.currentAnnotationPaddedBounds)).filter(a -> {
            boolean isMatch = a.getAssociatedTerms().stream().anyMatch(annotationTerm -> this.additionalTerms.contains(annotationTerm));
            return isMatch || a.getAssociatedTerms().isEmpty() && this.addAdditionalNoTerm;
        }).collect(Collectors.toSet());
    }

    private void computeCurrentAnnotationSequence() {
        BufferedImage tileImage = this.importTileArea(this.currentAnnotationPaddedBounds);
        this.buildCurrentAnnotationSequence(tileImage);
    }

    private BufferedImage importTileArea(Rectangle2D bounds) {
        TiledImageImporter importer = new TiledImageImporter(this.targetImageInstance);
        Future<BufferedImage> futureTileImage = importer.requestImage(this.targetResolution.intValue(), bounds);
        try {
            return futureTileImage.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private void buildCurrentAnnotationSequence(BufferedImage tileImage) {
        this.currentAnnotationSequence = new Sequence(tileImage);
        this.addCurrentAnnotationROIsToSequence();
        this.addCurrentSequenceMetadata();
    }

    private void addCurrentAnnotationROIsToSequence() {
        AnnotationInserter inserter = new AnnotationInserter(this.currentAnnotationSequence);
        HashSet<Annotation> annotationSet = new HashSet<Annotation>();
        annotationSet.add(this.currentAnnotation);
        annotationSet.addAll(this.additionalAnnotations);
        inserter.insertAnnotations(this.currentAnnotationPaddedBounds, this.targetResolution.intValue(), annotationSet, false);
    }

    private void addCurrentSequenceMetadata() {
        double pixelSize = this.targetImageInstance.getResolution().orElse(1.0);
        double pixelSizeAtTargetResolution = this.getPixelSizeAtTargetResolution();
        this.currentAnnotationSequence.setPositionX(this.currentAnnotationPaddedBounds.getX() * pixelSize);
        this.currentAnnotationSequence.setPositionY(this.currentAnnotationPaddedBounds.getY() * pixelSize);
        this.currentAnnotationSequence.setPixelSizeX(pixelSizeAtTargetResolution);
        this.currentAnnotationSequence.setPixelSizeY(pixelSizeAtTargetResolution);
        this.currentAnnotationSequence.setName(this.targetImageInstance.getName().orElse("Imported image") + " Annotation " + this.currentAnnotation.getId());
    }

    private double getPixelSizeAtTargetResolution() {
        double pixelSize = this.targetImageInstance.getResolution().orElse(1.0);
        double scaleFactor = Math.pow(2.0, this.targetResolution.intValue());
        return pixelSize * scaleFactor;
    }

    public void afterIteration() {
        ++this.currentAnnotationIndex;
        super.afterIteration();
    }

    public boolean isStopConditionReached() {
        return this.currentAnnotationIndex >= this.targetImageAnnotations.size();
    }
}

