/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core.connection.client;

import be.cytomine.client.Cytomine;
import be.cytomine.client.CytomineException;
import be.cytomine.client.collections.AnnotationCollection;
import be.cytomine.client.collections.Collection;
import be.cytomine.client.collections.PropertyCollection;
import be.cytomine.client.models.AbstractImage;
import be.cytomine.client.models.ImageInstance;
import com.google.common.base.Objects;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.connection.client.collection.ImageServers;
import org.bioimageanalysis.icy.icytomine.core.model.Annotation;
import org.bioimageanalysis.icy.icytomine.core.model.AnnotationTerm;
import org.bioimageanalysis.icy.icytomine.core.model.Description;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.model.Ontology;
import org.bioimageanalysis.icy.icytomine.core.model.Project;
import org.bioimageanalysis.icy.icytomine.core.model.Property;
import org.bioimageanalysis.icy.icytomine.core.model.Term;
import org.bioimageanalysis.icy.icytomine.core.model.User;
import org.bioimageanalysis.icy.icytomine.core.model.cache.AnnotationCache;
import org.bioimageanalysis.icy.icytomine.core.model.cache.DescriptionCache;
import org.bioimageanalysis.icy.icytomine.core.model.cache.EntityCacheException;
import org.bioimageanalysis.icy.icytomine.core.model.cache.ImageInstanceCache;
import org.bioimageanalysis.icy.icytomine.core.model.cache.OntologyCache;
import org.bioimageanalysis.icy.icytomine.core.model.cache.ProjectCache;
import org.bioimageanalysis.icy.icytomine.core.model.cache.TermCache;
import org.bioimageanalysis.icy.icytomine.core.model.cache.UserCache;
import org.bioimageanalysis.icy.icytomine.core.model.key.DescriptionId;
import org.bioimageanalysis.icy.icytomine.geom.WKTUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class CytomineClient
implements AutoCloseable {
    private Cytomine internalClient;
    private User currentUser;
    private UserCache userCache;
    private ProjectCache projectCache;
    private DescriptionCache descriptionCache;
    private OntologyCache ontologyCache;
    private TermCache termCache;
    private ImageInstanceCache imageInstanceCache;
    private AnnotationCache annotationCache;

    public static CytomineClient create(URL host, String publicKey, String privateKey) throws CytomineClientException {
        Cytomine client;
        try {
            Cytomine.connection(host.toString(), publicKey, privateKey);
            client = Cytomine.getInstance();
        }
        catch (CytomineException e) {
            throw new CytomineClientException(e);
        }
        CytomineClient cytomineClient = new CytomineClient(client);
        return cytomineClient;
    }

    private CytomineClient(Cytomine client) throws CytomineClientException {
        this.internalClient = client;
        this.checkCurrentUser();
    }

    private void checkCurrentUser() throws CytomineClientException {
        try {
            be.cytomine.client.models.User internalUser = this.getInternalClient().getCurrentUser();
            if (internalUser.getAttr() == null) {
                throw new CytomineClientException(String.format("User credentials not recognized for public key: %s", this.getInternalClient().getPublicKey()));
            }
        }
        catch (CytomineException e) {
            throw new CytomineClientException("Could not connect to server: " + e.getMessage(), e);
        }
    }

    protected Cytomine getInternalClient() {
        return this.internalClient;
    }

    public String getHost() {
        return this.getInternalClient().getHost();
    }

    public String getPublicKey() {
        return this.getInternalClient().getPublicKey();
    }

    public User getCurrentUser() throws CytomineClientException {
        if (this.currentUser == null) {
            this.currentUser = this.downloadCurrentUser();
            this.getUserCache().store(this.currentUser.getId(), this.currentUser);
        }
        return this.currentUser;
    }

    private User downloadCurrentUser() throws CytomineClientException {
        try {
            be.cytomine.client.models.User user = this.getInternalClient().getCurrentUser();
            if (user.getAttr() == null) {
                throw new CytomineClientException("No user data downloaded");
            }
            return new User(this, user);
        }
        catch (CytomineException e) {
            throw new CytomineClientException("Could not download user data", e);
        }
    }

    private UserCache getUserCache() {
        if (this.userCache == null) {
            this.userCache = UserCache.create(this);
        }
        return this.userCache;
    }

    public User getUser(long userId) throws CytomineClientException {
        User user;
        try {
            user = (User)this.getUserCache().retrieve(userId);
        }
        catch (EntityCacheException e) {
            user = this.downloadUser(userId);
            this.getUserCache().store(userId, user);
        }
        return user;
    }

    private User downloadUser(long userId) throws CytomineClientException {
        try {
            be.cytomine.client.models.User user = this.getInternalClient().getCurrentUser();
            if (user.getAttr() == null) {
                throw new CytomineClientException("No user data downloaded");
            }
            return new User(this, user);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download user data (user id=%d)", userId), e);
        }
    }

    public List<Project> getUserProjects(long userId) throws CytomineClientException {
        Collection<be.cytomine.client.models.Project> projectCollection;
        try {
            projectCollection = Collection.fetchWithFilter(be.cytomine.client.models.Project.class, be.cytomine.client.models.User.class, userId, 0, 0);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download user projects (user id=%d)", userId), e);
        }
        ArrayList<Project> projects = new ArrayList<Project>(projectCollection.size());
        for (int i = 0; i < projectCollection.size(); ++i) {
            be.cytomine.client.models.Project p = projectCollection.get(i);
            be.cytomine.client.models.Project newP = new be.cytomine.client.models.Project();
            newP.setAttr(p.getAttr());
            Project project = new Project(this, newP);
            this.getProjectCache().store(project.getId(), project);
            projects.add(project);
        }
        return projects;
    }

    public Project getProject(long projectId) throws CytomineClientException {
        Project project;
        try {
            project = (Project)this.getProjectCache().retrieve(projectId);
        }
        catch (EntityCacheException e) {
            project = this.downloadProject(projectId);
            this.getProjectCache().store(projectId, project);
        }
        return project;
    }

    private ProjectCache getProjectCache() {
        if (this.projectCache == null) {
            this.projectCache = ProjectCache.create(this);
        }
        return this.projectCache;
    }

    private Project downloadProject(long projectId) throws CytomineClientException {
        try {
            be.cytomine.client.models.Project project = (be.cytomine.client.models.Project)new be.cytomine.client.models.Project().fetch(projectId);
            if (project.getAttr() == null) {
                throw new CytomineClientException("No project data downloaded");
            }
            return new Project(this, project);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download project data (project id=%d)", projectId), e);
        }
    }

    public Description getDescription(long describedEntityId, String describedDomainName) throws CytomineClientException {
        Description description;
        DescriptionId descriptionId = new DescriptionId(describedDomainName, describedEntityId);
        try {
            description = (Description)this.getDescriptionCache().retrieve(descriptionId);
        }
        catch (EntityCacheException e) {
            description = this.downloadDescription(descriptionId);
            this.getDescriptionCache().store(descriptionId, description);
        }
        return description;
    }

    private DescriptionCache getDescriptionCache() {
        if (this.descriptionCache == null) {
            this.descriptionCache = DescriptionCache.create(this);
        }
        return this.descriptionCache;
    }

    private Description downloadDescription(DescriptionId descriptionId) throws CytomineClientException {
        try {
            be.cytomine.client.models.Description description = this.getInternalClient().getDescription(descriptionId.getDescribedEntityId(), descriptionId.getDescribedDomainName());
            if (description.getAttr() == null) {
                throw new CytomineClientException("No description data downloaded");
            }
            return new Description(this, description);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download description data (description key=%s)", descriptionId), e);
        }
    }

    public List<User> getProjectUsers(long projectId) throws CytomineClientException {
        Collection<be.cytomine.client.models.User> userCollection;
        try {
            userCollection = Collection.fetchWithFilter(be.cytomine.client.models.User.class, be.cytomine.client.models.Project.class, projectId, 0, 0);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download project users (project id=%d)", projectId), e);
        }
        ArrayList<User> users = new ArrayList<User>(userCollection.size());
        for (int i = 0; i < userCollection.size(); ++i) {
            be.cytomine.client.models.User userIn = userCollection.get(i);
            be.cytomine.client.models.User newUserIn = new be.cytomine.client.models.User();
            newUserIn.setAttr(userIn.getAttr());
            User user = new User(this, newUserIn);
            this.getUserCache().store(user.getId(), user);
            users.add(user);
        }
        return users;
    }

    public Ontology getOntology(long ontologyId) throws CytomineClientException {
        Ontology ontology;
        try {
            ontology = (Ontology)this.getOntologyCache().retrieve(ontologyId);
        }
        catch (EntityCacheException e) {
            ontology = this.downloadOntology(ontologyId);
            this.getOntologyCache().store(ontologyId, ontology);
        }
        return ontology;
    }

    private OntologyCache getOntologyCache() {
        if (this.ontologyCache == null) {
            this.ontologyCache = OntologyCache.create(this);
        }
        return this.ontologyCache;
    }

    private Ontology downloadOntology(long ontologyId) throws CytomineClientException {
        try {
            be.cytomine.client.models.Ontology ontology = (be.cytomine.client.models.Ontology)new be.cytomine.client.models.Ontology().fetch(ontologyId);
            if (ontology.getAttr() == null) {
                throw new CytomineClientException("No ontology data downloaded");
            }
            return new Ontology(this, ontology);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download ontology data (ontology id=%d)", ontologyId), e);
        }
    }

    public Set<Term> getOntologyTerms(long ontologyId) throws CytomineClientException {
        Collection<be.cytomine.client.models.Term> termCollection;
        try {
            termCollection = Collection.fetchWithFilter(be.cytomine.client.models.Term.class, be.cytomine.client.models.Ontology.class, ontologyId, 0, 0);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download ontology terms (ontology id=%d)", ontologyId), e);
        }
        HashSet<Term> terms = new HashSet<Term>(termCollection.size());
        for (int i = 0; i < termCollection.size(); ++i) {
            be.cytomine.client.models.Term inTerm = termCollection.get(i);
            be.cytomine.client.models.Term newInTerm = new be.cytomine.client.models.Term();
            newInTerm.setAttr(inTerm.getAttr());
            Term term = new Term(this, newInTerm);
            this.getTermCache().store(term.getId(), term);
            terms.add(term);
        }
        return terms;
    }

    private TermCache getTermCache() {
        if (this.termCache == null) {
            this.termCache = TermCache.create(this);
        }
        return this.termCache;
    }

    public Term getTerm(long termId) throws CytomineClientException {
        Term term;
        try {
            term = (Term)this.getTermCache().retrieve(termId);
        }
        catch (EntityCacheException e) {
            term = this.downloadTerm(termId);
            this.getTermCache().store(termId, term);
        }
        return term;
    }

    private Term downloadTerm(long termId) throws CytomineClientException {
        try {
            be.cytomine.client.models.Term term = (be.cytomine.client.models.Term)new be.cytomine.client.models.Term().fetch(termId);
            if (term.getAttr() == null) {
                throw new CytomineClientException("No term data downloaded");
            }
            return new Term(this, term);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download term data (term id=%d)", termId), e);
        }
    }

    public List<Image> getProjectImages(long projectId) throws CytomineClientException {
        Collection<ImageInstance> imageInstanceCollection;
        try {
            imageInstanceCollection = Collection.fetchWithFilter(ImageInstance.class, be.cytomine.client.models.Project.class, projectId, 0, 0);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download project images (project id=%d)", projectId), e);
        }
        ArrayList<Image> images = new ArrayList<Image>(imageInstanceCollection.size());
        for (int i = 0; i < imageInstanceCollection.size(); ++i) {
            ImageInstance inImage = imageInstanceCollection.get(i);
            ImageInstance newInImage = new ImageInstance();
            newInImage.setAttr(inImage.getAttr());
            Image image = new Image(this, newInImage);
            this.getImageCache().store(image.getId(), image);
            images.add(image);
        }
        return images;
    }

    private ImageInstanceCache getImageCache() {
        if (this.imageInstanceCache == null) {
            this.imageInstanceCache = ImageInstanceCache.create(this);
        }
        return this.imageInstanceCache;
    }

    public Image getImageInstance(long imageInstanceId) throws CytomineClientException {
        Image image;
        try {
            image = (Image)this.getImageCache().retrieve(imageInstanceId);
        }
        catch (EntityCacheException e) {
            image = this.downloadImage(imageInstanceId);
            this.getImageCache().store(imageInstanceId, image);
        }
        return image;
    }

    private Image downloadImage(long imageInstanceId) throws CytomineClientException {
        ImageInstance imageInstance;
        try {
            imageInstance = (ImageInstance)new ImageInstance().fetch(imageInstanceId);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download image instance data (image instance id=%d)", imageInstanceId), e);
        }
        if (imageInstance.getAttr() == null) {
            throw new CytomineClientException("No image instance data downloaded");
        }
        return new Image(this, imageInstance);
    }

    public List<String> getImageServers(Image image) throws CytomineClientException {
        JSONArray serverJSONArray;
        try {
            AbstractImage abstractImage = new AbstractImage();
            abstractImage.set("id", image.getInternalImage().get("baseImage"));
            Collection<ImageServers> servers = new Collection<ImageServers>(ImageServers.class, 0, 0);
            servers.addFilter("abstractimage", "" + abstractImage.getId());
            JSONObject answer = Cytomine.getInstance().getDefaultCytomineConnection().doGet(servers.toURL());
            serverJSONArray = answer.getOrDefault("imageServersURLs", new JSONArray());
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download image servers (image=%s)", image.toString()), e);
        }
        List<String> serverList = serverJSONArray.stream().map(s -> s.toString().replace(" ", "%20")).collect(Collectors.toList());
        return serverList;
    }

    public BufferedImage downloadImageAsBufferedImage(long imageInstanceId) throws CytomineClientException {
        try {
            String url = this.getHost() + "/api/abstractimage/" + imageInstanceId + "/thumb.png?maxSize=256";
            return this.getInternalClient().getDefaultCytomineConnection().getPictureAsBufferedImage(url, "png");
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download image as buffered image (abstract image id=%d)", imageInstanceId), e);
        }
    }

    public List<Annotation> getImageAnnotations(Image image) throws CytomineClientException {
        AnnotationCollection annotationCollection;
        try {
            annotationCollection = AnnotationCollection.fetchByImageInstance(image.getInternalImage());
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download image annotations (image instance id=%d)", image.getId()), e);
        }
        ArrayList<Annotation> annotations = new ArrayList<Annotation>(annotationCollection.size());
        for (int i = 0; i < annotationCollection.size(); ++i) {
            be.cytomine.client.models.Annotation inAnnotation = (be.cytomine.client.models.Annotation)annotationCollection.get(i);
            be.cytomine.client.models.Annotation newInAnnotation = new be.cytomine.client.models.Annotation();
            newInAnnotation.setAttr(inAnnotation.getAttr());
            Annotation annotation = new Annotation(this, newInAnnotation);
            this.getAnnotationCache().store(annotation.getId(), annotation);
            annotations.add(annotation);
        }
        return annotations;
    }

    public List<Annotation> getImageAnnotations(long imageInstanceId) throws CytomineClientException {
        AnnotationCollection annotationCollection;
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("image", imageInstanceId);
            annotationCollection = AnnotationCollection.fetchWithParameters(parameters);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download image annotations (image instance id=%d)", imageInstanceId), e);
        }
        ArrayList<Annotation> annotations = new ArrayList<Annotation>(annotationCollection.size());
        for (int i = 0; i < annotationCollection.size(); ++i) {
            be.cytomine.client.models.Annotation inAnnotation = (be.cytomine.client.models.Annotation)annotationCollection.get(i);
            be.cytomine.client.models.Annotation newInAnnotation = new be.cytomine.client.models.Annotation();
            newInAnnotation.setAttr(inAnnotation.getAttr());
            Annotation annotation = new Annotation(this, newInAnnotation);
            this.getAnnotationCache().store(annotation.getId(), annotation);
            annotations.add(annotation);
        }
        return annotations;
    }

    private AnnotationCache getAnnotationCache() {
        if (this.annotationCache == null) {
            this.annotationCache = AnnotationCache.create(this);
        }
        return this.annotationCache;
    }

    public List<Annotation> getFullImageAnnotations(long imageInstanceId) throws CytomineClientException {
        AnnotationCollection annotationCollection;
        try {
            Map<String, Object> filters = this.getFullImageAnnotationsFilters(imageInstanceId);
            annotationCollection = AnnotationCollection.fetchWithParameters(filters);
            System.out.println(annotationCollection.toURL());
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download full image annotations (image instance id=%d)", imageInstanceId), e);
        }
        return this.convertAnnotationCollectionToAnnotationList(annotationCollection);
    }

    private List<Annotation> convertAnnotationCollectionToAnnotationList(AnnotationCollection annotationCollection) {
        List<Annotation> annotations = annotationCollection.getList().parallelStream().map(element -> {
            be.cytomine.client.models.Annotation nativeAnnotation = new be.cytomine.client.models.Annotation();
            nativeAnnotation.setAttr((JSONObject)element);
            Annotation annotation = new Annotation(this, nativeAnnotation);
            return annotation;
        }).collect(Collectors.toList());
        annotations.stream().forEach(a -> this.getAnnotationCache().store(a.getId(), a));
        return annotations;
    }

    private Map<String, Object> getFullImageAnnotationsFilters(long imageInstanceId) {
        HashMap<String, Object> filters = new HashMap<String, Object>();
        filters.put("image", String.valueOf(imageInstanceId));
        filters.put("showMeta", "true");
        filters.put("showWKT", "true");
        filters.put("showGIS", "false");
        filters.put("showTerm", "true");
        return filters;
    }

    public List<Annotation> getFullImageAnnotations(Long imageInstanceId, Rectangle2D currentTileArea) throws CytomineClientException {
        AnnotationCollection annotationCollection;
        try {
            Map<String, Object> filters = this.getFullImageAnnotationsFilters(imageInstanceId);
            filters.put("bbox", WKTUtils.createFromRectangle2D(currentTileArea).replace(" ", "%20"));
            annotationCollection = AnnotationCollection.fetchWithParameters(filters);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download full image annotations (image instance id=%d) for area (%s)", imageInstanceId, String.valueOf(currentTileArea)), e);
        }
        ArrayList<Annotation> annotations = new ArrayList<Annotation>(annotationCollection.size());
        for (int i = 0; i < annotationCollection.size(); ++i) {
            be.cytomine.client.models.Annotation newAnnotationIn = new be.cytomine.client.models.Annotation();
            newAnnotationIn.setAttr(((be.cytomine.client.models.Annotation)annotationCollection.get(i)).getAttr());
            Annotation annotation = new Annotation(this, newAnnotationIn);
            this.getAnnotationCache().store(annotation.getId(), annotation);
            annotations.add(annotation);
        }
        return annotations;
    }

    public Annotation getAnnotation(long annotationId) throws CytomineClientException {
        Annotation annotation;
        try {
            annotation = (Annotation)this.getAnnotationCache().retrieve(annotationId);
        }
        catch (EntityCacheException e) {
            annotation = this.downloadAnnotation(annotationId);
            this.getAnnotationCache().store(annotationId, annotation);
        }
        return annotation;
    }

    public Annotation downloadAnnotation(long annotationId) throws CytomineClientException {
        be.cytomine.client.models.Annotation annotation;
        try {
            annotation = (be.cytomine.client.models.Annotation)new be.cytomine.client.models.Annotation().fetch(annotationId);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download annotation data (annotation id=%d)", annotationId), e);
        }
        if (annotation.getAttr() == null) {
            throw new CytomineClientException("No annotation data downloaded");
        }
        return new Annotation(this, annotation);
    }

    public Optional<String> getAnnotationLocation(long annotationId) throws CytomineClientException {
        Annotation annotation = this.downloadAnnotation(annotationId);
        this.getAnnotationCache().store(annotationId, annotation);
        return annotation.getLocation();
    }

    public List<AnnotationTerm> downloadAnnotationTerms(long annotationId) throws CytomineClientException {
        Collection<be.cytomine.client.models.AnnotationTerm> annotationTermCollection;
        try {
            annotationTermCollection = Collection.fetchWithFilter(be.cytomine.client.models.AnnotationTerm.class, be.cytomine.client.models.Annotation.class, annotationId, 0, 0);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download annotation terms (annotation id=%d)", annotationId), e);
        }
        ArrayList<AnnotationTerm> annotationTerms = new ArrayList<AnnotationTerm>(annotationTermCollection.size());
        for (int i = 0; i < annotationTermCollection.size(); ++i) {
            be.cytomine.client.models.AnnotationTerm internalAnnotationTerm = new be.cytomine.client.models.AnnotationTerm();
            internalAnnotationTerm.setAttr(annotationTermCollection.get(i).getAttr());
            AnnotationTerm annotation = new AnnotationTerm(this, internalAnnotationTerm);
            annotationTerms.add(annotation);
        }
        return annotationTerms;
    }

    public BufferedImage downloadPictureAsBufferedImage(String url, String format) throws CytomineClientException {
        try {
            return this.getInternalClient().getDefaultCytomineConnection().getPictureAsBufferedImage(url, format);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(e.getMsg(), e);
        }
    }

    public Annotation addAnnotationWithTerms(long imageInstanceId, String geometry, List<Long> termIds) throws CytomineClientException {
        be.cytomine.client.models.Annotation internalAnnotation;
        try {
            internalAnnotation = (be.cytomine.client.models.Annotation)new be.cytomine.client.models.Annotation(geometry, (Long)imageInstanceId, termIds).save();
        }
        catch (CytomineException e) {
            throw new CytomineClientException("Could not create annotation.", e);
        }
        Annotation annotation = new Annotation(this, internalAnnotation);
        this.getAnnotationCache().store(annotation.getId(), annotation);
        return annotation;
    }

    public void associateTerms(Annotation annotation, Map<Term, Boolean> termSelection) throws CytomineClientException {
        try {
            for (Map.Entry<Term, Boolean> termEntry : termSelection.entrySet()) {
                if (termEntry.getValue().booleanValue()) {
                    new be.cytomine.client.models.AnnotationTerm(annotation.getId(), termEntry.getKey().getId()).save();
                    continue;
                }
                this.getInternalClient().deleteAnnotationTerm(annotation.getId(), termEntry.getKey().getId());
            }
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not associate terms to annotation %d", (long)annotation.getId()), e);
        }
    }

    public void removeAnnotation(long annotationId) throws CytomineClientException {
        try {
            new be.cytomine.client.models.Annotation().delete(annotationId);
            this.getAnnotationCache().remove(annotationId);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not remove annotation %d", annotationId), e);
        }
    }

    public JSONArray getAnnotationUsersByTerm(Annotation annotation) throws CytomineClientException {
        try {
            return Collection.fetchWithFilter(be.cytomine.client.models.Term.class, be.cytomine.client.models.Annotation.class, annotation.getId(), 0, 0).getList();
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not retrieve annotation %d termUsers", annotation.getId()), e);
        }
    }

    public List<Property> getAnnotationProperties(Annotation annotation) {
        PropertyCollection propertyList;
        try {
            propertyList = this.getInternalClient().getDomainProperties("annotation", annotation.getId());
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not retrieve annotation %d properties", annotation.getId()));
        }
        ArrayList<Property> properties = new ArrayList<Property>(propertyList.size());
        for (int i = 0; i < propertyList.size(); ++i) {
            properties.add(new Property(this, (be.cytomine.client.models.Property)propertyList.get(i)));
        }
        return properties;
    }

    public void updateImageMagnfication(Image image, Integer newMagnification) throws CytomineClientException {
        try {
            AbstractImage abstractImage = (AbstractImage)new AbstractImage().fetch(image.getAbstractImageId().get());
            abstractImage.set("magnification", newMagnification);
            abstractImage.update();
            if (!Objects.equal((Object)abstractImage.getInt("magnification"), (Object)newMagnification)) {
                throw new CytomineClientException(String.format("You must be the original uploader of the image", new Object[0]));
            }
            image.getInternalImage().set("magnification", abstractImage.get("magnification"));
        }
        catch (Exception e) {
            throw new CytomineClientException(String.format("Could not set the magnification of the image %s to %sX. " + e.getMessage(), image.getId(), newMagnification), e);
        }
    }

    public void updateImageResolution(Image image, Double newResolution) {
        try {
            AbstractImage abstractImage = (AbstractImage)new AbstractImage().fetch(image.getAbstractImageId().get());
            abstractImage.set("resolution", newResolution);
            abstractImage.update();
            if (!Objects.equal((Object)abstractImage.getDbl("resolution"), (Object)newResolution)) {
                throw new CytomineClientException(String.format("You must be the original uploader of the image", new Object[0]));
            }
            image.getInternalImage().set("resolution", abstractImage.get("resolution"));
        }
        catch (Exception e) {
            throw new CytomineClientException(String.format("Could not set the resolution of the image %s to %s mics/px", image.getId(), newResolution), e);
        }
    }

    public String toString() {
        return String.format("Cytomine client: host=%s, public key=%s", String.valueOf(this.getHost()), String.valueOf(this.getPublicKey()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result;
        if (this.internalClient != null) {
            result += this.getHost().hashCode();
            result = 31 * result + this.getPublicKey().hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CytomineClient)) {
            return false;
        }
        CytomineClient other = (CytomineClient)obj;
        return this.hashCode() == other.hashCode();
    }

    @Override
    public void close() throws Exception {
        this.closeCaches();
    }

    private void closeCaches() {
        UserCache.getCacheManager().removeCache(this.userCache.getCacheAlias());
        ProjectCache.getCacheManager().removeCache(this.projectCache.getCacheAlias());
        DescriptionCache.getCacheManager().removeCache(this.descriptionCache.getCacheAlias());
        OntologyCache.getCacheManager().removeCache(this.ontologyCache.getCacheAlias());
        TermCache.getCacheManager().removeCache(this.termCache.getCacheAlias());
        ImageInstanceCache.getCacheManager().removeCache(this.imageInstanceCache.getCacheAlias());
        AnnotationCache.getCacheManager().removeCache(this.annotationCache.getCacheAlias());
    }
}

